/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalyticsv2.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.kinesisanalyticsv2.model.OutputDescription;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AddApplicationOutputResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String applicationARN;
    private Long applicationVersionId;
    private List<OutputDescription> outputDescriptions;

    public void setApplicationARN(String applicationARN) {
        this.applicationARN = applicationARN;
    }

    public String getApplicationARN() {
        return this.applicationARN;
    }

    public AddApplicationOutputResult withApplicationARN(String applicationARN) {
        this.setApplicationARN(applicationARN);
        return this;
    }

    public void setApplicationVersionId(Long applicationVersionId) {
        this.applicationVersionId = applicationVersionId;
    }

    public Long getApplicationVersionId() {
        return this.applicationVersionId;
    }

    public AddApplicationOutputResult withApplicationVersionId(Long applicationVersionId) {
        this.setApplicationVersionId(applicationVersionId);
        return this;
    }

    public List<OutputDescription> getOutputDescriptions() {
        return this.outputDescriptions;
    }

    public void setOutputDescriptions(Collection<OutputDescription> outputDescriptions) {
        if (outputDescriptions == null) {
            this.outputDescriptions = null;
            return;
        }
        this.outputDescriptions = new ArrayList<OutputDescription>(outputDescriptions);
    }

    public AddApplicationOutputResult withOutputDescriptions(OutputDescription ... outputDescriptions) {
        if (this.outputDescriptions == null) {
            this.setOutputDescriptions(new ArrayList<OutputDescription>(outputDescriptions.length));
        }
        for (OutputDescription ele : outputDescriptions) {
            this.outputDescriptions.add(ele);
        }
        return this;
    }

    public AddApplicationOutputResult withOutputDescriptions(Collection<OutputDescription> outputDescriptions) {
        this.setOutputDescriptions(outputDescriptions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationARN() != null) {
            sb.append("ApplicationARN: ").append(this.getApplicationARN()).append(",");
        }
        if (this.getApplicationVersionId() != null) {
            sb.append("ApplicationVersionId: ").append(this.getApplicationVersionId()).append(",");
        }
        if (this.getOutputDescriptions() != null) {
            sb.append("OutputDescriptions: ").append(this.getOutputDescriptions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddApplicationOutputResult)) {
            return false;
        }
        AddApplicationOutputResult other = (AddApplicationOutputResult)obj;
        if (other.getApplicationARN() == null ^ this.getApplicationARN() == null) {
            return false;
        }
        if (other.getApplicationARN() != null && !other.getApplicationARN().equals(this.getApplicationARN())) {
            return false;
        }
        if (other.getApplicationVersionId() == null ^ this.getApplicationVersionId() == null) {
            return false;
        }
        if (other.getApplicationVersionId() != null && !other.getApplicationVersionId().equals(this.getApplicationVersionId())) {
            return false;
        }
        if (other.getOutputDescriptions() == null ^ this.getOutputDescriptions() == null) {
            return false;
        }
        return other.getOutputDescriptions() == null || other.getOutputDescriptions().equals(this.getOutputDescriptions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationARN() == null ? 0 : this.getApplicationARN().hashCode());
        hashCode = 31 * hashCode + (this.getApplicationVersionId() == null ? 0 : this.getApplicationVersionId().hashCode());
        hashCode = 31 * hashCode + (this.getOutputDescriptions() == null ? 0 : this.getOutputDescriptions().hashCode());
        return hashCode;
    }

    public AddApplicationOutputResult clone() {
        try {
            return (AddApplicationOutputResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

