/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalyticsv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.kinesisanalyticsv2.model.S3ContentBaseLocation;

@SdkInternalApi
public class S3ContentBaseLocationMarshaller {
    private static final MarshallingInfo<String> BUCKETARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BucketARN").build();
    private static final MarshallingInfo<String> BASEPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BasePath").build();
    private static final S3ContentBaseLocationMarshaller instance = new S3ContentBaseLocationMarshaller();

    public static S3ContentBaseLocationMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3ContentBaseLocation s3ContentBaseLocation, ProtocolMarshaller protocolMarshaller) {
        if (s3ContentBaseLocation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3ContentBaseLocation.getBucketARN(), BUCKETARN_BINDING);
            protocolMarshaller.marshall((Object)s3ContentBaseLocation.getBasePath(), BASEPATH_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

