/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalyticsv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kinesisanalyticsv2.model.Output;

@SdkInternalApi
public class OutputMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<StructuredPojo> KINESISSTREAMSOUTPUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KinesisStreamsOutput").build();
    private static final MarshallingInfo<StructuredPojo> KINESISFIREHOSEOUTPUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KinesisFirehoseOutput").build();
    private static final MarshallingInfo<StructuredPojo> LAMBDAOUTPUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LambdaOutput").build();
    private static final MarshallingInfo<StructuredPojo> DESTINATIONSCHEMA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DestinationSchema").build();
    private static final OutputMarshaller instance = new OutputMarshaller();

    public static OutputMarshaller getInstance() {
        return instance;
    }

    public void marshall(Output output, ProtocolMarshaller protocolMarshaller) {
        if (output == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)output.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)output.getKinesisStreamsOutput(), KINESISSTREAMSOUTPUT_BINDING);
            protocolMarshaller.marshall((Object)output.getKinesisFirehoseOutput(), KINESISFIREHOSEOUTPUT_BINDING);
            protocolMarshaller.marshall((Object)output.getLambdaOutput(), LAMBDAOUTPUT_BINDING);
            protocolMarshaller.marshall((Object)output.getDestinationSchema(), DESTINATIONSCHEMA_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

