/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalyticsv2.model.transform;

import com.amazonaws.services.kinesisanalyticsv2.model.S3Configuration;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.UnknownMemberJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class S3ConfigurationJsonUnmarshaller
implements Unmarshaller<S3Configuration, JsonUnmarshallerContext> {
    private static S3ConfigurationJsonUnmarshaller instance;

    public S3Configuration unmarshall(JsonUnmarshallerContext context) throws Exception {
        S3Configuration s3Configuration = new S3Configuration();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            boolean knownMember = false;
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("BucketARN", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    s3Configuration.setBucketARN((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("FileKey", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    s3Configuration.setFileKey((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (token == JsonToken.FIELD_NAME && !knownMember) {
                    context.nextToken();
                    UnknownMemberJsonUnmarshaller.getInstance().unmarshall(context);
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return s3Configuration;
    }

    public static S3ConfigurationJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new S3ConfigurationJsonUnmarshaller();
        }
        return instance;
    }
}

