/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.kms.model.DecryptRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class DecryptRequestMarshaller
implements Marshaller<Request<DecryptRequest>, DecryptRequest> {
    public Request<DecryptRequest> marshall(DecryptRequest decryptRequest) {
        if (decryptRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)decryptRequest, "AWSKMS");
        request.addHeader("X-Amz-Target", "TrentService.Decrypt");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList grantTokensList;
            SdkInternalMap encryptionContextMap;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (decryptRequest.getCiphertextBlob() != null) {
                jsonWriter.key("CiphertextBlob").value(decryptRequest.getCiphertextBlob());
            }
            if (!(encryptionContextMap = (SdkInternalMap)decryptRequest.getEncryptionContext()).isEmpty() || !encryptionContextMap.isAutoConstruct()) {
                jsonWriter.key("EncryptionContext");
                jsonWriter.object();
                for (Map.Entry encryptionContextMapValue : encryptionContextMap.entrySet()) {
                    if (encryptionContextMapValue.getValue() == null) continue;
                    jsonWriter.key((String)encryptionContextMapValue.getKey());
                    jsonWriter.value(encryptionContextMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (!(grantTokensList = (SdkInternalList)decryptRequest.getGrantTokens()).isEmpty() || !grantTokensList.isAutoConstruct()) {
                jsonWriter.key("GrantTokens");
                jsonWriter.array();
                for (String grantTokensListValue : grantTokensList) {
                    if (grantTokensListValue == null) continue;
                    jsonWriter.value((Object)grantTokensListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

