/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.kms.model.ReEncryptRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class ReEncryptRequestMarshaller
implements Marshaller<Request<ReEncryptRequest>, ReEncryptRequest> {
    public Request<ReEncryptRequest> marshall(ReEncryptRequest reEncryptRequest) {
        if (reEncryptRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)reEncryptRequest, "AWSKMS");
        request.addHeader("X-Amz-Target", "TrentService.ReEncrypt");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList grantTokensList;
            SdkInternalMap destinationEncryptionContextMap;
            SdkInternalMap sourceEncryptionContextMap;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (reEncryptRequest.getCiphertextBlob() != null) {
                jsonWriter.key("CiphertextBlob").value(reEncryptRequest.getCiphertextBlob());
            }
            if (!(sourceEncryptionContextMap = (SdkInternalMap)reEncryptRequest.getSourceEncryptionContext()).isEmpty() || !sourceEncryptionContextMap.isAutoConstruct()) {
                jsonWriter.key("SourceEncryptionContext");
                jsonWriter.object();
                for (Map.Entry sourceEncryptionContextMapValue : sourceEncryptionContextMap.entrySet()) {
                    if (sourceEncryptionContextMapValue.getValue() == null) continue;
                    jsonWriter.key((String)sourceEncryptionContextMapValue.getKey());
                    jsonWriter.value(sourceEncryptionContextMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (reEncryptRequest.getDestinationKeyId() != null) {
                jsonWriter.key("DestinationKeyId").value((Object)reEncryptRequest.getDestinationKeyId());
            }
            if (!(destinationEncryptionContextMap = (SdkInternalMap)reEncryptRequest.getDestinationEncryptionContext()).isEmpty() || !destinationEncryptionContextMap.isAutoConstruct()) {
                jsonWriter.key("DestinationEncryptionContext");
                jsonWriter.object();
                for (Map.Entry destinationEncryptionContextMapValue : destinationEncryptionContextMap.entrySet()) {
                    if (destinationEncryptionContextMapValue.getValue() == null) continue;
                    jsonWriter.key((String)destinationEncryptionContextMapValue.getKey());
                    jsonWriter.value(destinationEncryptionContextMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (!(grantTokensList = (SdkInternalList)reEncryptRequest.getGrantTokens()).isEmpty() || !grantTokensList.isAutoConstruct()) {
                jsonWriter.key("GrantTokens");
                jsonWriter.array();
                for (String grantTokensListValue : grantTokensList) {
                    if (grantTokensListValue == null) continue;
                    jsonWriter.value((Object)grantTokensListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

