/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.kms.model.GenerateDataKeyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GenerateDataKeyRequestMarshaller
implements Marshaller<Request<GenerateDataKeyRequest>, GenerateDataKeyRequest> {
    public Request<GenerateDataKeyRequest> marshall(GenerateDataKeyRequest generateDataKeyRequest) {
        if (generateDataKeyRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)generateDataKeyRequest, "AWSKMS");
        request.addHeader("X-Amz-Target", "TrentService.GenerateDataKey");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList grantTokensList;
            SdkInternalMap encryptionContextMap;
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (generateDataKeyRequest.getKeyId() != null) {
                jsonGenerator.writeFieldName("KeyId").writeValue(generateDataKeyRequest.getKeyId());
            }
            if (!(encryptionContextMap = (SdkInternalMap)generateDataKeyRequest.getEncryptionContext()).isEmpty() || !encryptionContextMap.isAutoConstruct()) {
                jsonGenerator.writeFieldName("EncryptionContext");
                jsonGenerator.writeStartObject();
                for (Object encryptionContextMapValue : encryptionContextMap.entrySet()) {
                    if (encryptionContextMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)encryptionContextMapValue.getKey());
                    jsonGenerator.writeValue((String)encryptionContextMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (generateDataKeyRequest.getNumberOfBytes() != null) {
                jsonGenerator.writeFieldName("NumberOfBytes").writeValue((long)generateDataKeyRequest.getNumberOfBytes().intValue());
            }
            if (generateDataKeyRequest.getKeySpec() != null) {
                jsonGenerator.writeFieldName("KeySpec").writeValue(generateDataKeyRequest.getKeySpec());
            }
            if (!(grantTokensList = (SdkInternalList)generateDataKeyRequest.getGrantTokens()).isEmpty() || !grantTokensList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("GrantTokens");
                jsonGenerator.writeStartArray();
                for (String grantTokensListValue : grantTokensList) {
                    if (grantTokensListValue == null) continue;
                    jsonGenerator.writeValue(grantTokensListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

