/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.kms.model.PutKeyPolicyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class PutKeyPolicyRequestMarshaller
implements Marshaller<Request<PutKeyPolicyRequest>, PutKeyPolicyRequest> {
    public Request<PutKeyPolicyRequest> marshall(PutKeyPolicyRequest putKeyPolicyRequest) {
        if (putKeyPolicyRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putKeyPolicyRequest, "AWSKMS");
        request.addHeader("X-Amz-Target", "TrentService.PutKeyPolicy");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (putKeyPolicyRequest.getKeyId() != null) {
                jsonGenerator.writeFieldName("KeyId").writeValue(putKeyPolicyRequest.getKeyId());
            }
            if (putKeyPolicyRequest.getPolicyName() != null) {
                jsonGenerator.writeFieldName("PolicyName").writeValue(putKeyPolicyRequest.getPolicyName());
            }
            if (putKeyPolicyRequest.getPolicy() != null) {
                jsonGenerator.writeFieldName("Policy").writeValue(putKeyPolicyRequest.getPolicy());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

