/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lakeformation;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.lakeformation.AWSLakeFormation;
import com.amazonaws.services.lakeformation.AWSLakeFormationClientBuilder;
import com.amazonaws.services.lakeformation.model.AWSLakeFormationException;
import com.amazonaws.services.lakeformation.model.BatchGrantPermissionsRequest;
import com.amazonaws.services.lakeformation.model.BatchGrantPermissionsResult;
import com.amazonaws.services.lakeformation.model.BatchRevokePermissionsRequest;
import com.amazonaws.services.lakeformation.model.BatchRevokePermissionsResult;
import com.amazonaws.services.lakeformation.model.DeregisterResourceRequest;
import com.amazonaws.services.lakeformation.model.DeregisterResourceResult;
import com.amazonaws.services.lakeformation.model.DescribeResourceRequest;
import com.amazonaws.services.lakeformation.model.DescribeResourceResult;
import com.amazonaws.services.lakeformation.model.GetDataLakeSettingsRequest;
import com.amazonaws.services.lakeformation.model.GetDataLakeSettingsResult;
import com.amazonaws.services.lakeformation.model.GetEffectivePermissionsForPathRequest;
import com.amazonaws.services.lakeformation.model.GetEffectivePermissionsForPathResult;
import com.amazonaws.services.lakeformation.model.GrantPermissionsRequest;
import com.amazonaws.services.lakeformation.model.GrantPermissionsResult;
import com.amazonaws.services.lakeformation.model.ListPermissionsRequest;
import com.amazonaws.services.lakeformation.model.ListPermissionsResult;
import com.amazonaws.services.lakeformation.model.ListResourcesRequest;
import com.amazonaws.services.lakeformation.model.ListResourcesResult;
import com.amazonaws.services.lakeformation.model.PutDataLakeSettingsRequest;
import com.amazonaws.services.lakeformation.model.PutDataLakeSettingsResult;
import com.amazonaws.services.lakeformation.model.RegisterResourceRequest;
import com.amazonaws.services.lakeformation.model.RegisterResourceResult;
import com.amazonaws.services.lakeformation.model.RevokePermissionsRequest;
import com.amazonaws.services.lakeformation.model.RevokePermissionsResult;
import com.amazonaws.services.lakeformation.model.UpdateResourceRequest;
import com.amazonaws.services.lakeformation.model.UpdateResourceResult;
import com.amazonaws.services.lakeformation.model.transform.AlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.lakeformation.model.transform.BatchGrantPermissionsRequestProtocolMarshaller;
import com.amazonaws.services.lakeformation.model.transform.BatchGrantPermissionsResultJsonUnmarshaller;
import com.amazonaws.services.lakeformation.model.transform.BatchRevokePermissionsRequestProtocolMarshaller;
import com.amazonaws.services.lakeformation.model.transform.BatchRevokePermissionsResultJsonUnmarshaller;
import com.amazonaws.services.lakeformation.model.transform.ConcurrentModificationExceptionUnmarshaller;
import com.amazonaws.services.lakeformation.model.transform.DeregisterResourceRequestProtocolMarshaller;
import com.amazonaws.services.lakeformation.model.transform.DeregisterResourceResultJsonUnmarshaller;
import com.amazonaws.services.lakeformation.model.transform.DescribeResourceRequestProtocolMarshaller;
import com.amazonaws.services.lakeformation.model.transform.DescribeResourceResultJsonUnmarshaller;
import com.amazonaws.services.lakeformation.model.transform.EntityNotFoundExceptionUnmarshaller;
import com.amazonaws.services.lakeformation.model.transform.GetDataLakeSettingsRequestProtocolMarshaller;
import com.amazonaws.services.lakeformation.model.transform.GetDataLakeSettingsResultJsonUnmarshaller;
import com.amazonaws.services.lakeformation.model.transform.GetEffectivePermissionsForPathRequestProtocolMarshaller;
import com.amazonaws.services.lakeformation.model.transform.GetEffectivePermissionsForPathResultJsonUnmarshaller;
import com.amazonaws.services.lakeformation.model.transform.GrantPermissionsRequestProtocolMarshaller;
import com.amazonaws.services.lakeformation.model.transform.GrantPermissionsResultJsonUnmarshaller;
import com.amazonaws.services.lakeformation.model.transform.InternalServiceExceptionUnmarshaller;
import com.amazonaws.services.lakeformation.model.transform.InvalidInputExceptionUnmarshaller;
import com.amazonaws.services.lakeformation.model.transform.ListPermissionsRequestProtocolMarshaller;
import com.amazonaws.services.lakeformation.model.transform.ListPermissionsResultJsonUnmarshaller;
import com.amazonaws.services.lakeformation.model.transform.ListResourcesRequestProtocolMarshaller;
import com.amazonaws.services.lakeformation.model.transform.ListResourcesResultJsonUnmarshaller;
import com.amazonaws.services.lakeformation.model.transform.OperationTimeoutExceptionUnmarshaller;
import com.amazonaws.services.lakeformation.model.transform.PutDataLakeSettingsRequestProtocolMarshaller;
import com.amazonaws.services.lakeformation.model.transform.PutDataLakeSettingsResultJsonUnmarshaller;
import com.amazonaws.services.lakeformation.model.transform.RegisterResourceRequestProtocolMarshaller;
import com.amazonaws.services.lakeformation.model.transform.RegisterResourceResultJsonUnmarshaller;
import com.amazonaws.services.lakeformation.model.transform.RevokePermissionsRequestProtocolMarshaller;
import com.amazonaws.services.lakeformation.model.transform.RevokePermissionsResultJsonUnmarshaller;
import com.amazonaws.services.lakeformation.model.transform.UpdateResourceRequestProtocolMarshaller;
import com.amazonaws.services.lakeformation.model.transform.UpdateResourceResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSLakeFormationClient
extends AmazonWebServiceClient
implements AWSLakeFormation {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSLakeFormation.class);
    private static final String DEFAULT_SIGNING_NAME = "lakeformation";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConcurrentModificationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConcurrentModificationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidInputException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidInputExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AlreadyExistsException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AlreadyExistsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("EntityNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)EntityNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("OperationTimeoutException").withExceptionUnmarshaller((JsonErrorUnmarshaller)OperationTimeoutExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServiceException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServiceExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSLakeFormationException.class));

    public static AWSLakeFormationClientBuilder builder() {
        return AWSLakeFormationClientBuilder.standard();
    }

    AWSLakeFormationClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSLakeFormationClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("lakeformation.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/lakeformation/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/lakeformation/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public BatchGrantPermissionsResult batchGrantPermissions(BatchGrantPermissionsRequest request) {
        request = (BatchGrantPermissionsRequest)this.beforeClientExecution(request);
        return this.executeBatchGrantPermissions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchGrantPermissionsResult executeBatchGrantPermissions(BatchGrantPermissionsRequest batchGrantPermissionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchGrantPermissionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchGrantPermissionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchGrantPermissionsRequestProtocolMarshaller(protocolFactory).marshall((BatchGrantPermissionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchGrantPermissionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"LakeFormation");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchGrantPermissions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchGrantPermissionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchGrantPermissionsResult batchGrantPermissionsResult = (BatchGrantPermissionsResult)response.getAwsResponse();
            return batchGrantPermissionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public BatchRevokePermissionsResult batchRevokePermissions(BatchRevokePermissionsRequest request) {
        request = (BatchRevokePermissionsRequest)this.beforeClientExecution(request);
        return this.executeBatchRevokePermissions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchRevokePermissionsResult executeBatchRevokePermissions(BatchRevokePermissionsRequest batchRevokePermissionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchRevokePermissionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchRevokePermissionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchRevokePermissionsRequestProtocolMarshaller(protocolFactory).marshall((BatchRevokePermissionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchRevokePermissionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"LakeFormation");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchRevokePermissions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchRevokePermissionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchRevokePermissionsResult batchRevokePermissionsResult = (BatchRevokePermissionsResult)response.getAwsResponse();
            return batchRevokePermissionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeregisterResourceResult deregisterResource(DeregisterResourceRequest request) {
        request = (DeregisterResourceRequest)this.beforeClientExecution(request);
        return this.executeDeregisterResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeregisterResourceResult executeDeregisterResource(DeregisterResourceRequest deregisterResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deregisterResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeregisterResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeregisterResourceRequestProtocolMarshaller(protocolFactory).marshall((DeregisterResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)deregisterResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"LakeFormation");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeregisterResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeregisterResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeregisterResourceResult deregisterResourceResult = (DeregisterResourceResult)response.getAwsResponse();
            return deregisterResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeResourceResult describeResource(DescribeResourceRequest request) {
        request = (DescribeResourceRequest)this.beforeClientExecution(request);
        return this.executeDescribeResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeResourceResult executeDescribeResource(DescribeResourceRequest describeResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeResourceRequestProtocolMarshaller(protocolFactory).marshall((DescribeResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"LakeFormation");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeResourceResult describeResourceResult = (DescribeResourceResult)response.getAwsResponse();
            return describeResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetDataLakeSettingsResult getDataLakeSettings(GetDataLakeSettingsRequest request) {
        request = (GetDataLakeSettingsRequest)this.beforeClientExecution(request);
        return this.executeGetDataLakeSettings(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetDataLakeSettingsResult executeGetDataLakeSettings(GetDataLakeSettingsRequest getDataLakeSettingsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDataLakeSettingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDataLakeSettingsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDataLakeSettingsRequestProtocolMarshaller(protocolFactory).marshall((GetDataLakeSettingsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getDataLakeSettingsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"LakeFormation");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetDataLakeSettings");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDataLakeSettingsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDataLakeSettingsResult getDataLakeSettingsResult = (GetDataLakeSettingsResult)response.getAwsResponse();
            return getDataLakeSettingsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetEffectivePermissionsForPathResult getEffectivePermissionsForPath(GetEffectivePermissionsForPathRequest request) {
        request = (GetEffectivePermissionsForPathRequest)this.beforeClientExecution(request);
        return this.executeGetEffectivePermissionsForPath(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetEffectivePermissionsForPathResult executeGetEffectivePermissionsForPath(GetEffectivePermissionsForPathRequest getEffectivePermissionsForPathRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getEffectivePermissionsForPathRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetEffectivePermissionsForPathRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetEffectivePermissionsForPathRequestProtocolMarshaller(protocolFactory).marshall((GetEffectivePermissionsForPathRequest)super.beforeMarshalling((AmazonWebServiceRequest)getEffectivePermissionsForPathRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"LakeFormation");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetEffectivePermissionsForPath");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetEffectivePermissionsForPathResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetEffectivePermissionsForPathResult getEffectivePermissionsForPathResult = (GetEffectivePermissionsForPathResult)response.getAwsResponse();
            return getEffectivePermissionsForPathResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GrantPermissionsResult grantPermissions(GrantPermissionsRequest request) {
        request = (GrantPermissionsRequest)this.beforeClientExecution(request);
        return this.executeGrantPermissions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GrantPermissionsResult executeGrantPermissions(GrantPermissionsRequest grantPermissionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(grantPermissionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GrantPermissionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GrantPermissionsRequestProtocolMarshaller(protocolFactory).marshall((GrantPermissionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)grantPermissionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"LakeFormation");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GrantPermissions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GrantPermissionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GrantPermissionsResult grantPermissionsResult = (GrantPermissionsResult)response.getAwsResponse();
            return grantPermissionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListPermissionsResult listPermissions(ListPermissionsRequest request) {
        request = (ListPermissionsRequest)this.beforeClientExecution(request);
        return this.executeListPermissions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListPermissionsResult executeListPermissions(ListPermissionsRequest listPermissionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listPermissionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPermissionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPermissionsRequestProtocolMarshaller(protocolFactory).marshall((ListPermissionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listPermissionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"LakeFormation");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListPermissions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListPermissionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListPermissionsResult listPermissionsResult = (ListPermissionsResult)response.getAwsResponse();
            return listPermissionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListResourcesResult listResources(ListResourcesRequest request) {
        request = (ListResourcesRequest)this.beforeClientExecution(request);
        return this.executeListResources(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListResourcesResult executeListResources(ListResourcesRequest listResourcesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listResourcesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListResourcesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListResourcesRequestProtocolMarshaller(protocolFactory).marshall((ListResourcesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listResourcesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"LakeFormation");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListResources");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListResourcesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListResourcesResult listResourcesResult = (ListResourcesResult)response.getAwsResponse();
            return listResourcesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutDataLakeSettingsResult putDataLakeSettings(PutDataLakeSettingsRequest request) {
        request = (PutDataLakeSettingsRequest)this.beforeClientExecution(request);
        return this.executePutDataLakeSettings(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutDataLakeSettingsResult executePutDataLakeSettings(PutDataLakeSettingsRequest putDataLakeSettingsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putDataLakeSettingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutDataLakeSettingsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutDataLakeSettingsRequestProtocolMarshaller(protocolFactory).marshall((PutDataLakeSettingsRequest)super.beforeMarshalling((AmazonWebServiceRequest)putDataLakeSettingsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"LakeFormation");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutDataLakeSettings");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutDataLakeSettingsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutDataLakeSettingsResult putDataLakeSettingsResult = (PutDataLakeSettingsResult)response.getAwsResponse();
            return putDataLakeSettingsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RegisterResourceResult registerResource(RegisterResourceRequest request) {
        request = (RegisterResourceRequest)this.beforeClientExecution(request);
        return this.executeRegisterResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RegisterResourceResult executeRegisterResource(RegisterResourceRequest registerResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(registerResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RegisterResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RegisterResourceRequestProtocolMarshaller(protocolFactory).marshall((RegisterResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)registerResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"LakeFormation");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RegisterResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RegisterResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RegisterResourceResult registerResourceResult = (RegisterResourceResult)response.getAwsResponse();
            return registerResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RevokePermissionsResult revokePermissions(RevokePermissionsRequest request) {
        request = (RevokePermissionsRequest)this.beforeClientExecution(request);
        return this.executeRevokePermissions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RevokePermissionsResult executeRevokePermissions(RevokePermissionsRequest revokePermissionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(revokePermissionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RevokePermissionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RevokePermissionsRequestProtocolMarshaller(protocolFactory).marshall((RevokePermissionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)revokePermissionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"LakeFormation");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RevokePermissions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RevokePermissionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RevokePermissionsResult revokePermissionsResult = (RevokePermissionsResult)response.getAwsResponse();
            return revokePermissionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateResourceResult updateResource(UpdateResourceRequest request) {
        request = (UpdateResourceRequest)this.beforeClientExecution(request);
        return this.executeUpdateResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateResourceResult executeUpdateResource(UpdateResourceRequest updateResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateResourceRequestProtocolMarshaller(protocolFactory).marshall((UpdateResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"LakeFormation");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateResourceResult updateResourceResult = (UpdateResourceResult)response.getAwsResponse();
            return updateResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

