/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.lakeformation.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/PutDataLakeSettings" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class PutDataLakeSettingsRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata
     * store. It contains database definitions, table definitions, and other control information to manage your Lake
     * Formation environment.
     * </p>
     */
    private String catalogId;
    /**
     * <p>
     * A structure representing a list of Lake Formation principals designated as data lake administrators.
     * </p>
     */
    private DataLakeSettings dataLakeSettings;

    /**
     * <p>
     * The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata
     * store. It contains database definitions, table definitions, and other control information to manage your Lake
     * Formation environment.
     * </p>
     * 
     * @param catalogId
     *        The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent
     *        metadata store. It contains database definitions, table definitions, and other control information to
     *        manage your Lake Formation environment.
     */

    public void setCatalogId(String catalogId) {
        this.catalogId = catalogId;
    }

    /**
     * <p>
     * The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata
     * store. It contains database definitions, table definitions, and other control information to manage your Lake
     * Formation environment.
     * </p>
     * 
     * @return The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent
     *         metadata store. It contains database definitions, table definitions, and other control information to
     *         manage your Lake Formation environment.
     */

    public String getCatalogId() {
        return this.catalogId;
    }

    /**
     * <p>
     * The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata
     * store. It contains database definitions, table definitions, and other control information to manage your Lake
     * Formation environment.
     * </p>
     * 
     * @param catalogId
     *        The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent
     *        metadata store. It contains database definitions, table definitions, and other control information to
     *        manage your Lake Formation environment.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PutDataLakeSettingsRequest withCatalogId(String catalogId) {
        setCatalogId(catalogId);
        return this;
    }

    /**
     * <p>
     * A structure representing a list of Lake Formation principals designated as data lake administrators.
     * </p>
     * 
     * @param dataLakeSettings
     *        A structure representing a list of Lake Formation principals designated as data lake administrators.
     */

    public void setDataLakeSettings(DataLakeSettings dataLakeSettings) {
        this.dataLakeSettings = dataLakeSettings;
    }

    /**
     * <p>
     * A structure representing a list of Lake Formation principals designated as data lake administrators.
     * </p>
     * 
     * @return A structure representing a list of Lake Formation principals designated as data lake administrators.
     */

    public DataLakeSettings getDataLakeSettings() {
        return this.dataLakeSettings;
    }

    /**
     * <p>
     * A structure representing a list of Lake Formation principals designated as data lake administrators.
     * </p>
     * 
     * @param dataLakeSettings
     *        A structure representing a list of Lake Formation principals designated as data lake administrators.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PutDataLakeSettingsRequest withDataLakeSettings(DataLakeSettings dataLakeSettings) {
        setDataLakeSettings(dataLakeSettings);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getCatalogId() != null)
            sb.append("CatalogId: ").append(getCatalogId()).append(",");
        if (getDataLakeSettings() != null)
            sb.append("DataLakeSettings: ").append(getDataLakeSettings());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof PutDataLakeSettingsRequest == false)
            return false;
        PutDataLakeSettingsRequest other = (PutDataLakeSettingsRequest) obj;
        if (other.getCatalogId() == null ^ this.getCatalogId() == null)
            return false;
        if (other.getCatalogId() != null && other.getCatalogId().equals(this.getCatalogId()) == false)
            return false;
        if (other.getDataLakeSettings() == null ^ this.getDataLakeSettings() == null)
            return false;
        if (other.getDataLakeSettings() != null && other.getDataLakeSettings().equals(this.getDataLakeSettings()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getCatalogId() == null) ? 0 : getCatalogId().hashCode());
        hashCode = prime * hashCode + ((getDataLakeSettings() == null) ? 0 : getDataLakeSettings().hashCode());
        return hashCode;
    }

    @Override
    public PutDataLakeSettingsRequest clone() {
        return (PutDataLakeSettingsRequest) super.clone();
    }

}
