/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.lakeformation.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/UpdateResource" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class UpdateResourceRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The new role to use for the given resource registered in Lake Formation.
     * </p>
     */
    private String roleArn;
    /**
     * <p>
     * The resource ARN.
     * </p>
     */
    private String resourceArn;
    /**
     * <p>
     * Whether or not the resource is a federated resource.
     * </p>
     */
    private Boolean withFederation;

    /**
     * <p>
     * The new role to use for the given resource registered in Lake Formation.
     * </p>
     * 
     * @param roleArn
     *        The new role to use for the given resource registered in Lake Formation.
     */

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    /**
     * <p>
     * The new role to use for the given resource registered in Lake Formation.
     * </p>
     * 
     * @return The new role to use for the given resource registered in Lake Formation.
     */

    public String getRoleArn() {
        return this.roleArn;
    }

    /**
     * <p>
     * The new role to use for the given resource registered in Lake Formation.
     * </p>
     * 
     * @param roleArn
     *        The new role to use for the given resource registered in Lake Formation.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateResourceRequest withRoleArn(String roleArn) {
        setRoleArn(roleArn);
        return this;
    }

    /**
     * <p>
     * The resource ARN.
     * </p>
     * 
     * @param resourceArn
     *        The resource ARN.
     */

    public void setResourceArn(String resourceArn) {
        this.resourceArn = resourceArn;
    }

    /**
     * <p>
     * The resource ARN.
     * </p>
     * 
     * @return The resource ARN.
     */

    public String getResourceArn() {
        return this.resourceArn;
    }

    /**
     * <p>
     * The resource ARN.
     * </p>
     * 
     * @param resourceArn
     *        The resource ARN.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateResourceRequest withResourceArn(String resourceArn) {
        setResourceArn(resourceArn);
        return this;
    }

    /**
     * <p>
     * Whether or not the resource is a federated resource.
     * </p>
     * 
     * @param withFederation
     *        Whether or not the resource is a federated resource.
     */

    public void setWithFederation(Boolean withFederation) {
        this.withFederation = withFederation;
    }

    /**
     * <p>
     * Whether or not the resource is a federated resource.
     * </p>
     * 
     * @return Whether or not the resource is a federated resource.
     */

    public Boolean getWithFederation() {
        return this.withFederation;
    }

    /**
     * <p>
     * Whether or not the resource is a federated resource.
     * </p>
     * 
     * @param withFederation
     *        Whether or not the resource is a federated resource.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateResourceRequest withWithFederation(Boolean withFederation) {
        setWithFederation(withFederation);
        return this;
    }

    /**
     * <p>
     * Whether or not the resource is a federated resource.
     * </p>
     * 
     * @return Whether or not the resource is a federated resource.
     */

    public Boolean isWithFederation() {
        return this.withFederation;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getRoleArn() != null)
            sb.append("RoleArn: ").append(getRoleArn()).append(",");
        if (getResourceArn() != null)
            sb.append("ResourceArn: ").append(getResourceArn()).append(",");
        if (getWithFederation() != null)
            sb.append("WithFederation: ").append(getWithFederation());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof UpdateResourceRequest == false)
            return false;
        UpdateResourceRequest other = (UpdateResourceRequest) obj;
        if (other.getRoleArn() == null ^ this.getRoleArn() == null)
            return false;
        if (other.getRoleArn() != null && other.getRoleArn().equals(this.getRoleArn()) == false)
            return false;
        if (other.getResourceArn() == null ^ this.getResourceArn() == null)
            return false;
        if (other.getResourceArn() != null && other.getResourceArn().equals(this.getResourceArn()) == false)
            return false;
        if (other.getWithFederation() == null ^ this.getWithFederation() == null)
            return false;
        if (other.getWithFederation() != null && other.getWithFederation().equals(this.getWithFederation()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getRoleArn() == null) ? 0 : getRoleArn().hashCode());
        hashCode = prime * hashCode + ((getResourceArn() == null) ? 0 : getResourceArn().hashCode());
        hashCode = prime * hashCode + ((getWithFederation() == null) ? 0 : getWithFederation().hashCode());
        return hashCode;
    }

    @Override
    public UpdateResourceRequest clone() {
        return (UpdateResourceRequest) super.clone();
    }

}
