/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.lakeformation.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * An object that defines an Amazon S3 object to be deleted if a transaction cancels, provided that
 * <code>VirtualPut</code> was called before writing the object.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/VirtualObject" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class VirtualObject implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The path to the Amazon S3 object. Must start with s3://
     * </p>
     */
    private String uri;
    /**
     * <p>
     * The ETag of the Amazon S3 object.
     * </p>
     */
    private String eTag;

    /**
     * <p>
     * The path to the Amazon S3 object. Must start with s3://
     * </p>
     * 
     * @param uri
     *        The path to the Amazon S3 object. Must start with s3://
     */

    public void setUri(String uri) {
        this.uri = uri;
    }

    /**
     * <p>
     * The path to the Amazon S3 object. Must start with s3://
     * </p>
     * 
     * @return The path to the Amazon S3 object. Must start with s3://
     */

    public String getUri() {
        return this.uri;
    }

    /**
     * <p>
     * The path to the Amazon S3 object. Must start with s3://
     * </p>
     * 
     * @param uri
     *        The path to the Amazon S3 object. Must start with s3://
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public VirtualObject withUri(String uri) {
        setUri(uri);
        return this;
    }

    /**
     * <p>
     * The ETag of the Amazon S3 object.
     * </p>
     * 
     * @param eTag
     *        The ETag of the Amazon S3 object.
     */

    public void setETag(String eTag) {
        this.eTag = eTag;
    }

    /**
     * <p>
     * The ETag of the Amazon S3 object.
     * </p>
     * 
     * @return The ETag of the Amazon S3 object.
     */

    public String getETag() {
        return this.eTag;
    }

    /**
     * <p>
     * The ETag of the Amazon S3 object.
     * </p>
     * 
     * @param eTag
     *        The ETag of the Amazon S3 object.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public VirtualObject withETag(String eTag) {
        setETag(eTag);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getUri() != null)
            sb.append("Uri: ").append(getUri()).append(",");
        if (getETag() != null)
            sb.append("ETag: ").append(getETag());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof VirtualObject == false)
            return false;
        VirtualObject other = (VirtualObject) obj;
        if (other.getUri() == null ^ this.getUri() == null)
            return false;
        if (other.getUri() != null && other.getUri().equals(this.getUri()) == false)
            return false;
        if (other.getETag() == null ^ this.getETag() == null)
            return false;
        if (other.getETag() != null && other.getETag().equals(this.getETag()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getUri() == null) ? 0 : getUri().hashCode());
        hashCode = prime * hashCode + ((getETag() == null) ? 0 : getETag().hashCode());
        return hashCode;
    }

    @Override
    public VirtualObject clone() {
        try {
            return (VirtualObject) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.lakeformation.model.transform.VirtualObjectMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
