/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.lakeformation;

import javax.annotation.Generated;

import com.amazonaws.services.lakeformation.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSLakeFormation}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSLakeFormation implements AWSLakeFormation {

    protected AbstractAWSLakeFormation() {
    }

    @Override
    public AddLFTagsToResourceResult addLFTagsToResource(AddLFTagsToResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssumeDecoratedRoleWithSAMLResult assumeDecoratedRoleWithSAML(AssumeDecoratedRoleWithSAMLRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchGrantPermissionsResult batchGrantPermissions(BatchGrantPermissionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchRevokePermissionsResult batchRevokePermissions(BatchRevokePermissionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CancelTransactionResult cancelTransaction(CancelTransactionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CommitTransactionResult commitTransaction(CommitTransactionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDataCellsFilterResult createDataCellsFilter(CreateDataCellsFilterRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateLFTagResult createLFTag(CreateLFTagRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateLakeFormationIdentityCenterConfigurationResult createLakeFormationIdentityCenterConfiguration(
            CreateLakeFormationIdentityCenterConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateLakeFormationOptInResult createLakeFormationOptIn(CreateLakeFormationOptInRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDataCellsFilterResult deleteDataCellsFilter(DeleteDataCellsFilterRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteLFTagResult deleteLFTag(DeleteLFTagRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteLakeFormationIdentityCenterConfigurationResult deleteLakeFormationIdentityCenterConfiguration(
            DeleteLakeFormationIdentityCenterConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteLakeFormationOptInResult deleteLakeFormationOptIn(DeleteLakeFormationOptInRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteObjectsOnCancelResult deleteObjectsOnCancel(DeleteObjectsOnCancelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeregisterResourceResult deregisterResource(DeregisterResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeLakeFormationIdentityCenterConfigurationResult describeLakeFormationIdentityCenterConfiguration(
            DescribeLakeFormationIdentityCenterConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeResourceResult describeResource(DescribeResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeTransactionResult describeTransaction(DescribeTransactionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ExtendTransactionResult extendTransaction(ExtendTransactionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDataCellsFilterResult getDataCellsFilter(GetDataCellsFilterRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDataLakeSettingsResult getDataLakeSettings(GetDataLakeSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetEffectivePermissionsForPathResult getEffectivePermissionsForPath(GetEffectivePermissionsForPathRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetLFTagResult getLFTag(GetLFTagRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetQueryStateResult getQueryState(GetQueryStateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetQueryStatisticsResult getQueryStatistics(GetQueryStatisticsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetResourceLFTagsResult getResourceLFTags(GetResourceLFTagsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTableObjectsResult getTableObjects(GetTableObjectsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTemporaryGluePartitionCredentialsResult getTemporaryGluePartitionCredentials(GetTemporaryGluePartitionCredentialsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTemporaryGlueTableCredentialsResult getTemporaryGlueTableCredentials(GetTemporaryGlueTableCredentialsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetWorkUnitResultsResult getWorkUnitResults(GetWorkUnitResultsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetWorkUnitsResult getWorkUnits(GetWorkUnitsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GrantPermissionsResult grantPermissions(GrantPermissionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDataCellsFilterResult listDataCellsFilter(ListDataCellsFilterRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListLFTagsResult listLFTags(ListLFTagsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListLakeFormationOptInsResult listLakeFormationOptIns(ListLakeFormationOptInsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPermissionsResult listPermissions(ListPermissionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListResourcesResult listResources(ListResourcesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTableStorageOptimizersResult listTableStorageOptimizers(ListTableStorageOptimizersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTransactionsResult listTransactions(ListTransactionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutDataLakeSettingsResult putDataLakeSettings(PutDataLakeSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RegisterResourceResult registerResource(RegisterResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RemoveLFTagsFromResourceResult removeLFTagsFromResource(RemoveLFTagsFromResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RevokePermissionsResult revokePermissions(RevokePermissionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchDatabasesByLFTagsResult searchDatabasesByLFTags(SearchDatabasesByLFTagsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchTablesByLFTagsResult searchTablesByLFTags(SearchTablesByLFTagsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartQueryPlanningResult startQueryPlanning(StartQueryPlanningRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartTransactionResult startTransaction(StartTransactionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDataCellsFilterResult updateDataCellsFilter(UpdateDataCellsFilterRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateLFTagResult updateLFTag(UpdateLFTagRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateLakeFormationIdentityCenterConfigurationResult updateLakeFormationIdentityCenterConfiguration(
            UpdateLakeFormationIdentityCenterConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateResourceResult updateResource(UpdateResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateTableObjectsResult updateTableObjects(UpdateTableObjectsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateTableStorageOptimizerResult updateTableStorageOptimizer(UpdateTableStorageOptimizerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
