/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.lambda.model.AliasConfiguration;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListAliasesResult
implements Serializable,
Cloneable {
    private String nextMarker;
    private SdkInternalList<AliasConfiguration> aliases;

    public void setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
    }

    public String getNextMarker() {
        return this.nextMarker;
    }

    public ListAliasesResult withNextMarker(String nextMarker) {
        this.setNextMarker(nextMarker);
        return this;
    }

    public List<AliasConfiguration> getAliases() {
        if (this.aliases == null) {
            this.aliases = new SdkInternalList();
        }
        return this.aliases;
    }

    public void setAliases(Collection<AliasConfiguration> aliases) {
        if (aliases == null) {
            this.aliases = null;
            return;
        }
        this.aliases = new SdkInternalList(aliases);
    }

    public ListAliasesResult withAliases(AliasConfiguration ... aliases) {
        if (this.aliases == null) {
            this.setAliases((Collection<AliasConfiguration>)new SdkInternalList(aliases.length));
        }
        for (AliasConfiguration ele : aliases) {
            this.aliases.add((Object)ele);
        }
        return this;
    }

    public ListAliasesResult withAliases(Collection<AliasConfiguration> aliases) {
        this.setAliases(aliases);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextMarker() != null) {
            sb.append("NextMarker: " + this.getNextMarker() + ",");
        }
        if (this.getAliases() != null) {
            sb.append("Aliases: " + this.getAliases());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAliasesResult)) {
            return false;
        }
        ListAliasesResult other = (ListAliasesResult)obj;
        if (other.getNextMarker() == null ^ this.getNextMarker() == null) {
            return false;
        }
        if (other.getNextMarker() != null && !other.getNextMarker().equals(this.getNextMarker())) {
            return false;
        }
        if (other.getAliases() == null ^ this.getAliases() == null) {
            return false;
        }
        return other.getAliases() == null || other.getAliases().equals(this.getAliases());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextMarker() == null ? 0 : this.getNextMarker().hashCode());
        hashCode = 31 * hashCode + (this.getAliases() == null ? 0 : this.getAliases().hashCode());
        return hashCode;
    }

    public ListAliasesResult clone() {
        try {
            return (ListAliasesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

