/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.lambda.model.GetFunctionConfigurationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetFunctionConfigurationRequestMarshaller
implements Marshaller<Request<GetFunctionConfigurationRequest>, GetFunctionConfigurationRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetFunctionConfigurationRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetFunctionConfigurationRequest> marshall(GetFunctionConfigurationRequest getFunctionConfigurationRequest) {
        if (getFunctionConfigurationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getFunctionConfigurationRequest, "AWSLambda");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2015-03-31/functions/{FunctionName}/configuration";
        uriResourcePath = uriResourcePath.replace("{FunctionName}", getFunctionConfigurationRequest.getFunctionName() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)getFunctionConfigurationRequest.getFunctionName()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        if (getFunctionConfigurationRequest.getQualifier() != null) {
            request.addParameter("Qualifier", StringUtils.fromString((String)getFunctionConfigurationRequest.getQualifier()));
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

