/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lambda.model.ApplicationLogLevel;
import com.amazonaws.services.lambda.model.LogFormat;
import com.amazonaws.services.lambda.model.SystemLogLevel;
import com.amazonaws.services.lambda.model.transform.LoggingConfigMarshaller;
import java.io.Serializable;

public class LoggingConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String logFormat;
    private String applicationLogLevel;
    private String systemLogLevel;
    private String logGroup;

    public void setLogFormat(String logFormat) {
        this.logFormat = logFormat;
    }

    public String getLogFormat() {
        return this.logFormat;
    }

    public LoggingConfig withLogFormat(String logFormat) {
        this.setLogFormat(logFormat);
        return this;
    }

    public LoggingConfig withLogFormat(LogFormat logFormat) {
        this.logFormat = logFormat.toString();
        return this;
    }

    public void setApplicationLogLevel(String applicationLogLevel) {
        this.applicationLogLevel = applicationLogLevel;
    }

    public String getApplicationLogLevel() {
        return this.applicationLogLevel;
    }

    public LoggingConfig withApplicationLogLevel(String applicationLogLevel) {
        this.setApplicationLogLevel(applicationLogLevel);
        return this;
    }

    public LoggingConfig withApplicationLogLevel(ApplicationLogLevel applicationLogLevel) {
        this.applicationLogLevel = applicationLogLevel.toString();
        return this;
    }

    public void setSystemLogLevel(String systemLogLevel) {
        this.systemLogLevel = systemLogLevel;
    }

    public String getSystemLogLevel() {
        return this.systemLogLevel;
    }

    public LoggingConfig withSystemLogLevel(String systemLogLevel) {
        this.setSystemLogLevel(systemLogLevel);
        return this;
    }

    public LoggingConfig withSystemLogLevel(SystemLogLevel systemLogLevel) {
        this.systemLogLevel = systemLogLevel.toString();
        return this;
    }

    public void setLogGroup(String logGroup) {
        this.logGroup = logGroup;
    }

    public String getLogGroup() {
        return this.logGroup;
    }

    public LoggingConfig withLogGroup(String logGroup) {
        this.setLogGroup(logGroup);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLogFormat() != null) {
            sb.append("LogFormat: ").append(this.getLogFormat()).append(",");
        }
        if (this.getApplicationLogLevel() != null) {
            sb.append("ApplicationLogLevel: ").append(this.getApplicationLogLevel()).append(",");
        }
        if (this.getSystemLogLevel() != null) {
            sb.append("SystemLogLevel: ").append(this.getSystemLogLevel()).append(",");
        }
        if (this.getLogGroup() != null) {
            sb.append("LogGroup: ").append(this.getLogGroup());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingConfig)) {
            return false;
        }
        LoggingConfig other = (LoggingConfig)obj;
        if (other.getLogFormat() == null ^ this.getLogFormat() == null) {
            return false;
        }
        if (other.getLogFormat() != null && !other.getLogFormat().equals(this.getLogFormat())) {
            return false;
        }
        if (other.getApplicationLogLevel() == null ^ this.getApplicationLogLevel() == null) {
            return false;
        }
        if (other.getApplicationLogLevel() != null && !other.getApplicationLogLevel().equals(this.getApplicationLogLevel())) {
            return false;
        }
        if (other.getSystemLogLevel() == null ^ this.getSystemLogLevel() == null) {
            return false;
        }
        if (other.getSystemLogLevel() != null && !other.getSystemLogLevel().equals(this.getSystemLogLevel())) {
            return false;
        }
        if (other.getLogGroup() == null ^ this.getLogGroup() == null) {
            return false;
        }
        return other.getLogGroup() == null || other.getLogGroup().equals(this.getLogGroup());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLogFormat() == null ? 0 : this.getLogFormat().hashCode());
        hashCode = 31 * hashCode + (this.getApplicationLogLevel() == null ? 0 : this.getApplicationLogLevel().hashCode());
        hashCode = 31 * hashCode + (this.getSystemLogLevel() == null ? 0 : this.getSystemLogLevel().hashCode());
        hashCode = 31 * hashCode + (this.getLogGroup() == null ? 0 : this.getLogGroup().hashCode());
        return hashCode;
    }

    public LoggingConfig clone() {
        try {
            return (LoggingConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LoggingConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

