/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.util.StringInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public class InvokeAsyncRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String functionName;
    private InputStream invokeArgs;

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public InvokeAsyncRequest withFunctionName(String functionName) {
        this.functionName = functionName;
        return this;
    }

    public InputStream getInvokeArgs() {
        return this.invokeArgs;
    }

    public void setInvokeArgs(InputStream invokeArgs) {
        this.invokeArgs = invokeArgs;
    }

    public InvokeAsyncRequest withInvokeArgs(InputStream invokeArgs) {
        this.invokeArgs = invokeArgs;
        return this;
    }

    public void setInvokeArgs(String invokeArgs) {
        try {
            this.invokeArgs = new StringInputStream(invokeArgs);
        }
        catch (UnsupportedEncodingException e) {
            throw new AmazonClientException((Throwable)e);
        }
    }

    public InvokeAsyncRequest withInvokeArgs(String invokeArgs) {
        this.setInvokeArgs(invokeArgs);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFunctionName() != null) {
            sb.append("FunctionName: " + this.getFunctionName() + ",");
        }
        if (this.getInvokeArgs() != null) {
            sb.append("InvokeArgs: " + this.getInvokeArgs());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFunctionName() == null ? 0 : this.getFunctionName().hashCode());
        hashCode = 31 * hashCode + (this.getInvokeArgs() == null ? 0 : this.getInvokeArgs().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeAsyncRequest)) {
            return false;
        }
        InvokeAsyncRequest other = (InvokeAsyncRequest)obj;
        if (other.getFunctionName() == null ^ this.getFunctionName() == null) {
            return false;
        }
        if (other.getFunctionName() != null && !other.getFunctionName().equals(this.getFunctionName())) {
            return false;
        }
        if (other.getInvokeArgs() == null ^ this.getInvokeArgs() == null) {
            return false;
        }
        return other.getInvokeArgs() == null || other.getInvokeArgs().equals(this.getInvokeArgs());
    }

    public InvokeAsyncRequest clone() {
        return (InvokeAsyncRequest)super.clone();
    }
}

