/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.launchwizard;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.launchwizard.AWSLaunchWizard;
import com.amazonaws.services.launchwizard.AWSLaunchWizardClientBuilder;
import com.amazonaws.services.launchwizard.model.AWSLaunchWizardException;
import com.amazonaws.services.launchwizard.model.CreateDeploymentRequest;
import com.amazonaws.services.launchwizard.model.CreateDeploymentResult;
import com.amazonaws.services.launchwizard.model.DeleteDeploymentRequest;
import com.amazonaws.services.launchwizard.model.DeleteDeploymentResult;
import com.amazonaws.services.launchwizard.model.GetDeploymentRequest;
import com.amazonaws.services.launchwizard.model.GetDeploymentResult;
import com.amazonaws.services.launchwizard.model.GetWorkloadRequest;
import com.amazonaws.services.launchwizard.model.GetWorkloadResult;
import com.amazonaws.services.launchwizard.model.ListDeploymentEventsRequest;
import com.amazonaws.services.launchwizard.model.ListDeploymentEventsResult;
import com.amazonaws.services.launchwizard.model.ListDeploymentsRequest;
import com.amazonaws.services.launchwizard.model.ListDeploymentsResult;
import com.amazonaws.services.launchwizard.model.ListWorkloadDeploymentPatternsRequest;
import com.amazonaws.services.launchwizard.model.ListWorkloadDeploymentPatternsResult;
import com.amazonaws.services.launchwizard.model.ListWorkloadsRequest;
import com.amazonaws.services.launchwizard.model.ListWorkloadsResult;
import com.amazonaws.services.launchwizard.model.transform.CreateDeploymentRequestProtocolMarshaller;
import com.amazonaws.services.launchwizard.model.transform.CreateDeploymentResultJsonUnmarshaller;
import com.amazonaws.services.launchwizard.model.transform.DeleteDeploymentRequestProtocolMarshaller;
import com.amazonaws.services.launchwizard.model.transform.DeleteDeploymentResultJsonUnmarshaller;
import com.amazonaws.services.launchwizard.model.transform.GetDeploymentRequestProtocolMarshaller;
import com.amazonaws.services.launchwizard.model.transform.GetDeploymentResultJsonUnmarshaller;
import com.amazonaws.services.launchwizard.model.transform.GetWorkloadRequestProtocolMarshaller;
import com.amazonaws.services.launchwizard.model.transform.GetWorkloadResultJsonUnmarshaller;
import com.amazonaws.services.launchwizard.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.launchwizard.model.transform.ListDeploymentEventsRequestProtocolMarshaller;
import com.amazonaws.services.launchwizard.model.transform.ListDeploymentEventsResultJsonUnmarshaller;
import com.amazonaws.services.launchwizard.model.transform.ListDeploymentsRequestProtocolMarshaller;
import com.amazonaws.services.launchwizard.model.transform.ListDeploymentsResultJsonUnmarshaller;
import com.amazonaws.services.launchwizard.model.transform.ListWorkloadDeploymentPatternsRequestProtocolMarshaller;
import com.amazonaws.services.launchwizard.model.transform.ListWorkloadDeploymentPatternsResultJsonUnmarshaller;
import com.amazonaws.services.launchwizard.model.transform.ListWorkloadsRequestProtocolMarshaller;
import com.amazonaws.services.launchwizard.model.transform.ListWorkloadsResultJsonUnmarshaller;
import com.amazonaws.services.launchwizard.model.transform.ResourceLimitExceptionUnmarshaller;
import com.amazonaws.services.launchwizard.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.launchwizard.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSLaunchWizardClient
extends AmazonWebServiceClient
implements AWSLaunchWizard {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSLaunchWizard.class);
    private static final String DEFAULT_SIGNING_NAME = "launchwizard";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceLimitException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceLimitExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSLaunchWizardException.class));

    public static AWSLaunchWizardClientBuilder builder() {
        return AWSLaunchWizardClientBuilder.standard();
    }

    AWSLaunchWizardClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSLaunchWizardClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("launchwizard.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/launchwizard/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/launchwizard/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateDeploymentResult createDeployment(CreateDeploymentRequest request) {
        request = (CreateDeploymentRequest)this.beforeClientExecution(request);
        return this.executeCreateDeployment(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateDeploymentResult executeCreateDeployment(CreateDeploymentRequest createDeploymentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createDeploymentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateDeploymentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateDeploymentRequestProtocolMarshaller(protocolFactory).marshall((CreateDeploymentRequest)super.beforeMarshalling((AmazonWebServiceRequest)createDeploymentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Launch Wizard");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateDeployment");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateDeploymentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateDeploymentResult createDeploymentResult = (CreateDeploymentResult)response.getAwsResponse();
            return createDeploymentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteDeploymentResult deleteDeployment(DeleteDeploymentRequest request) {
        request = (DeleteDeploymentRequest)this.beforeClientExecution(request);
        return this.executeDeleteDeployment(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteDeploymentResult executeDeleteDeployment(DeleteDeploymentRequest deleteDeploymentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteDeploymentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteDeploymentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteDeploymentRequestProtocolMarshaller(protocolFactory).marshall((DeleteDeploymentRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteDeploymentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Launch Wizard");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteDeployment");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteDeploymentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteDeploymentResult deleteDeploymentResult = (DeleteDeploymentResult)response.getAwsResponse();
            return deleteDeploymentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetDeploymentResult getDeployment(GetDeploymentRequest request) {
        request = (GetDeploymentRequest)this.beforeClientExecution(request);
        return this.executeGetDeployment(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetDeploymentResult executeGetDeployment(GetDeploymentRequest getDeploymentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDeploymentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDeploymentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDeploymentRequestProtocolMarshaller(protocolFactory).marshall((GetDeploymentRequest)super.beforeMarshalling((AmazonWebServiceRequest)getDeploymentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Launch Wizard");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetDeployment");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDeploymentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDeploymentResult getDeploymentResult = (GetDeploymentResult)response.getAwsResponse();
            return getDeploymentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetWorkloadResult getWorkload(GetWorkloadRequest request) {
        request = (GetWorkloadRequest)this.beforeClientExecution(request);
        return this.executeGetWorkload(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetWorkloadResult executeGetWorkload(GetWorkloadRequest getWorkloadRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getWorkloadRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetWorkloadRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetWorkloadRequestProtocolMarshaller(protocolFactory).marshall((GetWorkloadRequest)super.beforeMarshalling((AmazonWebServiceRequest)getWorkloadRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Launch Wizard");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetWorkload");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetWorkloadResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetWorkloadResult getWorkloadResult = (GetWorkloadResult)response.getAwsResponse();
            return getWorkloadResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDeploymentEventsResult listDeploymentEvents(ListDeploymentEventsRequest request) {
        request = (ListDeploymentEventsRequest)this.beforeClientExecution(request);
        return this.executeListDeploymentEvents(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListDeploymentEventsResult executeListDeploymentEvents(ListDeploymentEventsRequest listDeploymentEventsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDeploymentEventsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDeploymentEventsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDeploymentEventsRequestProtocolMarshaller(protocolFactory).marshall((ListDeploymentEventsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listDeploymentEventsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Launch Wizard");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListDeploymentEvents");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListDeploymentEventsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListDeploymentEventsResult listDeploymentEventsResult = (ListDeploymentEventsResult)response.getAwsResponse();
            return listDeploymentEventsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDeploymentsResult listDeployments(ListDeploymentsRequest request) {
        request = (ListDeploymentsRequest)this.beforeClientExecution(request);
        return this.executeListDeployments(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListDeploymentsResult executeListDeployments(ListDeploymentsRequest listDeploymentsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDeploymentsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDeploymentsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDeploymentsRequestProtocolMarshaller(protocolFactory).marshall((ListDeploymentsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listDeploymentsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Launch Wizard");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListDeployments");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListDeploymentsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListDeploymentsResult listDeploymentsResult = (ListDeploymentsResult)response.getAwsResponse();
            return listDeploymentsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListWorkloadDeploymentPatternsResult listWorkloadDeploymentPatterns(ListWorkloadDeploymentPatternsRequest request) {
        request = (ListWorkloadDeploymentPatternsRequest)this.beforeClientExecution(request);
        return this.executeListWorkloadDeploymentPatterns(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListWorkloadDeploymentPatternsResult executeListWorkloadDeploymentPatterns(ListWorkloadDeploymentPatternsRequest listWorkloadDeploymentPatternsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listWorkloadDeploymentPatternsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListWorkloadDeploymentPatternsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListWorkloadDeploymentPatternsRequestProtocolMarshaller(protocolFactory).marshall((ListWorkloadDeploymentPatternsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listWorkloadDeploymentPatternsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Launch Wizard");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListWorkloadDeploymentPatterns");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListWorkloadDeploymentPatternsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListWorkloadDeploymentPatternsResult listWorkloadDeploymentPatternsResult = (ListWorkloadDeploymentPatternsResult)response.getAwsResponse();
            return listWorkloadDeploymentPatternsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListWorkloadsResult listWorkloads(ListWorkloadsRequest request) {
        request = (ListWorkloadsRequest)this.beforeClientExecution(request);
        return this.executeListWorkloads(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListWorkloadsResult executeListWorkloads(ListWorkloadsRequest listWorkloadsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listWorkloadsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListWorkloadsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListWorkloadsRequestProtocolMarshaller(protocolFactory).marshall((ListWorkloadsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listWorkloadsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Launch Wizard");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListWorkloads");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListWorkloadsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListWorkloadsResult listWorkloadsResult = (ListWorkloadsResult)response.getAwsResponse();
            return listWorkloadsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

