/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.launchwizard;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.launchwizard.AWSLaunchWizardAsync;
import com.amazonaws.services.launchwizard.AWSLaunchWizardAsyncClientBuilder;
import com.amazonaws.services.launchwizard.AWSLaunchWizardClient;
import com.amazonaws.services.launchwizard.model.CreateDeploymentRequest;
import com.amazonaws.services.launchwizard.model.CreateDeploymentResult;
import com.amazonaws.services.launchwizard.model.DeleteDeploymentRequest;
import com.amazonaws.services.launchwizard.model.DeleteDeploymentResult;
import com.amazonaws.services.launchwizard.model.GetDeploymentRequest;
import com.amazonaws.services.launchwizard.model.GetDeploymentResult;
import com.amazonaws.services.launchwizard.model.GetWorkloadRequest;
import com.amazonaws.services.launchwizard.model.GetWorkloadResult;
import com.amazonaws.services.launchwizard.model.ListDeploymentEventsRequest;
import com.amazonaws.services.launchwizard.model.ListDeploymentEventsResult;
import com.amazonaws.services.launchwizard.model.ListDeploymentsRequest;
import com.amazonaws.services.launchwizard.model.ListDeploymentsResult;
import com.amazonaws.services.launchwizard.model.ListWorkloadDeploymentPatternsRequest;
import com.amazonaws.services.launchwizard.model.ListWorkloadDeploymentPatternsResult;
import com.amazonaws.services.launchwizard.model.ListWorkloadsRequest;
import com.amazonaws.services.launchwizard.model.ListWorkloadsResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSLaunchWizardAsyncClient
extends AWSLaunchWizardClient
implements AWSLaunchWizardAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSLaunchWizardAsyncClientBuilder asyncBuilder() {
        return AWSLaunchWizardAsyncClientBuilder.standard();
    }

    AWSLaunchWizardAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSLaunchWizardAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateDeploymentResult> createDeploymentAsync(CreateDeploymentRequest request) {
        return this.createDeploymentAsync(request, null);
    }

    @Override
    public Future<CreateDeploymentResult> createDeploymentAsync(CreateDeploymentRequest request, final AsyncHandler<CreateDeploymentRequest, CreateDeploymentResult> asyncHandler) {
        final CreateDeploymentRequest finalRequest = (CreateDeploymentRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateDeploymentResult>(){

            @Override
            public CreateDeploymentResult call() throws Exception {
                CreateDeploymentResult result = null;
                try {
                    result = AWSLaunchWizardAsyncClient.this.executeCreateDeployment(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDeploymentResult> deleteDeploymentAsync(DeleteDeploymentRequest request) {
        return this.deleteDeploymentAsync(request, null);
    }

    @Override
    public Future<DeleteDeploymentResult> deleteDeploymentAsync(DeleteDeploymentRequest request, final AsyncHandler<DeleteDeploymentRequest, DeleteDeploymentResult> asyncHandler) {
        final DeleteDeploymentRequest finalRequest = (DeleteDeploymentRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteDeploymentResult>(){

            @Override
            public DeleteDeploymentResult call() throws Exception {
                DeleteDeploymentResult result = null;
                try {
                    result = AWSLaunchWizardAsyncClient.this.executeDeleteDeployment(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDeploymentResult> getDeploymentAsync(GetDeploymentRequest request) {
        return this.getDeploymentAsync(request, null);
    }

    @Override
    public Future<GetDeploymentResult> getDeploymentAsync(GetDeploymentRequest request, final AsyncHandler<GetDeploymentRequest, GetDeploymentResult> asyncHandler) {
        final GetDeploymentRequest finalRequest = (GetDeploymentRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDeploymentResult>(){

            @Override
            public GetDeploymentResult call() throws Exception {
                GetDeploymentResult result = null;
                try {
                    result = AWSLaunchWizardAsyncClient.this.executeGetDeployment(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetWorkloadResult> getWorkloadAsync(GetWorkloadRequest request) {
        return this.getWorkloadAsync(request, null);
    }

    @Override
    public Future<GetWorkloadResult> getWorkloadAsync(GetWorkloadRequest request, final AsyncHandler<GetWorkloadRequest, GetWorkloadResult> asyncHandler) {
        final GetWorkloadRequest finalRequest = (GetWorkloadRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetWorkloadResult>(){

            @Override
            public GetWorkloadResult call() throws Exception {
                GetWorkloadResult result = null;
                try {
                    result = AWSLaunchWizardAsyncClient.this.executeGetWorkload(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDeploymentEventsResult> listDeploymentEventsAsync(ListDeploymentEventsRequest request) {
        return this.listDeploymentEventsAsync(request, null);
    }

    @Override
    public Future<ListDeploymentEventsResult> listDeploymentEventsAsync(ListDeploymentEventsRequest request, final AsyncHandler<ListDeploymentEventsRequest, ListDeploymentEventsResult> asyncHandler) {
        final ListDeploymentEventsRequest finalRequest = (ListDeploymentEventsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDeploymentEventsResult>(){

            @Override
            public ListDeploymentEventsResult call() throws Exception {
                ListDeploymentEventsResult result = null;
                try {
                    result = AWSLaunchWizardAsyncClient.this.executeListDeploymentEvents(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDeploymentsResult> listDeploymentsAsync(ListDeploymentsRequest request) {
        return this.listDeploymentsAsync(request, null);
    }

    @Override
    public Future<ListDeploymentsResult> listDeploymentsAsync(ListDeploymentsRequest request, final AsyncHandler<ListDeploymentsRequest, ListDeploymentsResult> asyncHandler) {
        final ListDeploymentsRequest finalRequest = (ListDeploymentsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDeploymentsResult>(){

            @Override
            public ListDeploymentsResult call() throws Exception {
                ListDeploymentsResult result = null;
                try {
                    result = AWSLaunchWizardAsyncClient.this.executeListDeployments(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListWorkloadDeploymentPatternsResult> listWorkloadDeploymentPatternsAsync(ListWorkloadDeploymentPatternsRequest request) {
        return this.listWorkloadDeploymentPatternsAsync(request, null);
    }

    @Override
    public Future<ListWorkloadDeploymentPatternsResult> listWorkloadDeploymentPatternsAsync(ListWorkloadDeploymentPatternsRequest request, final AsyncHandler<ListWorkloadDeploymentPatternsRequest, ListWorkloadDeploymentPatternsResult> asyncHandler) {
        final ListWorkloadDeploymentPatternsRequest finalRequest = (ListWorkloadDeploymentPatternsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListWorkloadDeploymentPatternsResult>(){

            @Override
            public ListWorkloadDeploymentPatternsResult call() throws Exception {
                ListWorkloadDeploymentPatternsResult result = null;
                try {
                    result = AWSLaunchWizardAsyncClient.this.executeListWorkloadDeploymentPatterns(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListWorkloadsResult> listWorkloadsAsync(ListWorkloadsRequest request) {
        return this.listWorkloadsAsync(request, null);
    }

    @Override
    public Future<ListWorkloadsResult> listWorkloadsAsync(ListWorkloadsRequest request, final AsyncHandler<ListWorkloadsRequest, ListWorkloadsResult> asyncHandler) {
        final ListWorkloadsRequest finalRequest = (ListWorkloadsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListWorkloadsResult>(){

            @Override
            public ListWorkloadsResult call() throws Exception {
                ListWorkloadsResult result = null;
                try {
                    result = AWSLaunchWizardAsyncClient.this.executeListWorkloads(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

