/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexruntime.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.lexruntime.model.ActiveContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PostTextRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String botName;
    private String botAlias;
    private String userId;
    private Map<String, String> sessionAttributes;
    private Map<String, String> requestAttributes;
    private String inputText;
    private List<ActiveContext> activeContexts;

    public void setBotName(String botName) {
        this.botName = botName;
    }

    public String getBotName() {
        return this.botName;
    }

    public PostTextRequest withBotName(String botName) {
        this.setBotName(botName);
        return this;
    }

    public void setBotAlias(String botAlias) {
        this.botAlias = botAlias;
    }

    public String getBotAlias() {
        return this.botAlias;
    }

    public PostTextRequest withBotAlias(String botAlias) {
        this.setBotAlias(botAlias);
        return this;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserId() {
        return this.userId;
    }

    public PostTextRequest withUserId(String userId) {
        this.setUserId(userId);
        return this;
    }

    public Map<String, String> getSessionAttributes() {
        return this.sessionAttributes;
    }

    public void setSessionAttributes(Map<String, String> sessionAttributes) {
        this.sessionAttributes = sessionAttributes;
    }

    public PostTextRequest withSessionAttributes(Map<String, String> sessionAttributes) {
        this.setSessionAttributes(sessionAttributes);
        return this;
    }

    public PostTextRequest addSessionAttributesEntry(String key, String value) {
        if (null == this.sessionAttributes) {
            this.sessionAttributes = new HashMap<String, String>();
        }
        if (this.sessionAttributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.sessionAttributes.put(key, value);
        return this;
    }

    public PostTextRequest clearSessionAttributesEntries() {
        this.sessionAttributes = null;
        return this;
    }

    public Map<String, String> getRequestAttributes() {
        return this.requestAttributes;
    }

    public void setRequestAttributes(Map<String, String> requestAttributes) {
        this.requestAttributes = requestAttributes;
    }

    public PostTextRequest withRequestAttributes(Map<String, String> requestAttributes) {
        this.setRequestAttributes(requestAttributes);
        return this;
    }

    public PostTextRequest addRequestAttributesEntry(String key, String value) {
        if (null == this.requestAttributes) {
            this.requestAttributes = new HashMap<String, String>();
        }
        if (this.requestAttributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.requestAttributes.put(key, value);
        return this;
    }

    public PostTextRequest clearRequestAttributesEntries() {
        this.requestAttributes = null;
        return this;
    }

    public void setInputText(String inputText) {
        this.inputText = inputText;
    }

    public String getInputText() {
        return this.inputText;
    }

    public PostTextRequest withInputText(String inputText) {
        this.setInputText(inputText);
        return this;
    }

    public List<ActiveContext> getActiveContexts() {
        return this.activeContexts;
    }

    public void setActiveContexts(Collection<ActiveContext> activeContexts) {
        if (activeContexts == null) {
            this.activeContexts = null;
            return;
        }
        this.activeContexts = new ArrayList<ActiveContext>(activeContexts);
    }

    public PostTextRequest withActiveContexts(ActiveContext ... activeContexts) {
        if (this.activeContexts == null) {
            this.setActiveContexts(new ArrayList<ActiveContext>(activeContexts.length));
        }
        for (ActiveContext ele : activeContexts) {
            this.activeContexts.add(ele);
        }
        return this;
    }

    public PostTextRequest withActiveContexts(Collection<ActiveContext> activeContexts) {
        this.setActiveContexts(activeContexts);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBotName() != null) {
            sb.append("BotName: ").append(this.getBotName()).append(",");
        }
        if (this.getBotAlias() != null) {
            sb.append("BotAlias: ").append(this.getBotAlias()).append(",");
        }
        if (this.getUserId() != null) {
            sb.append("UserId: ").append(this.getUserId()).append(",");
        }
        if (this.getSessionAttributes() != null) {
            sb.append("SessionAttributes: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getRequestAttributes() != null) {
            sb.append("RequestAttributes: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getInputText() != null) {
            sb.append("InputText: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getActiveContexts() != null) {
            sb.append("ActiveContexts: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PostTextRequest)) {
            return false;
        }
        PostTextRequest other = (PostTextRequest)obj;
        if (other.getBotName() == null ^ this.getBotName() == null) {
            return false;
        }
        if (other.getBotName() != null && !other.getBotName().equals(this.getBotName())) {
            return false;
        }
        if (other.getBotAlias() == null ^ this.getBotAlias() == null) {
            return false;
        }
        if (other.getBotAlias() != null && !other.getBotAlias().equals(this.getBotAlias())) {
            return false;
        }
        if (other.getUserId() == null ^ this.getUserId() == null) {
            return false;
        }
        if (other.getUserId() != null && !other.getUserId().equals(this.getUserId())) {
            return false;
        }
        if (other.getSessionAttributes() == null ^ this.getSessionAttributes() == null) {
            return false;
        }
        if (other.getSessionAttributes() != null && !other.getSessionAttributes().equals(this.getSessionAttributes())) {
            return false;
        }
        if (other.getRequestAttributes() == null ^ this.getRequestAttributes() == null) {
            return false;
        }
        if (other.getRequestAttributes() != null && !other.getRequestAttributes().equals(this.getRequestAttributes())) {
            return false;
        }
        if (other.getInputText() == null ^ this.getInputText() == null) {
            return false;
        }
        if (other.getInputText() != null && !other.getInputText().equals(this.getInputText())) {
            return false;
        }
        if (other.getActiveContexts() == null ^ this.getActiveContexts() == null) {
            return false;
        }
        return other.getActiveContexts() == null || other.getActiveContexts().equals(this.getActiveContexts());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBotName() == null ? 0 : this.getBotName().hashCode());
        hashCode = 31 * hashCode + (this.getBotAlias() == null ? 0 : this.getBotAlias().hashCode());
        hashCode = 31 * hashCode + (this.getUserId() == null ? 0 : this.getUserId().hashCode());
        hashCode = 31 * hashCode + (this.getSessionAttributes() == null ? 0 : this.getSessionAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getRequestAttributes() == null ? 0 : this.getRequestAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getInputText() == null ? 0 : this.getInputText().hashCode());
        hashCode = 31 * hashCode + (this.getActiveContexts() == null ? 0 : this.getActiveContexts().hashCode());
        return hashCode;
    }

    public PostTextRequest clone() {
        return (PostTextRequest)super.clone();
    }
}

