/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.lexmodelsv2;

import javax.annotation.Generated;

import com.amazonaws.services.lexmodelsv2.model.*;
import com.amazonaws.*;
import com.amazonaws.services.lexmodelsv2.waiters.AmazonLexModelsV2Waiters;

/**
 * Abstract implementation of {@code AmazonLexModelsV2}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonLexModelsV2 implements AmazonLexModelsV2 {

    protected AbstractAmazonLexModelsV2() {
    }

    @Override
    public BatchCreateCustomVocabularyItemResult batchCreateCustomVocabularyItem(BatchCreateCustomVocabularyItemRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchDeleteCustomVocabularyItemResult batchDeleteCustomVocabularyItem(BatchDeleteCustomVocabularyItemRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchUpdateCustomVocabularyItemResult batchUpdateCustomVocabularyItem(BatchUpdateCustomVocabularyItemRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BuildBotLocaleResult buildBotLocale(BuildBotLocaleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateBotResult createBot(CreateBotRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateBotAliasResult createBotAlias(CreateBotAliasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateBotLocaleResult createBotLocale(CreateBotLocaleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateBotVersionResult createBotVersion(CreateBotVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateExportResult createExport(CreateExportRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateIntentResult createIntent(CreateIntentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateResourcePolicyResult createResourcePolicy(CreateResourcePolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateResourcePolicyStatementResult createResourcePolicyStatement(CreateResourcePolicyStatementRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSlotResult createSlot(CreateSlotRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSlotTypeResult createSlotType(CreateSlotTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateUploadUrlResult createUploadUrl(CreateUploadUrlRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteBotResult deleteBot(DeleteBotRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteBotAliasResult deleteBotAlias(DeleteBotAliasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteBotLocaleResult deleteBotLocale(DeleteBotLocaleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteBotVersionResult deleteBotVersion(DeleteBotVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteCustomVocabularyResult deleteCustomVocabulary(DeleteCustomVocabularyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteExportResult deleteExport(DeleteExportRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteImportResult deleteImport(DeleteImportRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteIntentResult deleteIntent(DeleteIntentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteResourcePolicyResult deleteResourcePolicy(DeleteResourcePolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteResourcePolicyStatementResult deleteResourcePolicyStatement(DeleteResourcePolicyStatementRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteSlotResult deleteSlot(DeleteSlotRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteSlotTypeResult deleteSlotType(DeleteSlotTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteUtterancesResult deleteUtterances(DeleteUtterancesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeBotResult describeBot(DescribeBotRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeBotAliasResult describeBotAlias(DescribeBotAliasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeBotLocaleResult describeBotLocale(DescribeBotLocaleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeBotRecommendationResult describeBotRecommendation(DescribeBotRecommendationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeBotVersionResult describeBotVersion(DescribeBotVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeCustomVocabularyMetadataResult describeCustomVocabularyMetadata(DescribeCustomVocabularyMetadataRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeExportResult describeExport(DescribeExportRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeImportResult describeImport(DescribeImportRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeIntentResult describeIntent(DescribeIntentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeResourcePolicyResult describeResourcePolicy(DescribeResourcePolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeSlotResult describeSlot(DescribeSlotRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeSlotTypeResult describeSlotType(DescribeSlotTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAggregatedUtterancesResult listAggregatedUtterances(ListAggregatedUtterancesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListBotAliasesResult listBotAliases(ListBotAliasesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListBotLocalesResult listBotLocales(ListBotLocalesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListBotRecommendationsResult listBotRecommendations(ListBotRecommendationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListBotVersionsResult listBotVersions(ListBotVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListBotsResult listBots(ListBotsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListBuiltInIntentsResult listBuiltInIntents(ListBuiltInIntentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListBuiltInSlotTypesResult listBuiltInSlotTypes(ListBuiltInSlotTypesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCustomVocabularyItemsResult listCustomVocabularyItems(ListCustomVocabularyItemsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListExportsResult listExports(ListExportsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListImportsResult listImports(ListImportsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListIntentsResult listIntents(ListIntentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListRecommendedIntentsResult listRecommendedIntents(ListRecommendedIntentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSlotTypesResult listSlotTypes(ListSlotTypesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSlotsResult listSlots(ListSlotsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchAssociatedTranscriptsResult searchAssociatedTranscripts(SearchAssociatedTranscriptsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartBotRecommendationResult startBotRecommendation(StartBotRecommendationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartImportResult startImport(StartImportRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopBotRecommendationResult stopBotRecommendation(StopBotRecommendationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateBotResult updateBot(UpdateBotRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateBotAliasResult updateBotAlias(UpdateBotAliasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateBotLocaleResult updateBotLocale(UpdateBotLocaleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateBotRecommendationResult updateBotRecommendation(UpdateBotRecommendationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateExportResult updateExport(UpdateExportRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateIntentResult updateIntent(UpdateIntentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateResourcePolicyResult updateResourcePolicy(UpdateResourcePolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSlotResult updateSlot(UpdateSlotRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSlotTypeResult updateSlotType(UpdateSlotTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AmazonLexModelsV2Waiters waiters() {
        throw new java.lang.UnsupportedOperationException();
    }

}
