/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.lexmodelsv2.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.lexmodelsv2.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * ImportResourceSpecificationMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class ImportResourceSpecificationMarshaller {

    private static final MarshallingInfo<StructuredPojo> BOTIMPORTSPECIFICATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("botImportSpecification").build();
    private static final MarshallingInfo<StructuredPojo> BOTLOCALEIMPORTSPECIFICATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("botLocaleImportSpecification").build();
    private static final MarshallingInfo<StructuredPojo> CUSTOMVOCABULARYIMPORTSPECIFICATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("customVocabularyImportSpecification").build();

    private static final ImportResourceSpecificationMarshaller instance = new ImportResourceSpecificationMarshaller();

    public static ImportResourceSpecificationMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(ImportResourceSpecification importResourceSpecification, ProtocolMarshaller protocolMarshaller) {

        if (importResourceSpecification == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(importResourceSpecification.getBotImportSpecification(), BOTIMPORTSPECIFICATION_BINDING);
            protocolMarshaller.marshall(importResourceSpecification.getBotLocaleImportSpecification(), BOTLOCALEIMPORTSPECIFICATION_BINDING);
            protocolMarshaller.marshall(importResourceSpecification.getCustomVocabularyImportSpecification(), CUSTOMVOCABULARYIMPORTSPECIFICATION_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
