/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexmodelsv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lexmodelsv2.model.AnalyticsModality;
import com.amazonaws.services.lexmodelsv2.model.BotChannelType;
import com.amazonaws.services.lexmodelsv2.model.IntentState;
import com.amazonaws.services.lexmodelsv2.model.UtteranceBotResponse;
import com.amazonaws.services.lexmodelsv2.model.transform.UtteranceSpecificationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class UtteranceSpecification
implements Serializable,
Cloneable,
StructuredPojo {
    private String botAliasId;
    private String botVersion;
    private String localeId;
    private String sessionId;
    private String channel;
    private String mode;
    private Date conversationStartTime;
    private Date conversationEndTime;
    private String utterance;
    private Date utteranceTimestamp;
    private Long audioVoiceDurationMillis;
    private Boolean utteranceUnderstood;
    private String inputType;
    private String outputType;
    private String associatedIntentName;
    private String associatedSlotName;
    private String intentState;
    private String dialogActionType;
    private String botResponseAudioVoiceId;
    private String slotsFilledInSession;
    private String utteranceRequestId;
    private List<UtteranceBotResponse> botResponses;

    public void setBotAliasId(String botAliasId) {
        this.botAliasId = botAliasId;
    }

    public String getBotAliasId() {
        return this.botAliasId;
    }

    public UtteranceSpecification withBotAliasId(String botAliasId) {
        this.setBotAliasId(botAliasId);
        return this;
    }

    public void setBotVersion(String botVersion) {
        this.botVersion = botVersion;
    }

    public String getBotVersion() {
        return this.botVersion;
    }

    public UtteranceSpecification withBotVersion(String botVersion) {
        this.setBotVersion(botVersion);
        return this;
    }

    public void setLocaleId(String localeId) {
        this.localeId = localeId;
    }

    public String getLocaleId() {
        return this.localeId;
    }

    public UtteranceSpecification withLocaleId(String localeId) {
        this.setLocaleId(localeId);
        return this;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public UtteranceSpecification withSessionId(String sessionId) {
        this.setSessionId(sessionId);
        return this;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getChannel() {
        return this.channel;
    }

    public UtteranceSpecification withChannel(String channel) {
        this.setChannel(channel);
        return this;
    }

    public UtteranceSpecification withChannel(BotChannelType channel) {
        this.channel = channel.toString();
        return this;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getMode() {
        return this.mode;
    }

    public UtteranceSpecification withMode(String mode) {
        this.setMode(mode);
        return this;
    }

    public UtteranceSpecification withMode(AnalyticsModality mode) {
        this.mode = mode.toString();
        return this;
    }

    public void setConversationStartTime(Date conversationStartTime) {
        this.conversationStartTime = conversationStartTime;
    }

    public Date getConversationStartTime() {
        return this.conversationStartTime;
    }

    public UtteranceSpecification withConversationStartTime(Date conversationStartTime) {
        this.setConversationStartTime(conversationStartTime);
        return this;
    }

    public void setConversationEndTime(Date conversationEndTime) {
        this.conversationEndTime = conversationEndTime;
    }

    public Date getConversationEndTime() {
        return this.conversationEndTime;
    }

    public UtteranceSpecification withConversationEndTime(Date conversationEndTime) {
        this.setConversationEndTime(conversationEndTime);
        return this;
    }

    public void setUtterance(String utterance) {
        this.utterance = utterance;
    }

    public String getUtterance() {
        return this.utterance;
    }

    public UtteranceSpecification withUtterance(String utterance) {
        this.setUtterance(utterance);
        return this;
    }

    public void setUtteranceTimestamp(Date utteranceTimestamp) {
        this.utteranceTimestamp = utteranceTimestamp;
    }

    public Date getUtteranceTimestamp() {
        return this.utteranceTimestamp;
    }

    public UtteranceSpecification withUtteranceTimestamp(Date utteranceTimestamp) {
        this.setUtteranceTimestamp(utteranceTimestamp);
        return this;
    }

    public void setAudioVoiceDurationMillis(Long audioVoiceDurationMillis) {
        this.audioVoiceDurationMillis = audioVoiceDurationMillis;
    }

    public Long getAudioVoiceDurationMillis() {
        return this.audioVoiceDurationMillis;
    }

    public UtteranceSpecification withAudioVoiceDurationMillis(Long audioVoiceDurationMillis) {
        this.setAudioVoiceDurationMillis(audioVoiceDurationMillis);
        return this;
    }

    public void setUtteranceUnderstood(Boolean utteranceUnderstood) {
        this.utteranceUnderstood = utteranceUnderstood;
    }

    public Boolean getUtteranceUnderstood() {
        return this.utteranceUnderstood;
    }

    public UtteranceSpecification withUtteranceUnderstood(Boolean utteranceUnderstood) {
        this.setUtteranceUnderstood(utteranceUnderstood);
        return this;
    }

    public Boolean isUtteranceUnderstood() {
        return this.utteranceUnderstood;
    }

    public void setInputType(String inputType) {
        this.inputType = inputType;
    }

    public String getInputType() {
        return this.inputType;
    }

    public UtteranceSpecification withInputType(String inputType) {
        this.setInputType(inputType);
        return this;
    }

    public void setOutputType(String outputType) {
        this.outputType = outputType;
    }

    public String getOutputType() {
        return this.outputType;
    }

    public UtteranceSpecification withOutputType(String outputType) {
        this.setOutputType(outputType);
        return this;
    }

    public void setAssociatedIntentName(String associatedIntentName) {
        this.associatedIntentName = associatedIntentName;
    }

    public String getAssociatedIntentName() {
        return this.associatedIntentName;
    }

    public UtteranceSpecification withAssociatedIntentName(String associatedIntentName) {
        this.setAssociatedIntentName(associatedIntentName);
        return this;
    }

    public void setAssociatedSlotName(String associatedSlotName) {
        this.associatedSlotName = associatedSlotName;
    }

    public String getAssociatedSlotName() {
        return this.associatedSlotName;
    }

    public UtteranceSpecification withAssociatedSlotName(String associatedSlotName) {
        this.setAssociatedSlotName(associatedSlotName);
        return this;
    }

    public void setIntentState(String intentState) {
        this.intentState = intentState;
    }

    public String getIntentState() {
        return this.intentState;
    }

    public UtteranceSpecification withIntentState(String intentState) {
        this.setIntentState(intentState);
        return this;
    }

    public UtteranceSpecification withIntentState(IntentState intentState) {
        this.intentState = intentState.toString();
        return this;
    }

    public void setDialogActionType(String dialogActionType) {
        this.dialogActionType = dialogActionType;
    }

    public String getDialogActionType() {
        return this.dialogActionType;
    }

    public UtteranceSpecification withDialogActionType(String dialogActionType) {
        this.setDialogActionType(dialogActionType);
        return this;
    }

    public void setBotResponseAudioVoiceId(String botResponseAudioVoiceId) {
        this.botResponseAudioVoiceId = botResponseAudioVoiceId;
    }

    public String getBotResponseAudioVoiceId() {
        return this.botResponseAudioVoiceId;
    }

    public UtteranceSpecification withBotResponseAudioVoiceId(String botResponseAudioVoiceId) {
        this.setBotResponseAudioVoiceId(botResponseAudioVoiceId);
        return this;
    }

    public void setSlotsFilledInSession(String slotsFilledInSession) {
        this.slotsFilledInSession = slotsFilledInSession;
    }

    public String getSlotsFilledInSession() {
        return this.slotsFilledInSession;
    }

    public UtteranceSpecification withSlotsFilledInSession(String slotsFilledInSession) {
        this.setSlotsFilledInSession(slotsFilledInSession);
        return this;
    }

    public void setUtteranceRequestId(String utteranceRequestId) {
        this.utteranceRequestId = utteranceRequestId;
    }

    public String getUtteranceRequestId() {
        return this.utteranceRequestId;
    }

    public UtteranceSpecification withUtteranceRequestId(String utteranceRequestId) {
        this.setUtteranceRequestId(utteranceRequestId);
        return this;
    }

    public List<UtteranceBotResponse> getBotResponses() {
        return this.botResponses;
    }

    public void setBotResponses(Collection<UtteranceBotResponse> botResponses) {
        if (botResponses == null) {
            this.botResponses = null;
            return;
        }
        this.botResponses = new ArrayList<UtteranceBotResponse>(botResponses);
    }

    public UtteranceSpecification withBotResponses(UtteranceBotResponse ... botResponses) {
        if (this.botResponses == null) {
            this.setBotResponses(new ArrayList<UtteranceBotResponse>(botResponses.length));
        }
        for (UtteranceBotResponse ele : botResponses) {
            this.botResponses.add(ele);
        }
        return this;
    }

    public UtteranceSpecification withBotResponses(Collection<UtteranceBotResponse> botResponses) {
        this.setBotResponses(botResponses);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBotAliasId() != null) {
            sb.append("BotAliasId: ").append(this.getBotAliasId()).append(",");
        }
        if (this.getBotVersion() != null) {
            sb.append("BotVersion: ").append(this.getBotVersion()).append(",");
        }
        if (this.getLocaleId() != null) {
            sb.append("LocaleId: ").append(this.getLocaleId()).append(",");
        }
        if (this.getSessionId() != null) {
            sb.append("SessionId: ").append(this.getSessionId()).append(",");
        }
        if (this.getChannel() != null) {
            sb.append("Channel: ").append(this.getChannel()).append(",");
        }
        if (this.getMode() != null) {
            sb.append("Mode: ").append(this.getMode()).append(",");
        }
        if (this.getConversationStartTime() != null) {
            sb.append("ConversationStartTime: ").append(this.getConversationStartTime()).append(",");
        }
        if (this.getConversationEndTime() != null) {
            sb.append("ConversationEndTime: ").append(this.getConversationEndTime()).append(",");
        }
        if (this.getUtterance() != null) {
            sb.append("Utterance: ").append(this.getUtterance()).append(",");
        }
        if (this.getUtteranceTimestamp() != null) {
            sb.append("UtteranceTimestamp: ").append(this.getUtteranceTimestamp()).append(",");
        }
        if (this.getAudioVoiceDurationMillis() != null) {
            sb.append("AudioVoiceDurationMillis: ").append(this.getAudioVoiceDurationMillis()).append(",");
        }
        if (this.getUtteranceUnderstood() != null) {
            sb.append("UtteranceUnderstood: ").append(this.getUtteranceUnderstood()).append(",");
        }
        if (this.getInputType() != null) {
            sb.append("InputType: ").append(this.getInputType()).append(",");
        }
        if (this.getOutputType() != null) {
            sb.append("OutputType: ").append(this.getOutputType()).append(",");
        }
        if (this.getAssociatedIntentName() != null) {
            sb.append("AssociatedIntentName: ").append(this.getAssociatedIntentName()).append(",");
        }
        if (this.getAssociatedSlotName() != null) {
            sb.append("AssociatedSlotName: ").append(this.getAssociatedSlotName()).append(",");
        }
        if (this.getIntentState() != null) {
            sb.append("IntentState: ").append(this.getIntentState()).append(",");
        }
        if (this.getDialogActionType() != null) {
            sb.append("DialogActionType: ").append(this.getDialogActionType()).append(",");
        }
        if (this.getBotResponseAudioVoiceId() != null) {
            sb.append("BotResponseAudioVoiceId: ").append(this.getBotResponseAudioVoiceId()).append(",");
        }
        if (this.getSlotsFilledInSession() != null) {
            sb.append("SlotsFilledInSession: ").append(this.getSlotsFilledInSession()).append(",");
        }
        if (this.getUtteranceRequestId() != null) {
            sb.append("UtteranceRequestId: ").append(this.getUtteranceRequestId()).append(",");
        }
        if (this.getBotResponses() != null) {
            sb.append("BotResponses: ").append(this.getBotResponses());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UtteranceSpecification)) {
            return false;
        }
        UtteranceSpecification other = (UtteranceSpecification)obj;
        if (other.getBotAliasId() == null ^ this.getBotAliasId() == null) {
            return false;
        }
        if (other.getBotAliasId() != null && !other.getBotAliasId().equals(this.getBotAliasId())) {
            return false;
        }
        if (other.getBotVersion() == null ^ this.getBotVersion() == null) {
            return false;
        }
        if (other.getBotVersion() != null && !other.getBotVersion().equals(this.getBotVersion())) {
            return false;
        }
        if (other.getLocaleId() == null ^ this.getLocaleId() == null) {
            return false;
        }
        if (other.getLocaleId() != null && !other.getLocaleId().equals(this.getLocaleId())) {
            return false;
        }
        if (other.getSessionId() == null ^ this.getSessionId() == null) {
            return false;
        }
        if (other.getSessionId() != null && !other.getSessionId().equals(this.getSessionId())) {
            return false;
        }
        if (other.getChannel() == null ^ this.getChannel() == null) {
            return false;
        }
        if (other.getChannel() != null && !other.getChannel().equals(this.getChannel())) {
            return false;
        }
        if (other.getMode() == null ^ this.getMode() == null) {
            return false;
        }
        if (other.getMode() != null && !other.getMode().equals(this.getMode())) {
            return false;
        }
        if (other.getConversationStartTime() == null ^ this.getConversationStartTime() == null) {
            return false;
        }
        if (other.getConversationStartTime() != null && !other.getConversationStartTime().equals(this.getConversationStartTime())) {
            return false;
        }
        if (other.getConversationEndTime() == null ^ this.getConversationEndTime() == null) {
            return false;
        }
        if (other.getConversationEndTime() != null && !other.getConversationEndTime().equals(this.getConversationEndTime())) {
            return false;
        }
        if (other.getUtterance() == null ^ this.getUtterance() == null) {
            return false;
        }
        if (other.getUtterance() != null && !other.getUtterance().equals(this.getUtterance())) {
            return false;
        }
        if (other.getUtteranceTimestamp() == null ^ this.getUtteranceTimestamp() == null) {
            return false;
        }
        if (other.getUtteranceTimestamp() != null && !other.getUtteranceTimestamp().equals(this.getUtteranceTimestamp())) {
            return false;
        }
        if (other.getAudioVoiceDurationMillis() == null ^ this.getAudioVoiceDurationMillis() == null) {
            return false;
        }
        if (other.getAudioVoiceDurationMillis() != null && !other.getAudioVoiceDurationMillis().equals(this.getAudioVoiceDurationMillis())) {
            return false;
        }
        if (other.getUtteranceUnderstood() == null ^ this.getUtteranceUnderstood() == null) {
            return false;
        }
        if (other.getUtteranceUnderstood() != null && !other.getUtteranceUnderstood().equals(this.getUtteranceUnderstood())) {
            return false;
        }
        if (other.getInputType() == null ^ this.getInputType() == null) {
            return false;
        }
        if (other.getInputType() != null && !other.getInputType().equals(this.getInputType())) {
            return false;
        }
        if (other.getOutputType() == null ^ this.getOutputType() == null) {
            return false;
        }
        if (other.getOutputType() != null && !other.getOutputType().equals(this.getOutputType())) {
            return false;
        }
        if (other.getAssociatedIntentName() == null ^ this.getAssociatedIntentName() == null) {
            return false;
        }
        if (other.getAssociatedIntentName() != null && !other.getAssociatedIntentName().equals(this.getAssociatedIntentName())) {
            return false;
        }
        if (other.getAssociatedSlotName() == null ^ this.getAssociatedSlotName() == null) {
            return false;
        }
        if (other.getAssociatedSlotName() != null && !other.getAssociatedSlotName().equals(this.getAssociatedSlotName())) {
            return false;
        }
        if (other.getIntentState() == null ^ this.getIntentState() == null) {
            return false;
        }
        if (other.getIntentState() != null && !other.getIntentState().equals(this.getIntentState())) {
            return false;
        }
        if (other.getDialogActionType() == null ^ this.getDialogActionType() == null) {
            return false;
        }
        if (other.getDialogActionType() != null && !other.getDialogActionType().equals(this.getDialogActionType())) {
            return false;
        }
        if (other.getBotResponseAudioVoiceId() == null ^ this.getBotResponseAudioVoiceId() == null) {
            return false;
        }
        if (other.getBotResponseAudioVoiceId() != null && !other.getBotResponseAudioVoiceId().equals(this.getBotResponseAudioVoiceId())) {
            return false;
        }
        if (other.getSlotsFilledInSession() == null ^ this.getSlotsFilledInSession() == null) {
            return false;
        }
        if (other.getSlotsFilledInSession() != null && !other.getSlotsFilledInSession().equals(this.getSlotsFilledInSession())) {
            return false;
        }
        if (other.getUtteranceRequestId() == null ^ this.getUtteranceRequestId() == null) {
            return false;
        }
        if (other.getUtteranceRequestId() != null && !other.getUtteranceRequestId().equals(this.getUtteranceRequestId())) {
            return false;
        }
        if (other.getBotResponses() == null ^ this.getBotResponses() == null) {
            return false;
        }
        return other.getBotResponses() == null || other.getBotResponses().equals(this.getBotResponses());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBotAliasId() == null ? 0 : this.getBotAliasId().hashCode());
        hashCode = 31 * hashCode + (this.getBotVersion() == null ? 0 : this.getBotVersion().hashCode());
        hashCode = 31 * hashCode + (this.getLocaleId() == null ? 0 : this.getLocaleId().hashCode());
        hashCode = 31 * hashCode + (this.getSessionId() == null ? 0 : this.getSessionId().hashCode());
        hashCode = 31 * hashCode + (this.getChannel() == null ? 0 : this.getChannel().hashCode());
        hashCode = 31 * hashCode + (this.getMode() == null ? 0 : this.getMode().hashCode());
        hashCode = 31 * hashCode + (this.getConversationStartTime() == null ? 0 : this.getConversationStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getConversationEndTime() == null ? 0 : this.getConversationEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getUtterance() == null ? 0 : this.getUtterance().hashCode());
        hashCode = 31 * hashCode + (this.getUtteranceTimestamp() == null ? 0 : this.getUtteranceTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getAudioVoiceDurationMillis() == null ? 0 : this.getAudioVoiceDurationMillis().hashCode());
        hashCode = 31 * hashCode + (this.getUtteranceUnderstood() == null ? 0 : this.getUtteranceUnderstood().hashCode());
        hashCode = 31 * hashCode + (this.getInputType() == null ? 0 : this.getInputType().hashCode());
        hashCode = 31 * hashCode + (this.getOutputType() == null ? 0 : this.getOutputType().hashCode());
        hashCode = 31 * hashCode + (this.getAssociatedIntentName() == null ? 0 : this.getAssociatedIntentName().hashCode());
        hashCode = 31 * hashCode + (this.getAssociatedSlotName() == null ? 0 : this.getAssociatedSlotName().hashCode());
        hashCode = 31 * hashCode + (this.getIntentState() == null ? 0 : this.getIntentState().hashCode());
        hashCode = 31 * hashCode + (this.getDialogActionType() == null ? 0 : this.getDialogActionType().hashCode());
        hashCode = 31 * hashCode + (this.getBotResponseAudioVoiceId() == null ? 0 : this.getBotResponseAudioVoiceId().hashCode());
        hashCode = 31 * hashCode + (this.getSlotsFilledInSession() == null ? 0 : this.getSlotsFilledInSession().hashCode());
        hashCode = 31 * hashCode + (this.getUtteranceRequestId() == null ? 0 : this.getUtteranceRequestId().hashCode());
        hashCode = 31 * hashCode + (this.getBotResponses() == null ? 0 : this.getBotResponses().hashCode());
        return hashCode;
    }

    public UtteranceSpecification clone() {
        try {
            return (UtteranceSpecification)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UtteranceSpecificationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

