/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.lexmodelsv2.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.lexmodelsv2.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * TestSetImportResourceSpecification JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class TestSetImportResourceSpecificationJsonUnmarshaller implements Unmarshaller<TestSetImportResourceSpecification, JsonUnmarshallerContext> {

    public TestSetImportResourceSpecification unmarshall(JsonUnmarshallerContext context) throws Exception {
        TestSetImportResourceSpecification testSetImportResourceSpecification = new TestSetImportResourceSpecification();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        boolean knownMember;

        while (true) {
            if (token == null)
                break;

            knownMember = false;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("testSetName", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    testSetImportResourceSpecification.setTestSetName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("description", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    testSetImportResourceSpecification.setDescription(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("roleArn", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    testSetImportResourceSpecification.setRoleArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("storageLocation", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    testSetImportResourceSpecification.setStorageLocation(TestSetStorageLocationJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("importInputLocation", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    testSetImportResourceSpecification.setImportInputLocation(TestSetImportInputLocationJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("modality", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    testSetImportResourceSpecification.setModality(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("testSetTags", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    testSetImportResourceSpecification.setTestSetTags(new MapUnmarshaller<String, String>(context.getUnmarshaller(String.class), context
                            .getUnmarshaller(String.class)).unmarshall(context));
                }
                if (token == FIELD_NAME && !knownMember) {
                    context.nextToken();
                    com.amazonaws.transform.UnknownMemberJsonUnmarshaller.getInstance().unmarshall(context);
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return testSetImportResourceSpecification;
    }

    private static TestSetImportResourceSpecificationJsonUnmarshaller instance;

    public static TestSetImportResourceSpecificationJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new TestSetImportResourceSpecificationJsonUnmarshaller();
        return instance;
    }
}
