/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.lexmodelsv2.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Contains details about the configuration of the Amazon OpenSearch Service database used for the
 * <code>AMAZON.QnAIntent</code>.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/OpensearchConfiguration"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class OpensearchConfiguration implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The endpoint of the Amazon OpenSearch Service domain.
     * </p>
     */
    private String domainEndpoint;
    /**
     * <p>
     * The name of the Amazon OpenSearch Service index.
     * </p>
     */
    private String indexName;
    /**
     * <p>
     * Specifies whether to return an exact response or to return an answer generated by the model using the fields you
     * specify from the database.
     * </p>
     */
    private Boolean exactResponse;
    /**
     * <p>
     * Contains the names of the fields used for an exact response to the user.
     * </p>
     */
    private ExactResponseFields exactResponseFields;
    /**
     * <p>
     * Contains a list of fields from the Amazon OpenSearch Service that the model can use to generate the answer to the
     * query.
     * </p>
     */
    private java.util.List<String> includeFields;

    /**
     * <p>
     * The endpoint of the Amazon OpenSearch Service domain.
     * </p>
     * 
     * @param domainEndpoint
     *        The endpoint of the Amazon OpenSearch Service domain.
     */

    public void setDomainEndpoint(String domainEndpoint) {
        this.domainEndpoint = domainEndpoint;
    }

    /**
     * <p>
     * The endpoint of the Amazon OpenSearch Service domain.
     * </p>
     * 
     * @return The endpoint of the Amazon OpenSearch Service domain.
     */

    public String getDomainEndpoint() {
        return this.domainEndpoint;
    }

    /**
     * <p>
     * The endpoint of the Amazon OpenSearch Service domain.
     * </p>
     * 
     * @param domainEndpoint
     *        The endpoint of the Amazon OpenSearch Service domain.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public OpensearchConfiguration withDomainEndpoint(String domainEndpoint) {
        setDomainEndpoint(domainEndpoint);
        return this;
    }

    /**
     * <p>
     * The name of the Amazon OpenSearch Service index.
     * </p>
     * 
     * @param indexName
     *        The name of the Amazon OpenSearch Service index.
     */

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    /**
     * <p>
     * The name of the Amazon OpenSearch Service index.
     * </p>
     * 
     * @return The name of the Amazon OpenSearch Service index.
     */

    public String getIndexName() {
        return this.indexName;
    }

    /**
     * <p>
     * The name of the Amazon OpenSearch Service index.
     * </p>
     * 
     * @param indexName
     *        The name of the Amazon OpenSearch Service index.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public OpensearchConfiguration withIndexName(String indexName) {
        setIndexName(indexName);
        return this;
    }

    /**
     * <p>
     * Specifies whether to return an exact response or to return an answer generated by the model using the fields you
     * specify from the database.
     * </p>
     * 
     * @param exactResponse
     *        Specifies whether to return an exact response or to return an answer generated by the model using the
     *        fields you specify from the database.
     */

    public void setExactResponse(Boolean exactResponse) {
        this.exactResponse = exactResponse;
    }

    /**
     * <p>
     * Specifies whether to return an exact response or to return an answer generated by the model using the fields you
     * specify from the database.
     * </p>
     * 
     * @return Specifies whether to return an exact response or to return an answer generated by the model using the
     *         fields you specify from the database.
     */

    public Boolean getExactResponse() {
        return this.exactResponse;
    }

    /**
     * <p>
     * Specifies whether to return an exact response or to return an answer generated by the model using the fields you
     * specify from the database.
     * </p>
     * 
     * @param exactResponse
     *        Specifies whether to return an exact response or to return an answer generated by the model using the
     *        fields you specify from the database.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public OpensearchConfiguration withExactResponse(Boolean exactResponse) {
        setExactResponse(exactResponse);
        return this;
    }

    /**
     * <p>
     * Specifies whether to return an exact response or to return an answer generated by the model using the fields you
     * specify from the database.
     * </p>
     * 
     * @return Specifies whether to return an exact response or to return an answer generated by the model using the
     *         fields you specify from the database.
     */

    public Boolean isExactResponse() {
        return this.exactResponse;
    }

    /**
     * <p>
     * Contains the names of the fields used for an exact response to the user.
     * </p>
     * 
     * @param exactResponseFields
     *        Contains the names of the fields used for an exact response to the user.
     */

    public void setExactResponseFields(ExactResponseFields exactResponseFields) {
        this.exactResponseFields = exactResponseFields;
    }

    /**
     * <p>
     * Contains the names of the fields used for an exact response to the user.
     * </p>
     * 
     * @return Contains the names of the fields used for an exact response to the user.
     */

    public ExactResponseFields getExactResponseFields() {
        return this.exactResponseFields;
    }

    /**
     * <p>
     * Contains the names of the fields used for an exact response to the user.
     * </p>
     * 
     * @param exactResponseFields
     *        Contains the names of the fields used for an exact response to the user.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public OpensearchConfiguration withExactResponseFields(ExactResponseFields exactResponseFields) {
        setExactResponseFields(exactResponseFields);
        return this;
    }

    /**
     * <p>
     * Contains a list of fields from the Amazon OpenSearch Service that the model can use to generate the answer to the
     * query.
     * </p>
     * 
     * @return Contains a list of fields from the Amazon OpenSearch Service that the model can use to generate the
     *         answer to the query.
     */

    public java.util.List<String> getIncludeFields() {
        return includeFields;
    }

    /**
     * <p>
     * Contains a list of fields from the Amazon OpenSearch Service that the model can use to generate the answer to the
     * query.
     * </p>
     * 
     * @param includeFields
     *        Contains a list of fields from the Amazon OpenSearch Service that the model can use to generate the answer
     *        to the query.
     */

    public void setIncludeFields(java.util.Collection<String> includeFields) {
        if (includeFields == null) {
            this.includeFields = null;
            return;
        }

        this.includeFields = new java.util.ArrayList<String>(includeFields);
    }

    /**
     * <p>
     * Contains a list of fields from the Amazon OpenSearch Service that the model can use to generate the answer to the
     * query.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setIncludeFields(java.util.Collection)} or {@link #withIncludeFields(java.util.Collection)} if you want
     * to override the existing values.
     * </p>
     * 
     * @param includeFields
     *        Contains a list of fields from the Amazon OpenSearch Service that the model can use to generate the answer
     *        to the query.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public OpensearchConfiguration withIncludeFields(String... includeFields) {
        if (this.includeFields == null) {
            setIncludeFields(new java.util.ArrayList<String>(includeFields.length));
        }
        for (String ele : includeFields) {
            this.includeFields.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Contains a list of fields from the Amazon OpenSearch Service that the model can use to generate the answer to the
     * query.
     * </p>
     * 
     * @param includeFields
     *        Contains a list of fields from the Amazon OpenSearch Service that the model can use to generate the answer
     *        to the query.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public OpensearchConfiguration withIncludeFields(java.util.Collection<String> includeFields) {
        setIncludeFields(includeFields);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getDomainEndpoint() != null)
            sb.append("DomainEndpoint: ").append(getDomainEndpoint()).append(",");
        if (getIndexName() != null)
            sb.append("IndexName: ").append(getIndexName()).append(",");
        if (getExactResponse() != null)
            sb.append("ExactResponse: ").append(getExactResponse()).append(",");
        if (getExactResponseFields() != null)
            sb.append("ExactResponseFields: ").append(getExactResponseFields()).append(",");
        if (getIncludeFields() != null)
            sb.append("IncludeFields: ").append(getIncludeFields());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof OpensearchConfiguration == false)
            return false;
        OpensearchConfiguration other = (OpensearchConfiguration) obj;
        if (other.getDomainEndpoint() == null ^ this.getDomainEndpoint() == null)
            return false;
        if (other.getDomainEndpoint() != null && other.getDomainEndpoint().equals(this.getDomainEndpoint()) == false)
            return false;
        if (other.getIndexName() == null ^ this.getIndexName() == null)
            return false;
        if (other.getIndexName() != null && other.getIndexName().equals(this.getIndexName()) == false)
            return false;
        if (other.getExactResponse() == null ^ this.getExactResponse() == null)
            return false;
        if (other.getExactResponse() != null && other.getExactResponse().equals(this.getExactResponse()) == false)
            return false;
        if (other.getExactResponseFields() == null ^ this.getExactResponseFields() == null)
            return false;
        if (other.getExactResponseFields() != null && other.getExactResponseFields().equals(this.getExactResponseFields()) == false)
            return false;
        if (other.getIncludeFields() == null ^ this.getIncludeFields() == null)
            return false;
        if (other.getIncludeFields() != null && other.getIncludeFields().equals(this.getIncludeFields()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getDomainEndpoint() == null) ? 0 : getDomainEndpoint().hashCode());
        hashCode = prime * hashCode + ((getIndexName() == null) ? 0 : getIndexName().hashCode());
        hashCode = prime * hashCode + ((getExactResponse() == null) ? 0 : getExactResponse().hashCode());
        hashCode = prime * hashCode + ((getExactResponseFields() == null) ? 0 : getExactResponseFields().hashCode());
        hashCode = prime * hashCode + ((getIncludeFields() == null) ? 0 : getIncludeFields().hashCode());
        return hashCode;
    }

    @Override
    public OpensearchConfiguration clone() {
        try {
            return (OpensearchConfiguration) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.lexmodelsv2.model.transform.OpensearchConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
