/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.lexmodelsv2.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.lexmodelsv2.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * SlotValueElicitationSetting JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class SlotValueElicitationSettingJsonUnmarshaller implements Unmarshaller<SlotValueElicitationSetting, JsonUnmarshallerContext> {

    public SlotValueElicitationSetting unmarshall(JsonUnmarshallerContext context) throws Exception {
        SlotValueElicitationSetting slotValueElicitationSetting = new SlotValueElicitationSetting();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("defaultValueSpecification", targetDepth)) {
                    context.nextToken();
                    slotValueElicitationSetting.setDefaultValueSpecification(SlotDefaultValueSpecificationJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("slotConstraint", targetDepth)) {
                    context.nextToken();
                    slotValueElicitationSetting.setSlotConstraint(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("promptSpecification", targetDepth)) {
                    context.nextToken();
                    slotValueElicitationSetting.setPromptSpecification(PromptSpecificationJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("sampleUtterances", targetDepth)) {
                    context.nextToken();
                    slotValueElicitationSetting.setSampleUtterances(new ListUnmarshaller<SampleUtterance>(SampleUtteranceJsonUnmarshaller.getInstance())

                    .unmarshall(context));
                }
                if (context.testExpression("waitAndContinueSpecification", targetDepth)) {
                    context.nextToken();
                    slotValueElicitationSetting.setWaitAndContinueSpecification(WaitAndContinueSpecificationJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("slotCaptureSetting", targetDepth)) {
                    context.nextToken();
                    slotValueElicitationSetting.setSlotCaptureSetting(SlotCaptureSettingJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("slotResolutionSetting", targetDepth)) {
                    context.nextToken();
                    slotValueElicitationSetting.setSlotResolutionSetting(SlotResolutionSettingJsonUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return slotValueElicitationSetting;
    }

    private static SlotValueElicitationSettingJsonUnmarshaller instance;

    public static SlotValueElicitationSettingJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new SlotValueElicitationSettingJsonUnmarshaller();
        return instance;
    }
}
