/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.lexmodelsv2.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotAlias" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DeleteBotAliasRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The unique identifier of the bot alias to delete.
     * </p>
     */
    private String botAliasId;
    /**
     * <p>
     * The unique identifier of the bot associated with the alias to delete.
     * </p>
     */
    private String botId;
    /**
     * <p>
     * By default, Amazon Lex checks if any other resource, such as a bot network, is using the bot alias before it is
     * deleted and throws a <code>ResourceInUseException</code> exception if the alias is being used by another
     * resource. Set this parameter to <code>true</code> to skip this check and remove the alias even if it is being
     * used by another resource.
     * </p>
     */
    private Boolean skipResourceInUseCheck;

    /**
     * <p>
     * The unique identifier of the bot alias to delete.
     * </p>
     * 
     * @param botAliasId
     *        The unique identifier of the bot alias to delete.
     */

    public void setBotAliasId(String botAliasId) {
        this.botAliasId = botAliasId;
    }

    /**
     * <p>
     * The unique identifier of the bot alias to delete.
     * </p>
     * 
     * @return The unique identifier of the bot alias to delete.
     */

    public String getBotAliasId() {
        return this.botAliasId;
    }

    /**
     * <p>
     * The unique identifier of the bot alias to delete.
     * </p>
     * 
     * @param botAliasId
     *        The unique identifier of the bot alias to delete.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DeleteBotAliasRequest withBotAliasId(String botAliasId) {
        setBotAliasId(botAliasId);
        return this;
    }

    /**
     * <p>
     * The unique identifier of the bot associated with the alias to delete.
     * </p>
     * 
     * @param botId
     *        The unique identifier of the bot associated with the alias to delete.
     */

    public void setBotId(String botId) {
        this.botId = botId;
    }

    /**
     * <p>
     * The unique identifier of the bot associated with the alias to delete.
     * </p>
     * 
     * @return The unique identifier of the bot associated with the alias to delete.
     */

    public String getBotId() {
        return this.botId;
    }

    /**
     * <p>
     * The unique identifier of the bot associated with the alias to delete.
     * </p>
     * 
     * @param botId
     *        The unique identifier of the bot associated with the alias to delete.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DeleteBotAliasRequest withBotId(String botId) {
        setBotId(botId);
        return this;
    }

    /**
     * <p>
     * By default, Amazon Lex checks if any other resource, such as a bot network, is using the bot alias before it is
     * deleted and throws a <code>ResourceInUseException</code> exception if the alias is being used by another
     * resource. Set this parameter to <code>true</code> to skip this check and remove the alias even if it is being
     * used by another resource.
     * </p>
     * 
     * @param skipResourceInUseCheck
     *        By default, Amazon Lex checks if any other resource, such as a bot network, is using the bot alias before
     *        it is deleted and throws a <code>ResourceInUseException</code> exception if the alias is being used by
     *        another resource. Set this parameter to <code>true</code> to skip this check and remove the alias even if
     *        it is being used by another resource.
     */

    public void setSkipResourceInUseCheck(Boolean skipResourceInUseCheck) {
        this.skipResourceInUseCheck = skipResourceInUseCheck;
    }

    /**
     * <p>
     * By default, Amazon Lex checks if any other resource, such as a bot network, is using the bot alias before it is
     * deleted and throws a <code>ResourceInUseException</code> exception if the alias is being used by another
     * resource. Set this parameter to <code>true</code> to skip this check and remove the alias even if it is being
     * used by another resource.
     * </p>
     * 
     * @return By default, Amazon Lex checks if any other resource, such as a bot network, is using the bot alias before
     *         it is deleted and throws a <code>ResourceInUseException</code> exception if the alias is being used by
     *         another resource. Set this parameter to <code>true</code> to skip this check and remove the alias even if
     *         it is being used by another resource.
     */

    public Boolean getSkipResourceInUseCheck() {
        return this.skipResourceInUseCheck;
    }

    /**
     * <p>
     * By default, Amazon Lex checks if any other resource, such as a bot network, is using the bot alias before it is
     * deleted and throws a <code>ResourceInUseException</code> exception if the alias is being used by another
     * resource. Set this parameter to <code>true</code> to skip this check and remove the alias even if it is being
     * used by another resource.
     * </p>
     * 
     * @param skipResourceInUseCheck
     *        By default, Amazon Lex checks if any other resource, such as a bot network, is using the bot alias before
     *        it is deleted and throws a <code>ResourceInUseException</code> exception if the alias is being used by
     *        another resource. Set this parameter to <code>true</code> to skip this check and remove the alias even if
     *        it is being used by another resource.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DeleteBotAliasRequest withSkipResourceInUseCheck(Boolean skipResourceInUseCheck) {
        setSkipResourceInUseCheck(skipResourceInUseCheck);
        return this;
    }

    /**
     * <p>
     * By default, Amazon Lex checks if any other resource, such as a bot network, is using the bot alias before it is
     * deleted and throws a <code>ResourceInUseException</code> exception if the alias is being used by another
     * resource. Set this parameter to <code>true</code> to skip this check and remove the alias even if it is being
     * used by another resource.
     * </p>
     * 
     * @return By default, Amazon Lex checks if any other resource, such as a bot network, is using the bot alias before
     *         it is deleted and throws a <code>ResourceInUseException</code> exception if the alias is being used by
     *         another resource. Set this parameter to <code>true</code> to skip this check and remove the alias even if
     *         it is being used by another resource.
     */

    public Boolean isSkipResourceInUseCheck() {
        return this.skipResourceInUseCheck;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getBotAliasId() != null)
            sb.append("BotAliasId: ").append(getBotAliasId()).append(",");
        if (getBotId() != null)
            sb.append("BotId: ").append(getBotId()).append(",");
        if (getSkipResourceInUseCheck() != null)
            sb.append("SkipResourceInUseCheck: ").append(getSkipResourceInUseCheck());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DeleteBotAliasRequest == false)
            return false;
        DeleteBotAliasRequest other = (DeleteBotAliasRequest) obj;
        if (other.getBotAliasId() == null ^ this.getBotAliasId() == null)
            return false;
        if (other.getBotAliasId() != null && other.getBotAliasId().equals(this.getBotAliasId()) == false)
            return false;
        if (other.getBotId() == null ^ this.getBotId() == null)
            return false;
        if (other.getBotId() != null && other.getBotId().equals(this.getBotId()) == false)
            return false;
        if (other.getSkipResourceInUseCheck() == null ^ this.getSkipResourceInUseCheck() == null)
            return false;
        if (other.getSkipResourceInUseCheck() != null && other.getSkipResourceInUseCheck().equals(this.getSkipResourceInUseCheck()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getBotAliasId() == null) ? 0 : getBotAliasId().hashCode());
        hashCode = prime * hashCode + ((getBotId() == null) ? 0 : getBotId().hashCode());
        hashCode = prime * hashCode + ((getSkipResourceInUseCheck() == null) ? 0 : getSkipResourceInUseCheck().hashCode());
        return hashCode;
    }

    @Override
    public DeleteBotAliasRequest clone() {
        return (DeleteBotAliasRequest) super.clone();
    }

}
