/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexmodelsv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lexmodelsv2.model.Specifications;
import com.amazonaws.services.lexmodelsv2.model.transform.SubSlotSettingMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class SubSlotSetting
implements Serializable,
Cloneable,
StructuredPojo {
    private String expression;
    private Map<String, Specifications> slotSpecifications;

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getExpression() {
        return this.expression;
    }

    public SubSlotSetting withExpression(String expression) {
        this.setExpression(expression);
        return this;
    }

    public Map<String, Specifications> getSlotSpecifications() {
        return this.slotSpecifications;
    }

    public void setSlotSpecifications(Map<String, Specifications> slotSpecifications) {
        this.slotSpecifications = slotSpecifications;
    }

    public SubSlotSetting withSlotSpecifications(Map<String, Specifications> slotSpecifications) {
        this.setSlotSpecifications(slotSpecifications);
        return this;
    }

    public SubSlotSetting addSlotSpecificationsEntry(String key, Specifications value) {
        if (null == this.slotSpecifications) {
            this.slotSpecifications = new HashMap<String, Specifications>();
        }
        if (this.slotSpecifications.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.slotSpecifications.put(key, value);
        return this;
    }

    public SubSlotSetting clearSlotSpecificationsEntries() {
        this.slotSpecifications = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getExpression() != null) {
            sb.append("Expression: ").append(this.getExpression()).append(",");
        }
        if (this.getSlotSpecifications() != null) {
            sb.append("SlotSpecifications: ").append(this.getSlotSpecifications());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubSlotSetting)) {
            return false;
        }
        SubSlotSetting other = (SubSlotSetting)obj;
        if (other.getExpression() == null ^ this.getExpression() == null) {
            return false;
        }
        if (other.getExpression() != null && !other.getExpression().equals(this.getExpression())) {
            return false;
        }
        if (other.getSlotSpecifications() == null ^ this.getSlotSpecifications() == null) {
            return false;
        }
        return other.getSlotSpecifications() == null || other.getSlotSpecifications().equals(this.getSlotSpecifications());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getExpression() == null ? 0 : this.getExpression().hashCode());
        hashCode = 31 * hashCode + (this.getSlotSpecifications() == null ? 0 : this.getSlotSpecifications().hashCode());
        return hashCode;
    }

    public SubSlotSetting clone() {
        try {
            return (SubSlotSetting)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SubSlotSettingMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

