/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.licensemanager;

import javax.annotation.Generated;

import com.amazonaws.services.licensemanager.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSLicenseManager}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSLicenseManager implements AWSLicenseManager {

    protected AbstractAWSLicenseManager() {
    }

    @Override
    public AcceptGrantResult acceptGrant(AcceptGrantRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CheckInLicenseResult checkInLicense(CheckInLicenseRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CheckoutBorrowLicenseResult checkoutBorrowLicense(CheckoutBorrowLicenseRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CheckoutLicenseResult checkoutLicense(CheckoutLicenseRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateGrantResult createGrant(CreateGrantRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateGrantVersionResult createGrantVersion(CreateGrantVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateLicenseResult createLicense(CreateLicenseRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateLicenseConfigurationResult createLicenseConfiguration(CreateLicenseConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateLicenseConversionTaskForResourceResult createLicenseConversionTaskForResource(CreateLicenseConversionTaskForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateLicenseManagerReportGeneratorResult createLicenseManagerReportGenerator(CreateLicenseManagerReportGeneratorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateLicenseVersionResult createLicenseVersion(CreateLicenseVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTokenResult createToken(CreateTokenRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteGrantResult deleteGrant(DeleteGrantRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteLicenseResult deleteLicense(DeleteLicenseRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteLicenseConfigurationResult deleteLicenseConfiguration(DeleteLicenseConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteLicenseManagerReportGeneratorResult deleteLicenseManagerReportGenerator(DeleteLicenseManagerReportGeneratorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteTokenResult deleteToken(DeleteTokenRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ExtendLicenseConsumptionResult extendLicenseConsumption(ExtendLicenseConsumptionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAccessTokenResult getAccessToken(GetAccessTokenRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetGrantResult getGrant(GetGrantRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetLicenseResult getLicense(GetLicenseRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetLicenseConfigurationResult getLicenseConfiguration(GetLicenseConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetLicenseConversionTaskResult getLicenseConversionTask(GetLicenseConversionTaskRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetLicenseManagerReportGeneratorResult getLicenseManagerReportGenerator(GetLicenseManagerReportGeneratorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetLicenseUsageResult getLicenseUsage(GetLicenseUsageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetServiceSettingsResult getServiceSettings(GetServiceSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAssociationsForLicenseConfigurationResult listAssociationsForLicenseConfiguration(ListAssociationsForLicenseConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDistributedGrantsResult listDistributedGrants(ListDistributedGrantsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListFailuresForLicenseConfigurationOperationsResult listFailuresForLicenseConfigurationOperations(
            ListFailuresForLicenseConfigurationOperationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListLicenseConfigurationsResult listLicenseConfigurations(ListLicenseConfigurationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListLicenseConversionTasksResult listLicenseConversionTasks(ListLicenseConversionTasksRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListLicenseManagerReportGeneratorsResult listLicenseManagerReportGenerators(ListLicenseManagerReportGeneratorsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListLicenseSpecificationsForResourceResult listLicenseSpecificationsForResource(ListLicenseSpecificationsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListLicenseVersionsResult listLicenseVersions(ListLicenseVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListLicensesResult listLicenses(ListLicensesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListReceivedGrantsResult listReceivedGrants(ListReceivedGrantsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListReceivedLicensesResult listReceivedLicenses(ListReceivedLicensesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListResourceInventoryResult listResourceInventory(ListResourceInventoryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTokensResult listTokens(ListTokensRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListUsageForLicenseConfigurationResult listUsageForLicenseConfiguration(ListUsageForLicenseConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RejectGrantResult rejectGrant(RejectGrantRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateLicenseConfigurationResult updateLicenseConfiguration(UpdateLicenseConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateLicenseManagerReportGeneratorResult updateLicenseManagerReportGenerator(UpdateLicenseManagerReportGeneratorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateLicenseSpecificationsForResourceResult updateLicenseSpecificationsForResource(UpdateLicenseSpecificationsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateServiceSettingsResult updateServiceSettings(UpdateServiceSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
