/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.lightsail.model.DeleteDomainRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DeleteDomainRequestMarshaller
implements Marshaller<Request<DeleteDomainRequest>, DeleteDomainRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DeleteDomainRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DeleteDomainRequest> marshall(DeleteDomainRequest deleteDomainRequest) {
        if (deleteDomainRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteDomainRequest, "AmazonLightsail");
        request.addHeader("X-Amz-Target", "Lightsail_20161128.DeleteDomain");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (deleteDomainRequest.getDomainName() != null) {
                jsonGenerator.writeFieldName("domainName").writeValue(deleteDomainRequest.getDomainName());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

