/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.lightsail.model.CreateInstancesFromSnapshotRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class CreateInstancesFromSnapshotRequestMarshaller
implements Marshaller<Request<CreateInstancesFromSnapshotRequest>, CreateInstancesFromSnapshotRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateInstancesFromSnapshotRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateInstancesFromSnapshotRequest> marshall(CreateInstancesFromSnapshotRequest createInstancesFromSnapshotRequest) {
        if (createInstancesFromSnapshotRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createInstancesFromSnapshotRequest, "AmazonLightsail");
        request.addHeader("X-Amz-Target", "Lightsail_20161128.CreateInstancesFromSnapshot");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            List<String> instanceNamesList = createInstancesFromSnapshotRequest.getInstanceNames();
            if (instanceNamesList != null) {
                jsonGenerator.writeFieldName("instanceNames");
                jsonGenerator.writeStartArray();
                for (String instanceNamesListValue : instanceNamesList) {
                    if (instanceNamesListValue == null) continue;
                    jsonGenerator.writeValue(instanceNamesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (createInstancesFromSnapshotRequest.getAvailabilityZone() != null) {
                jsonGenerator.writeFieldName("availabilityZone").writeValue(createInstancesFromSnapshotRequest.getAvailabilityZone());
            }
            if (createInstancesFromSnapshotRequest.getInstanceSnapshotName() != null) {
                jsonGenerator.writeFieldName("instanceSnapshotName").writeValue(createInstancesFromSnapshotRequest.getInstanceSnapshotName());
            }
            if (createInstancesFromSnapshotRequest.getBundleId() != null) {
                jsonGenerator.writeFieldName("bundleId").writeValue(createInstancesFromSnapshotRequest.getBundleId());
            }
            if (createInstancesFromSnapshotRequest.getUserData() != null) {
                jsonGenerator.writeFieldName("userData").writeValue(createInstancesFromSnapshotRequest.getUserData());
            }
            if (createInstancesFromSnapshotRequest.getKeyPairName() != null) {
                jsonGenerator.writeFieldName("keyPairName").writeValue(createInstancesFromSnapshotRequest.getKeyPairName());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

