/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.lightsail.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateRelationalDatabase" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class UpdateRelationalDatabaseRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The name of your Lightsail database resource to update.
     * </p>
     */
    private String relationalDatabaseName;
    /**
     * <p>
     * The password for the master user. The password can include any printable ASCII character except "/", """, or "@".
     * </p>
     * <p>
     * My<b>SQL</b>
     * </p>
     * <p>
     * Constraints: Must contain from 8 to 41 characters.
     * </p>
     * <p>
     * <b>PostgreSQL</b>
     * </p>
     * <p>
     * Constraints: Must contain from 8 to 128 characters.
     * </p>
     */
    private String masterUserPassword;
    /**
     * <p>
     * When <code>true</code>, the master user password is changed to a new strong password generated by Lightsail.
     * </p>
     * <p>
     * Use the <code>get relational database master user password</code> operation to get the new password.
     * </p>
     */
    private Boolean rotateMasterUserPassword;
    /**
     * <p>
     * The daily time range during which automated backups are created for your database if automated backups are
     * enabled.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be in the <code>hh24:mi-hh24:mi</code> format.
     * </p>
     * <p>
     * Example: <code>16:00-16:30</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Specified in Coordinated Universal Time (UTC).
     * </p>
     * </li>
     * <li>
     * <p>
     * Must not conflict with the preferred maintenance window.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be at least 30 minutes.
     * </p>
     * </li>
     * </ul>
     */
    private String preferredBackupWindow;
    /**
     * <p>
     * The weekly time range during which system maintenance can occur on your database.
     * </p>
     * <p>
     * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring
     * on a random day of the week.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be in the <code>ddd:hh24:mi-ddd:hh24:mi</code> format.
     * </p>
     * </li>
     * <li>
     * <p>
     * Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be at least 30 minutes.
     * </p>
     * </li>
     * <li>
     * <p>
     * Specified in Coordinated Universal Time (UTC).
     * </p>
     * </li>
     * <li>
     * <p>
     * Example: <code>Tue:17:00-Tue:17:30</code>
     * </p>
     * </li>
     * </ul>
     */
    private String preferredMaintenanceWindow;
    /**
     * <p>
     * When <code>true</code>, enables automated backup retention for your database.
     * </p>
     * <p>
     * Updates are applied during the next maintenance window because this can result in an outage.
     * </p>
     */
    private Boolean enableBackupRetention;
    /**
     * <p>
     * When <code>true</code>, disables automated backup retention for your database.
     * </p>
     * <p>
     * Disabling backup retention deletes all automated database backups. Before disabling this, you may want to create
     * a snapshot of your database using the <code>create relational database snapshot</code> operation.
     * </p>
     * <p>
     * Updates are applied during the next maintenance window because this can result in an outage.
     * </p>
     */
    private Boolean disableBackupRetention;
    /**
     * <p>
     * Specifies the accessibility options for your database. A value of <code>true</code> specifies a database that is
     * available to resources outside of your Lightsail account. A value of <code>false</code> specifies a database that
     * is available only to your Lightsail resources in the same region as your database.
     * </p>
     */
    private Boolean publiclyAccessible;
    /**
     * <p>
     * When <code>true</code>, applies changes immediately. When <code>false</code>, applies changes during the
     * preferred maintenance window. Some changes may cause an outage.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     */
    private Boolean applyImmediately;
    /**
     * <p>
     * Indicates the certificate that needs to be associated with the database.
     * </p>
     */
    private String caCertificateIdentifier;

    /**
     * <p>
     * The name of your Lightsail database resource to update.
     * </p>
     * 
     * @param relationalDatabaseName
     *        The name of your Lightsail database resource to update.
     */

    public void setRelationalDatabaseName(String relationalDatabaseName) {
        this.relationalDatabaseName = relationalDatabaseName;
    }

    /**
     * <p>
     * The name of your Lightsail database resource to update.
     * </p>
     * 
     * @return The name of your Lightsail database resource to update.
     */

    public String getRelationalDatabaseName() {
        return this.relationalDatabaseName;
    }

    /**
     * <p>
     * The name of your Lightsail database resource to update.
     * </p>
     * 
     * @param relationalDatabaseName
     *        The name of your Lightsail database resource to update.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateRelationalDatabaseRequest withRelationalDatabaseName(String relationalDatabaseName) {
        setRelationalDatabaseName(relationalDatabaseName);
        return this;
    }

    /**
     * <p>
     * The password for the master user. The password can include any printable ASCII character except "/", """, or "@".
     * </p>
     * <p>
     * My<b>SQL</b>
     * </p>
     * <p>
     * Constraints: Must contain from 8 to 41 characters.
     * </p>
     * <p>
     * <b>PostgreSQL</b>
     * </p>
     * <p>
     * Constraints: Must contain from 8 to 128 characters.
     * </p>
     * 
     * @param masterUserPassword
     *        The password for the master user. The password can include any printable ASCII character except "/",
     *        """, or "@".</p>
     *        <p>
     *        My<b>SQL</b>
     *        </p>
     *        <p>
     *        Constraints: Must contain from 8 to 41 characters.
     *        </p>
     *        <p>
     *        <b>PostgreSQL</b>
     *        </p>
     *        <p>
     *        Constraints: Must contain from 8 to 128 characters.
     */

    public void setMasterUserPassword(String masterUserPassword) {
        this.masterUserPassword = masterUserPassword;
    }

    /**
     * <p>
     * The password for the master user. The password can include any printable ASCII character except "/", """, or "@".
     * </p>
     * <p>
     * My<b>SQL</b>
     * </p>
     * <p>
     * Constraints: Must contain from 8 to 41 characters.
     * </p>
     * <p>
     * <b>PostgreSQL</b>
     * </p>
     * <p>
     * Constraints: Must contain from 8 to 128 characters.
     * </p>
     * 
     * @return The password for the master user. The password can include any printable ASCII character except "/",
     *         """, or "@".</p>
     *         <p>
     *         My<b>SQL</b>
     *         </p>
     *         <p>
     *         Constraints: Must contain from 8 to 41 characters.
     *         </p>
     *         <p>
     *         <b>PostgreSQL</b>
     *         </p>
     *         <p>
     *         Constraints: Must contain from 8 to 128 characters.
     */

    public String getMasterUserPassword() {
        return this.masterUserPassword;
    }

    /**
     * <p>
     * The password for the master user. The password can include any printable ASCII character except "/", """, or "@".
     * </p>
     * <p>
     * My<b>SQL</b>
     * </p>
     * <p>
     * Constraints: Must contain from 8 to 41 characters.
     * </p>
     * <p>
     * <b>PostgreSQL</b>
     * </p>
     * <p>
     * Constraints: Must contain from 8 to 128 characters.
     * </p>
     * 
     * @param masterUserPassword
     *        The password for the master user. The password can include any printable ASCII character except "/",
     *        """, or "@".</p>
     *        <p>
     *        My<b>SQL</b>
     *        </p>
     *        <p>
     *        Constraints: Must contain from 8 to 41 characters.
     *        </p>
     *        <p>
     *        <b>PostgreSQL</b>
     *        </p>
     *        <p>
     *        Constraints: Must contain from 8 to 128 characters.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateRelationalDatabaseRequest withMasterUserPassword(String masterUserPassword) {
        setMasterUserPassword(masterUserPassword);
        return this;
    }

    /**
     * <p>
     * When <code>true</code>, the master user password is changed to a new strong password generated by Lightsail.
     * </p>
     * <p>
     * Use the <code>get relational database master user password</code> operation to get the new password.
     * </p>
     * 
     * @param rotateMasterUserPassword
     *        When <code>true</code>, the master user password is changed to a new strong password generated by
     *        Lightsail.</p>
     *        <p>
     *        Use the <code>get relational database master user password</code> operation to get the new password.
     */

    public void setRotateMasterUserPassword(Boolean rotateMasterUserPassword) {
        this.rotateMasterUserPassword = rotateMasterUserPassword;
    }

    /**
     * <p>
     * When <code>true</code>, the master user password is changed to a new strong password generated by Lightsail.
     * </p>
     * <p>
     * Use the <code>get relational database master user password</code> operation to get the new password.
     * </p>
     * 
     * @return When <code>true</code>, the master user password is changed to a new strong password generated by
     *         Lightsail.</p>
     *         <p>
     *         Use the <code>get relational database master user password</code> operation to get the new password.
     */

    public Boolean getRotateMasterUserPassword() {
        return this.rotateMasterUserPassword;
    }

    /**
     * <p>
     * When <code>true</code>, the master user password is changed to a new strong password generated by Lightsail.
     * </p>
     * <p>
     * Use the <code>get relational database master user password</code> operation to get the new password.
     * </p>
     * 
     * @param rotateMasterUserPassword
     *        When <code>true</code>, the master user password is changed to a new strong password generated by
     *        Lightsail.</p>
     *        <p>
     *        Use the <code>get relational database master user password</code> operation to get the new password.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateRelationalDatabaseRequest withRotateMasterUserPassword(Boolean rotateMasterUserPassword) {
        setRotateMasterUserPassword(rotateMasterUserPassword);
        return this;
    }

    /**
     * <p>
     * When <code>true</code>, the master user password is changed to a new strong password generated by Lightsail.
     * </p>
     * <p>
     * Use the <code>get relational database master user password</code> operation to get the new password.
     * </p>
     * 
     * @return When <code>true</code>, the master user password is changed to a new strong password generated by
     *         Lightsail.</p>
     *         <p>
     *         Use the <code>get relational database master user password</code> operation to get the new password.
     */

    public Boolean isRotateMasterUserPassword() {
        return this.rotateMasterUserPassword;
    }

    /**
     * <p>
     * The daily time range during which automated backups are created for your database if automated backups are
     * enabled.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be in the <code>hh24:mi-hh24:mi</code> format.
     * </p>
     * <p>
     * Example: <code>16:00-16:30</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Specified in Coordinated Universal Time (UTC).
     * </p>
     * </li>
     * <li>
     * <p>
     * Must not conflict with the preferred maintenance window.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be at least 30 minutes.
     * </p>
     * </li>
     * </ul>
     * 
     * @param preferredBackupWindow
     *        The daily time range during which automated backups are created for your database if automated backups are
     *        enabled.</p>
     *        <p>
     *        Constraints:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        Must be in the <code>hh24:mi-hh24:mi</code> format.
     *        </p>
     *        <p>
     *        Example: <code>16:00-16:30</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Specified in Coordinated Universal Time (UTC).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Must not conflict with the preferred maintenance window.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Must be at least 30 minutes.
     *        </p>
     *        </li>
     */

    public void setPreferredBackupWindow(String preferredBackupWindow) {
        this.preferredBackupWindow = preferredBackupWindow;
    }

    /**
     * <p>
     * The daily time range during which automated backups are created for your database if automated backups are
     * enabled.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be in the <code>hh24:mi-hh24:mi</code> format.
     * </p>
     * <p>
     * Example: <code>16:00-16:30</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Specified in Coordinated Universal Time (UTC).
     * </p>
     * </li>
     * <li>
     * <p>
     * Must not conflict with the preferred maintenance window.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be at least 30 minutes.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The daily time range during which automated backups are created for your database if automated backups
     *         are enabled.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be in the <code>hh24:mi-hh24:mi</code> format.
     *         </p>
     *         <p>
     *         Example: <code>16:00-16:30</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specified in Coordinated Universal Time (UTC).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must not conflict with the preferred maintenance window.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be at least 30 minutes.
     *         </p>
     *         </li>
     */

    public String getPreferredBackupWindow() {
        return this.preferredBackupWindow;
    }

    /**
     * <p>
     * The daily time range during which automated backups are created for your database if automated backups are
     * enabled.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be in the <code>hh24:mi-hh24:mi</code> format.
     * </p>
     * <p>
     * Example: <code>16:00-16:30</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Specified in Coordinated Universal Time (UTC).
     * </p>
     * </li>
     * <li>
     * <p>
     * Must not conflict with the preferred maintenance window.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be at least 30 minutes.
     * </p>
     * </li>
     * </ul>
     * 
     * @param preferredBackupWindow
     *        The daily time range during which automated backups are created for your database if automated backups are
     *        enabled.</p>
     *        <p>
     *        Constraints:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        Must be in the <code>hh24:mi-hh24:mi</code> format.
     *        </p>
     *        <p>
     *        Example: <code>16:00-16:30</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Specified in Coordinated Universal Time (UTC).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Must not conflict with the preferred maintenance window.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Must be at least 30 minutes.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateRelationalDatabaseRequest withPreferredBackupWindow(String preferredBackupWindow) {
        setPreferredBackupWindow(preferredBackupWindow);
        return this;
    }

    /**
     * <p>
     * The weekly time range during which system maintenance can occur on your database.
     * </p>
     * <p>
     * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring
     * on a random day of the week.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be in the <code>ddd:hh24:mi-ddd:hh24:mi</code> format.
     * </p>
     * </li>
     * <li>
     * <p>
     * Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be at least 30 minutes.
     * </p>
     * </li>
     * <li>
     * <p>
     * Specified in Coordinated Universal Time (UTC).
     * </p>
     * </li>
     * <li>
     * <p>
     * Example: <code>Tue:17:00-Tue:17:30</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @param preferredMaintenanceWindow
     *        The weekly time range during which system maintenance can occur on your database.</p>
     *        <p>
     *        The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region,
     *        occurring on a random day of the week.
     *        </p>
     *        <p>
     *        Constraints:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        Must be in the <code>ddd:hh24:mi-ddd:hh24:mi</code> format.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Must be at least 30 minutes.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Specified in Coordinated Universal Time (UTC).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Example: <code>Tue:17:00-Tue:17:30</code>
     *        </p>
     *        </li>
     */

    public void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
    }

    /**
     * <p>
     * The weekly time range during which system maintenance can occur on your database.
     * </p>
     * <p>
     * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring
     * on a random day of the week.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be in the <code>ddd:hh24:mi-ddd:hh24:mi</code> format.
     * </p>
     * </li>
     * <li>
     * <p>
     * Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be at least 30 minutes.
     * </p>
     * </li>
     * <li>
     * <p>
     * Specified in Coordinated Universal Time (UTC).
     * </p>
     * </li>
     * <li>
     * <p>
     * Example: <code>Tue:17:00-Tue:17:30</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The weekly time range during which system maintenance can occur on your database.</p>
     *         <p>
     *         The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region,
     *         occurring on a random day of the week.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be in the <code>ddd:hh24:mi-ddd:hh24:mi</code> format.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be at least 30 minutes.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specified in Coordinated Universal Time (UTC).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Example: <code>Tue:17:00-Tue:17:30</code>
     *         </p>
     *         </li>
     */

    public String getPreferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    /**
     * <p>
     * The weekly time range during which system maintenance can occur on your database.
     * </p>
     * <p>
     * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring
     * on a random day of the week.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be in the <code>ddd:hh24:mi-ddd:hh24:mi</code> format.
     * </p>
     * </li>
     * <li>
     * <p>
     * Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be at least 30 minutes.
     * </p>
     * </li>
     * <li>
     * <p>
     * Specified in Coordinated Universal Time (UTC).
     * </p>
     * </li>
     * <li>
     * <p>
     * Example: <code>Tue:17:00-Tue:17:30</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @param preferredMaintenanceWindow
     *        The weekly time range during which system maintenance can occur on your database.</p>
     *        <p>
     *        The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region,
     *        occurring on a random day of the week.
     *        </p>
     *        <p>
     *        Constraints:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        Must be in the <code>ddd:hh24:mi-ddd:hh24:mi</code> format.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Must be at least 30 minutes.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Specified in Coordinated Universal Time (UTC).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Example: <code>Tue:17:00-Tue:17:30</code>
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateRelationalDatabaseRequest withPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        setPreferredMaintenanceWindow(preferredMaintenanceWindow);
        return this;
    }

    /**
     * <p>
     * When <code>true</code>, enables automated backup retention for your database.
     * </p>
     * <p>
     * Updates are applied during the next maintenance window because this can result in an outage.
     * </p>
     * 
     * @param enableBackupRetention
     *        When <code>true</code>, enables automated backup retention for your database.</p>
     *        <p>
     *        Updates are applied during the next maintenance window because this can result in an outage.
     */

    public void setEnableBackupRetention(Boolean enableBackupRetention) {
        this.enableBackupRetention = enableBackupRetention;
    }

    /**
     * <p>
     * When <code>true</code>, enables automated backup retention for your database.
     * </p>
     * <p>
     * Updates are applied during the next maintenance window because this can result in an outage.
     * </p>
     * 
     * @return When <code>true</code>, enables automated backup retention for your database.</p>
     *         <p>
     *         Updates are applied during the next maintenance window because this can result in an outage.
     */

    public Boolean getEnableBackupRetention() {
        return this.enableBackupRetention;
    }

    /**
     * <p>
     * When <code>true</code>, enables automated backup retention for your database.
     * </p>
     * <p>
     * Updates are applied during the next maintenance window because this can result in an outage.
     * </p>
     * 
     * @param enableBackupRetention
     *        When <code>true</code>, enables automated backup retention for your database.</p>
     *        <p>
     *        Updates are applied during the next maintenance window because this can result in an outage.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateRelationalDatabaseRequest withEnableBackupRetention(Boolean enableBackupRetention) {
        setEnableBackupRetention(enableBackupRetention);
        return this;
    }

    /**
     * <p>
     * When <code>true</code>, enables automated backup retention for your database.
     * </p>
     * <p>
     * Updates are applied during the next maintenance window because this can result in an outage.
     * </p>
     * 
     * @return When <code>true</code>, enables automated backup retention for your database.</p>
     *         <p>
     *         Updates are applied during the next maintenance window because this can result in an outage.
     */

    public Boolean isEnableBackupRetention() {
        return this.enableBackupRetention;
    }

    /**
     * <p>
     * When <code>true</code>, disables automated backup retention for your database.
     * </p>
     * <p>
     * Disabling backup retention deletes all automated database backups. Before disabling this, you may want to create
     * a snapshot of your database using the <code>create relational database snapshot</code> operation.
     * </p>
     * <p>
     * Updates are applied during the next maintenance window because this can result in an outage.
     * </p>
     * 
     * @param disableBackupRetention
     *        When <code>true</code>, disables automated backup retention for your database.</p>
     *        <p>
     *        Disabling backup retention deletes all automated database backups. Before disabling this, you may want to
     *        create a snapshot of your database using the <code>create relational database snapshot</code> operation.
     *        </p>
     *        <p>
     *        Updates are applied during the next maintenance window because this can result in an outage.
     */

    public void setDisableBackupRetention(Boolean disableBackupRetention) {
        this.disableBackupRetention = disableBackupRetention;
    }

    /**
     * <p>
     * When <code>true</code>, disables automated backup retention for your database.
     * </p>
     * <p>
     * Disabling backup retention deletes all automated database backups. Before disabling this, you may want to create
     * a snapshot of your database using the <code>create relational database snapshot</code> operation.
     * </p>
     * <p>
     * Updates are applied during the next maintenance window because this can result in an outage.
     * </p>
     * 
     * @return When <code>true</code>, disables automated backup retention for your database.</p>
     *         <p>
     *         Disabling backup retention deletes all automated database backups. Before disabling this, you may want to
     *         create a snapshot of your database using the <code>create relational database snapshot</code> operation.
     *         </p>
     *         <p>
     *         Updates are applied during the next maintenance window because this can result in an outage.
     */

    public Boolean getDisableBackupRetention() {
        return this.disableBackupRetention;
    }

    /**
     * <p>
     * When <code>true</code>, disables automated backup retention for your database.
     * </p>
     * <p>
     * Disabling backup retention deletes all automated database backups. Before disabling this, you may want to create
     * a snapshot of your database using the <code>create relational database snapshot</code> operation.
     * </p>
     * <p>
     * Updates are applied during the next maintenance window because this can result in an outage.
     * </p>
     * 
     * @param disableBackupRetention
     *        When <code>true</code>, disables automated backup retention for your database.</p>
     *        <p>
     *        Disabling backup retention deletes all automated database backups. Before disabling this, you may want to
     *        create a snapshot of your database using the <code>create relational database snapshot</code> operation.
     *        </p>
     *        <p>
     *        Updates are applied during the next maintenance window because this can result in an outage.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateRelationalDatabaseRequest withDisableBackupRetention(Boolean disableBackupRetention) {
        setDisableBackupRetention(disableBackupRetention);
        return this;
    }

    /**
     * <p>
     * When <code>true</code>, disables automated backup retention for your database.
     * </p>
     * <p>
     * Disabling backup retention deletes all automated database backups. Before disabling this, you may want to create
     * a snapshot of your database using the <code>create relational database snapshot</code> operation.
     * </p>
     * <p>
     * Updates are applied during the next maintenance window because this can result in an outage.
     * </p>
     * 
     * @return When <code>true</code>, disables automated backup retention for your database.</p>
     *         <p>
     *         Disabling backup retention deletes all automated database backups. Before disabling this, you may want to
     *         create a snapshot of your database using the <code>create relational database snapshot</code> operation.
     *         </p>
     *         <p>
     *         Updates are applied during the next maintenance window because this can result in an outage.
     */

    public Boolean isDisableBackupRetention() {
        return this.disableBackupRetention;
    }

    /**
     * <p>
     * Specifies the accessibility options for your database. A value of <code>true</code> specifies a database that is
     * available to resources outside of your Lightsail account. A value of <code>false</code> specifies a database that
     * is available only to your Lightsail resources in the same region as your database.
     * </p>
     * 
     * @param publiclyAccessible
     *        Specifies the accessibility options for your database. A value of <code>true</code> specifies a database
     *        that is available to resources outside of your Lightsail account. A value of <code>false</code> specifies
     *        a database that is available only to your Lightsail resources in the same region as your database.
     */

    public void setPubliclyAccessible(Boolean publiclyAccessible) {
        this.publiclyAccessible = publiclyAccessible;
    }

    /**
     * <p>
     * Specifies the accessibility options for your database. A value of <code>true</code> specifies a database that is
     * available to resources outside of your Lightsail account. A value of <code>false</code> specifies a database that
     * is available only to your Lightsail resources in the same region as your database.
     * </p>
     * 
     * @return Specifies the accessibility options for your database. A value of <code>true</code> specifies a database
     *         that is available to resources outside of your Lightsail account. A value of <code>false</code> specifies
     *         a database that is available only to your Lightsail resources in the same region as your database.
     */

    public Boolean getPubliclyAccessible() {
        return this.publiclyAccessible;
    }

    /**
     * <p>
     * Specifies the accessibility options for your database. A value of <code>true</code> specifies a database that is
     * available to resources outside of your Lightsail account. A value of <code>false</code> specifies a database that
     * is available only to your Lightsail resources in the same region as your database.
     * </p>
     * 
     * @param publiclyAccessible
     *        Specifies the accessibility options for your database. A value of <code>true</code> specifies a database
     *        that is available to resources outside of your Lightsail account. A value of <code>false</code> specifies
     *        a database that is available only to your Lightsail resources in the same region as your database.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateRelationalDatabaseRequest withPubliclyAccessible(Boolean publiclyAccessible) {
        setPubliclyAccessible(publiclyAccessible);
        return this;
    }

    /**
     * <p>
     * Specifies the accessibility options for your database. A value of <code>true</code> specifies a database that is
     * available to resources outside of your Lightsail account. A value of <code>false</code> specifies a database that
     * is available only to your Lightsail resources in the same region as your database.
     * </p>
     * 
     * @return Specifies the accessibility options for your database. A value of <code>true</code> specifies a database
     *         that is available to resources outside of your Lightsail account. A value of <code>false</code> specifies
     *         a database that is available only to your Lightsail resources in the same region as your database.
     */

    public Boolean isPubliclyAccessible() {
        return this.publiclyAccessible;
    }

    /**
     * <p>
     * When <code>true</code>, applies changes immediately. When <code>false</code>, applies changes during the
     * preferred maintenance window. Some changes may cause an outage.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @param applyImmediately
     *        When <code>true</code>, applies changes immediately. When <code>false</code>, applies changes during the
     *        preferred maintenance window. Some changes may cause an outage.</p>
     *        <p>
     *        Default: <code>false</code>
     */

    public void setApplyImmediately(Boolean applyImmediately) {
        this.applyImmediately = applyImmediately;
    }

    /**
     * <p>
     * When <code>true</code>, applies changes immediately. When <code>false</code>, applies changes during the
     * preferred maintenance window. Some changes may cause an outage.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return When <code>true</code>, applies changes immediately. When <code>false</code>, applies changes during the
     *         preferred maintenance window. Some changes may cause an outage.</p>
     *         <p>
     *         Default: <code>false</code>
     */

    public Boolean getApplyImmediately() {
        return this.applyImmediately;
    }

    /**
     * <p>
     * When <code>true</code>, applies changes immediately. When <code>false</code>, applies changes during the
     * preferred maintenance window. Some changes may cause an outage.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @param applyImmediately
     *        When <code>true</code>, applies changes immediately. When <code>false</code>, applies changes during the
     *        preferred maintenance window. Some changes may cause an outage.</p>
     *        <p>
     *        Default: <code>false</code>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateRelationalDatabaseRequest withApplyImmediately(Boolean applyImmediately) {
        setApplyImmediately(applyImmediately);
        return this;
    }

    /**
     * <p>
     * When <code>true</code>, applies changes immediately. When <code>false</code>, applies changes during the
     * preferred maintenance window. Some changes may cause an outage.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return When <code>true</code>, applies changes immediately. When <code>false</code>, applies changes during the
     *         preferred maintenance window. Some changes may cause an outage.</p>
     *         <p>
     *         Default: <code>false</code>
     */

    public Boolean isApplyImmediately() {
        return this.applyImmediately;
    }

    /**
     * <p>
     * Indicates the certificate that needs to be associated with the database.
     * </p>
     * 
     * @param caCertificateIdentifier
     *        Indicates the certificate that needs to be associated with the database.
     */

    public void setCaCertificateIdentifier(String caCertificateIdentifier) {
        this.caCertificateIdentifier = caCertificateIdentifier;
    }

    /**
     * <p>
     * Indicates the certificate that needs to be associated with the database.
     * </p>
     * 
     * @return Indicates the certificate that needs to be associated with the database.
     */

    public String getCaCertificateIdentifier() {
        return this.caCertificateIdentifier;
    }

    /**
     * <p>
     * Indicates the certificate that needs to be associated with the database.
     * </p>
     * 
     * @param caCertificateIdentifier
     *        Indicates the certificate that needs to be associated with the database.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateRelationalDatabaseRequest withCaCertificateIdentifier(String caCertificateIdentifier) {
        setCaCertificateIdentifier(caCertificateIdentifier);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getRelationalDatabaseName() != null)
            sb.append("RelationalDatabaseName: ").append(getRelationalDatabaseName()).append(",");
        if (getMasterUserPassword() != null)
            sb.append("MasterUserPassword: ").append("***Sensitive Data Redacted***").append(",");
        if (getRotateMasterUserPassword() != null)
            sb.append("RotateMasterUserPassword: ").append(getRotateMasterUserPassword()).append(",");
        if (getPreferredBackupWindow() != null)
            sb.append("PreferredBackupWindow: ").append(getPreferredBackupWindow()).append(",");
        if (getPreferredMaintenanceWindow() != null)
            sb.append("PreferredMaintenanceWindow: ").append(getPreferredMaintenanceWindow()).append(",");
        if (getEnableBackupRetention() != null)
            sb.append("EnableBackupRetention: ").append(getEnableBackupRetention()).append(",");
        if (getDisableBackupRetention() != null)
            sb.append("DisableBackupRetention: ").append(getDisableBackupRetention()).append(",");
        if (getPubliclyAccessible() != null)
            sb.append("PubliclyAccessible: ").append(getPubliclyAccessible()).append(",");
        if (getApplyImmediately() != null)
            sb.append("ApplyImmediately: ").append(getApplyImmediately()).append(",");
        if (getCaCertificateIdentifier() != null)
            sb.append("CaCertificateIdentifier: ").append(getCaCertificateIdentifier());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof UpdateRelationalDatabaseRequest == false)
            return false;
        UpdateRelationalDatabaseRequest other = (UpdateRelationalDatabaseRequest) obj;
        if (other.getRelationalDatabaseName() == null ^ this.getRelationalDatabaseName() == null)
            return false;
        if (other.getRelationalDatabaseName() != null && other.getRelationalDatabaseName().equals(this.getRelationalDatabaseName()) == false)
            return false;
        if (other.getMasterUserPassword() == null ^ this.getMasterUserPassword() == null)
            return false;
        if (other.getMasterUserPassword() != null && other.getMasterUserPassword().equals(this.getMasterUserPassword()) == false)
            return false;
        if (other.getRotateMasterUserPassword() == null ^ this.getRotateMasterUserPassword() == null)
            return false;
        if (other.getRotateMasterUserPassword() != null && other.getRotateMasterUserPassword().equals(this.getRotateMasterUserPassword()) == false)
            return false;
        if (other.getPreferredBackupWindow() == null ^ this.getPreferredBackupWindow() == null)
            return false;
        if (other.getPreferredBackupWindow() != null && other.getPreferredBackupWindow().equals(this.getPreferredBackupWindow()) == false)
            return false;
        if (other.getPreferredMaintenanceWindow() == null ^ this.getPreferredMaintenanceWindow() == null)
            return false;
        if (other.getPreferredMaintenanceWindow() != null && other.getPreferredMaintenanceWindow().equals(this.getPreferredMaintenanceWindow()) == false)
            return false;
        if (other.getEnableBackupRetention() == null ^ this.getEnableBackupRetention() == null)
            return false;
        if (other.getEnableBackupRetention() != null && other.getEnableBackupRetention().equals(this.getEnableBackupRetention()) == false)
            return false;
        if (other.getDisableBackupRetention() == null ^ this.getDisableBackupRetention() == null)
            return false;
        if (other.getDisableBackupRetention() != null && other.getDisableBackupRetention().equals(this.getDisableBackupRetention()) == false)
            return false;
        if (other.getPubliclyAccessible() == null ^ this.getPubliclyAccessible() == null)
            return false;
        if (other.getPubliclyAccessible() != null && other.getPubliclyAccessible().equals(this.getPubliclyAccessible()) == false)
            return false;
        if (other.getApplyImmediately() == null ^ this.getApplyImmediately() == null)
            return false;
        if (other.getApplyImmediately() != null && other.getApplyImmediately().equals(this.getApplyImmediately()) == false)
            return false;
        if (other.getCaCertificateIdentifier() == null ^ this.getCaCertificateIdentifier() == null)
            return false;
        if (other.getCaCertificateIdentifier() != null && other.getCaCertificateIdentifier().equals(this.getCaCertificateIdentifier()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getRelationalDatabaseName() == null) ? 0 : getRelationalDatabaseName().hashCode());
        hashCode = prime * hashCode + ((getMasterUserPassword() == null) ? 0 : getMasterUserPassword().hashCode());
        hashCode = prime * hashCode + ((getRotateMasterUserPassword() == null) ? 0 : getRotateMasterUserPassword().hashCode());
        hashCode = prime * hashCode + ((getPreferredBackupWindow() == null) ? 0 : getPreferredBackupWindow().hashCode());
        hashCode = prime * hashCode + ((getPreferredMaintenanceWindow() == null) ? 0 : getPreferredMaintenanceWindow().hashCode());
        hashCode = prime * hashCode + ((getEnableBackupRetention() == null) ? 0 : getEnableBackupRetention().hashCode());
        hashCode = prime * hashCode + ((getDisableBackupRetention() == null) ? 0 : getDisableBackupRetention().hashCode());
        hashCode = prime * hashCode + ((getPubliclyAccessible() == null) ? 0 : getPubliclyAccessible().hashCode());
        hashCode = prime * hashCode + ((getApplyImmediately() == null) ? 0 : getApplyImmediately().hashCode());
        hashCode = prime * hashCode + ((getCaCertificateIdentifier() == null) ? 0 : getCaCertificateIdentifier().hashCode());
        return hashCode;
    }

    @Override
    public UpdateRelationalDatabaseRequest clone() {
        return (UpdateRelationalDatabaseRequest) super.clone();
    }

}
