/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lightsail.model.ForwardValues;
import com.amazonaws.services.lightsail.model.transform.CookieObjectMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CookieObject
implements Serializable,
Cloneable,
StructuredPojo {
    private String option;
    private List<String> cookiesAllowList;

    public void setOption(String option) {
        this.option = option;
    }

    public String getOption() {
        return this.option;
    }

    public CookieObject withOption(String option) {
        this.setOption(option);
        return this;
    }

    public CookieObject withOption(ForwardValues option) {
        this.option = option.toString();
        return this;
    }

    public List<String> getCookiesAllowList() {
        return this.cookiesAllowList;
    }

    public void setCookiesAllowList(Collection<String> cookiesAllowList) {
        if (cookiesAllowList == null) {
            this.cookiesAllowList = null;
            return;
        }
        this.cookiesAllowList = new ArrayList<String>(cookiesAllowList);
    }

    public CookieObject withCookiesAllowList(String ... cookiesAllowList) {
        if (this.cookiesAllowList == null) {
            this.setCookiesAllowList(new ArrayList<String>(cookiesAllowList.length));
        }
        for (String ele : cookiesAllowList) {
            this.cookiesAllowList.add(ele);
        }
        return this;
    }

    public CookieObject withCookiesAllowList(Collection<String> cookiesAllowList) {
        this.setCookiesAllowList(cookiesAllowList);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOption() != null) {
            sb.append("Option: ").append(this.getOption()).append(",");
        }
        if (this.getCookiesAllowList() != null) {
            sb.append("CookiesAllowList: ").append(this.getCookiesAllowList());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CookieObject)) {
            return false;
        }
        CookieObject other = (CookieObject)obj;
        if (other.getOption() == null ^ this.getOption() == null) {
            return false;
        }
        if (other.getOption() != null && !other.getOption().equals(this.getOption())) {
            return false;
        }
        if (other.getCookiesAllowList() == null ^ this.getCookiesAllowList() == null) {
            return false;
        }
        return other.getCookiesAllowList() == null || other.getCookiesAllowList().equals(this.getCookiesAllowList());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOption() == null ? 0 : this.getOption().hashCode());
        hashCode = 31 * hashCode + (this.getCookiesAllowList() == null ? 0 : this.getCookiesAllowList().hashCode());
        return hashCode;
    }

    public CookieObject clone() {
        try {
            return (CookieObject)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CookieObjectMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

