/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.lightsail.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancerMetricData"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetLoadBalancerMetricDataRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The name of the load balancer.
     * </p>
     */
    private String loadBalancerName;
    /**
     * <p>
     * The metric for which you want to return information.
     * </p>
     * <p>
     * Valid load balancer metric names are listed below, along with the most useful <code>statistics</code> to include
     * in your request, and the published <code>unit</code> value.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>ClientTLSNegotiationErrorCount</code> </b> - The number of TLS connections initiated by the client that
     * did not establish a session with the load balancer due to a TLS error generated by the load balancer. Possible
     * causes include a mismatch of ciphers or protocols.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HealthyHostCount</code> </b> - The number of target instances that are considered healthy.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
     * <code>Maximum</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_Instance_2XX_Count</code> </b> - The number of HTTP 2XX response codes generated by the target
     * instances. This does not include any response codes generated by the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_Instance_3XX_Count</code> </b> - The number of HTTP 3XX response codes generated by the target
     * instances. This does not include any response codes generated by the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_Instance_4XX_Count</code> </b> - The number of HTTP 4XX response codes generated by the target
     * instances. This does not include any response codes generated by the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_Instance_5XX_Count</code> </b> - The number of HTTP 5XX response codes generated by the target
     * instances. This does not include any response codes generated by the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_LB_4XX_Count</code> </b> - The number of HTTP 4XX client error codes that originated from the
     * load balancer. Client errors are generated when requests are malformed or incomplete. These requests were not
     * received by the target instance. This count does not include response codes generated by the target instances.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_LB_5XX_Count</code> </b> - The number of HTTP 5XX server error codes that originated from the
     * load balancer. This does not include any response codes generated by the target instance. This metric is reported
     * if there are no healthy instances attached to the load balancer, or if the request rate exceeds the capacity of
     * the instances (spillover) or the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>InstanceResponseTime</code> </b> - The time elapsed, in seconds, after the request leaves the load
     * balancer until a response from the target instance is received.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Average</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Seconds</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>RejectedConnectionCount</code> </b> - The number of connections that were rejected because the load
     * balancer had reached its maximum number of connections.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>RequestCount</code> </b> - The number of requests processed over IPv4. This count includes only the
     * requests with a response generated by a target instance of the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>UnhealthyHostCount</code> </b> - The number of target instances that are considered unhealthy.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
     * <code>Maximum</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * </ul>
     */
    private String metricName;
    /**
     * <p>
     * The granularity, in seconds, of the returned data points.
     * </p>
     */
    private Integer period;
    /**
     * <p>
     * The start time of the period.
     * </p>
     */
    private java.util.Date startTime;
    /**
     * <p>
     * The end time of the period.
     * </p>
     */
    private java.util.Date endTime;
    /**
     * <p>
     * The unit for the metric data request. Valid units depend on the metric data being requested. For the valid units
     * with each available metric, see the <code>metricName</code> parameter.
     * </p>
     */
    private String unit;
    /**
     * <p>
     * The statistic for the metric.
     * </p>
     * <p>
     * The following statistics are available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Minimum</code> - The lowest value observed during the specified period. Use this value to determine low
     * volumes of activity for your application.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Maximum</code> - The highest value observed during the specified period. Use this value to determine high
     * volumes of activity for your application.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Sum</code> - All values submitted for the matching metric added together. You can use this statistic to
     * determine the total volume of a metric.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Average</code> - The value of Sum / SampleCount during the specified period. By comparing this statistic
     * with the Minimum and Maximum values, you can determine the full scope of a metric and how close the average use
     * is to the Minimum and Maximum values. This comparison helps you to know when to increase or decrease your
     * resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SampleCount</code> - The count, or number, of data points used for the statistical calculation.
     * </p>
     * </li>
     * </ul>
     */
    private java.util.List<String> statistics;

    /**
     * <p>
     * The name of the load balancer.
     * </p>
     * 
     * @param loadBalancerName
     *        The name of the load balancer.
     */

    public void setLoadBalancerName(String loadBalancerName) {
        this.loadBalancerName = loadBalancerName;
    }

    /**
     * <p>
     * The name of the load balancer.
     * </p>
     * 
     * @return The name of the load balancer.
     */

    public String getLoadBalancerName() {
        return this.loadBalancerName;
    }

    /**
     * <p>
     * The name of the load balancer.
     * </p>
     * 
     * @param loadBalancerName
     *        The name of the load balancer.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetLoadBalancerMetricDataRequest withLoadBalancerName(String loadBalancerName) {
        setLoadBalancerName(loadBalancerName);
        return this;
    }

    /**
     * <p>
     * The metric for which you want to return information.
     * </p>
     * <p>
     * Valid load balancer metric names are listed below, along with the most useful <code>statistics</code> to include
     * in your request, and the published <code>unit</code> value.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>ClientTLSNegotiationErrorCount</code> </b> - The number of TLS connections initiated by the client that
     * did not establish a session with the load balancer due to a TLS error generated by the load balancer. Possible
     * causes include a mismatch of ciphers or protocols.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HealthyHostCount</code> </b> - The number of target instances that are considered healthy.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
     * <code>Maximum</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_Instance_2XX_Count</code> </b> - The number of HTTP 2XX response codes generated by the target
     * instances. This does not include any response codes generated by the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_Instance_3XX_Count</code> </b> - The number of HTTP 3XX response codes generated by the target
     * instances. This does not include any response codes generated by the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_Instance_4XX_Count</code> </b> - The number of HTTP 4XX response codes generated by the target
     * instances. This does not include any response codes generated by the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_Instance_5XX_Count</code> </b> - The number of HTTP 5XX response codes generated by the target
     * instances. This does not include any response codes generated by the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_LB_4XX_Count</code> </b> - The number of HTTP 4XX client error codes that originated from the
     * load balancer. Client errors are generated when requests are malformed or incomplete. These requests were not
     * received by the target instance. This count does not include response codes generated by the target instances.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_LB_5XX_Count</code> </b> - The number of HTTP 5XX server error codes that originated from the
     * load balancer. This does not include any response codes generated by the target instance. This metric is reported
     * if there are no healthy instances attached to the load balancer, or if the request rate exceeds the capacity of
     * the instances (spillover) or the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>InstanceResponseTime</code> </b> - The time elapsed, in seconds, after the request leaves the load
     * balancer until a response from the target instance is received.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Average</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Seconds</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>RejectedConnectionCount</code> </b> - The number of connections that were rejected because the load
     * balancer had reached its maximum number of connections.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>RequestCount</code> </b> - The number of requests processed over IPv4. This count includes only the
     * requests with a response generated by a target instance of the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>UnhealthyHostCount</code> </b> - The number of target instances that are considered unhealthy.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
     * <code>Maximum</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @param metricName
     *        The metric for which you want to return information.</p>
     *        <p>
     *        Valid load balancer metric names are listed below, along with the most useful <code>statistics</code> to
     *        include in your request, and the published <code>unit</code> value.
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <b> <code>ClientTLSNegotiationErrorCount</code> </b> - The number of TLS connections initiated by the
     *        client that did not establish a session with the load balancer due to a TLS error generated by the load
     *        balancer. Possible causes include a mismatch of ciphers or protocols.
     *        </p>
     *        <p>
     *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
     *        </p>
     *        <p>
     *        <code>Unit</code>: The published unit is <code>Count</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>HealthyHostCount</code> </b> - The number of target instances that are considered healthy.
     *        </p>
     *        <p>
     *        <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
     *        <code>Maximum</code>.
     *        </p>
     *        <p>
     *        <code>Unit</code>: The published unit is <code>Count</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>HTTPCode_Instance_2XX_Count</code> </b> - The number of HTTP 2XX response codes generated by the
     *        target instances. This does not include any response codes generated by the load balancer.
     *        </p>
     *        <p>
     *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *        <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *        </p>
     *        <p>
     *        <code>Unit</code>: The published unit is <code>Count</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>HTTPCode_Instance_3XX_Count</code> </b> - The number of HTTP 3XX response codes generated by the
     *        target instances. This does not include any response codes generated by the load balancer.
     *        </p>
     *        <p>
     *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *        <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *        </p>
     *        <p>
     *        <code>Unit</code>: The published unit is <code>Count</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>HTTPCode_Instance_4XX_Count</code> </b> - The number of HTTP 4XX response codes generated by the
     *        target instances. This does not include any response codes generated by the load balancer.
     *        </p>
     *        <p>
     *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *        <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *        </p>
     *        <p>
     *        <code>Unit</code>: The published unit is <code>Count</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>HTTPCode_Instance_5XX_Count</code> </b> - The number of HTTP 5XX response codes generated by the
     *        target instances. This does not include any response codes generated by the load balancer.
     *        </p>
     *        <p>
     *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *        <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *        </p>
     *        <p>
     *        <code>Unit</code>: The published unit is <code>Count</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>HTTPCode_LB_4XX_Count</code> </b> - The number of HTTP 4XX client error codes that originated
     *        from the load balancer. Client errors are generated when requests are malformed or incomplete. These
     *        requests were not received by the target instance. This count does not include response codes generated by
     *        the target instances.
     *        </p>
     *        <p>
     *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *        <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *        </p>
     *        <p>
     *        <code>Unit</code>: The published unit is <code>Count</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>HTTPCode_LB_5XX_Count</code> </b> - The number of HTTP 5XX server error codes that originated
     *        from the load balancer. This does not include any response codes generated by the target instance. This
     *        metric is reported if there are no healthy instances attached to the load balancer, or if the request rate
     *        exceeds the capacity of the instances (spillover) or the load balancer.
     *        </p>
     *        <p>
     *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *        <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *        </p>
     *        <p>
     *        <code>Unit</code>: The published unit is <code>Count</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>InstanceResponseTime</code> </b> - The time elapsed, in seconds, after the request leaves the
     *        load balancer until a response from the target instance is received.
     *        </p>
     *        <p>
     *        <code>Statistics</code>: The most useful statistic is <code>Average</code>.
     *        </p>
     *        <p>
     *        <code>Unit</code>: The published unit is <code>Seconds</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>RejectedConnectionCount</code> </b> - The number of connections that were rejected because the
     *        load balancer had reached its maximum number of connections.
     *        </p>
     *        <p>
     *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
     *        </p>
     *        <p>
     *        <code>Unit</code>: The published unit is <code>Count</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>RequestCount</code> </b> - The number of requests processed over IPv4. This count includes only
     *        the requests with a response generated by a target instance of the load balancer.
     *        </p>
     *        <p>
     *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *        <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *        </p>
     *        <p>
     *        <code>Unit</code>: The published unit is <code>Count</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>UnhealthyHostCount</code> </b> - The number of target instances that are considered unhealthy.
     *        </p>
     *        <p>
     *        <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
     *        <code>Maximum</code>.
     *        </p>
     *        <p>
     *        <code>Unit</code>: The published unit is <code>Count</code>.
     *        </p>
     *        </li>
     * @see LoadBalancerMetricName
     */

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    /**
     * <p>
     * The metric for which you want to return information.
     * </p>
     * <p>
     * Valid load balancer metric names are listed below, along with the most useful <code>statistics</code> to include
     * in your request, and the published <code>unit</code> value.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>ClientTLSNegotiationErrorCount</code> </b> - The number of TLS connections initiated by the client that
     * did not establish a session with the load balancer due to a TLS error generated by the load balancer. Possible
     * causes include a mismatch of ciphers or protocols.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HealthyHostCount</code> </b> - The number of target instances that are considered healthy.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
     * <code>Maximum</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_Instance_2XX_Count</code> </b> - The number of HTTP 2XX response codes generated by the target
     * instances. This does not include any response codes generated by the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_Instance_3XX_Count</code> </b> - The number of HTTP 3XX response codes generated by the target
     * instances. This does not include any response codes generated by the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_Instance_4XX_Count</code> </b> - The number of HTTP 4XX response codes generated by the target
     * instances. This does not include any response codes generated by the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_Instance_5XX_Count</code> </b> - The number of HTTP 5XX response codes generated by the target
     * instances. This does not include any response codes generated by the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_LB_4XX_Count</code> </b> - The number of HTTP 4XX client error codes that originated from the
     * load balancer. Client errors are generated when requests are malformed or incomplete. These requests were not
     * received by the target instance. This count does not include response codes generated by the target instances.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_LB_5XX_Count</code> </b> - The number of HTTP 5XX server error codes that originated from the
     * load balancer. This does not include any response codes generated by the target instance. This metric is reported
     * if there are no healthy instances attached to the load balancer, or if the request rate exceeds the capacity of
     * the instances (spillover) or the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>InstanceResponseTime</code> </b> - The time elapsed, in seconds, after the request leaves the load
     * balancer until a response from the target instance is received.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Average</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Seconds</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>RejectedConnectionCount</code> </b> - The number of connections that were rejected because the load
     * balancer had reached its maximum number of connections.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>RequestCount</code> </b> - The number of requests processed over IPv4. This count includes only the
     * requests with a response generated by a target instance of the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>UnhealthyHostCount</code> </b> - The number of target instances that are considered unhealthy.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
     * <code>Maximum</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The metric for which you want to return information.</p>
     *         <p>
     *         Valid load balancer metric names are listed below, along with the most useful <code>statistics</code> to
     *         include in your request, and the published <code>unit</code> value.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b> <code>ClientTLSNegotiationErrorCount</code> </b> - The number of TLS connections initiated by the
     *         client that did not establish a session with the load balancer due to a TLS error generated by the load
     *         balancer. Possible causes include a mismatch of ciphers or protocols.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
     *         </p>
     *         <p>
     *         <code>Unit</code>: The published unit is <code>Count</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>HealthyHostCount</code> </b> - The number of target instances that are considered healthy.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
     *         <code>Maximum</code>.
     *         </p>
     *         <p>
     *         <code>Unit</code>: The published unit is <code>Count</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>HTTPCode_Instance_2XX_Count</code> </b> - The number of HTTP 2XX response codes generated by
     *         the target instances. This does not include any response codes generated by the load balancer.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *         <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *         </p>
     *         <p>
     *         <code>Unit</code>: The published unit is <code>Count</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>HTTPCode_Instance_3XX_Count</code> </b> - The number of HTTP 3XX response codes generated by
     *         the target instances. This does not include any response codes generated by the load balancer.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *         <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *         </p>
     *         <p>
     *         <code>Unit</code>: The published unit is <code>Count</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>HTTPCode_Instance_4XX_Count</code> </b> - The number of HTTP 4XX response codes generated by
     *         the target instances. This does not include any response codes generated by the load balancer.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *         <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *         </p>
     *         <p>
     *         <code>Unit</code>: The published unit is <code>Count</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>HTTPCode_Instance_5XX_Count</code> </b> - The number of HTTP 5XX response codes generated by
     *         the target instances. This does not include any response codes generated by the load balancer.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *         <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *         </p>
     *         <p>
     *         <code>Unit</code>: The published unit is <code>Count</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>HTTPCode_LB_4XX_Count</code> </b> - The number of HTTP 4XX client error codes that originated
     *         from the load balancer. Client errors are generated when requests are malformed or incomplete. These
     *         requests were not received by the target instance. This count does not include response codes generated
     *         by the target instances.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *         <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *         </p>
     *         <p>
     *         <code>Unit</code>: The published unit is <code>Count</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>HTTPCode_LB_5XX_Count</code> </b> - The number of HTTP 5XX server error codes that originated
     *         from the load balancer. This does not include any response codes generated by the target instance. This
     *         metric is reported if there are no healthy instances attached to the load balancer, or if the request
     *         rate exceeds the capacity of the instances (spillover) or the load balancer.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *         <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *         </p>
     *         <p>
     *         <code>Unit</code>: The published unit is <code>Count</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>InstanceResponseTime</code> </b> - The time elapsed, in seconds, after the request leaves the
     *         load balancer until a response from the target instance is received.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Average</code>.
     *         </p>
     *         <p>
     *         <code>Unit</code>: The published unit is <code>Seconds</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>RejectedConnectionCount</code> </b> - The number of connections that were rejected because the
     *         load balancer had reached its maximum number of connections.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
     *         </p>
     *         <p>
     *         <code>Unit</code>: The published unit is <code>Count</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>RequestCount</code> </b> - The number of requests processed over IPv4. This count includes only
     *         the requests with a response generated by a target instance of the load balancer.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *         <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *         </p>
     *         <p>
     *         <code>Unit</code>: The published unit is <code>Count</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>UnhealthyHostCount</code> </b> - The number of target instances that are considered unhealthy.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
     *         <code>Maximum</code>.
     *         </p>
     *         <p>
     *         <code>Unit</code>: The published unit is <code>Count</code>.
     *         </p>
     *         </li>
     * @see LoadBalancerMetricName
     */

    public String getMetricName() {
        return this.metricName;
    }

    /**
     * <p>
     * The metric for which you want to return information.
     * </p>
     * <p>
     * Valid load balancer metric names are listed below, along with the most useful <code>statistics</code> to include
     * in your request, and the published <code>unit</code> value.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>ClientTLSNegotiationErrorCount</code> </b> - The number of TLS connections initiated by the client that
     * did not establish a session with the load balancer due to a TLS error generated by the load balancer. Possible
     * causes include a mismatch of ciphers or protocols.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HealthyHostCount</code> </b> - The number of target instances that are considered healthy.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
     * <code>Maximum</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_Instance_2XX_Count</code> </b> - The number of HTTP 2XX response codes generated by the target
     * instances. This does not include any response codes generated by the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_Instance_3XX_Count</code> </b> - The number of HTTP 3XX response codes generated by the target
     * instances. This does not include any response codes generated by the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_Instance_4XX_Count</code> </b> - The number of HTTP 4XX response codes generated by the target
     * instances. This does not include any response codes generated by the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_Instance_5XX_Count</code> </b> - The number of HTTP 5XX response codes generated by the target
     * instances. This does not include any response codes generated by the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_LB_4XX_Count</code> </b> - The number of HTTP 4XX client error codes that originated from the
     * load balancer. Client errors are generated when requests are malformed or incomplete. These requests were not
     * received by the target instance. This count does not include response codes generated by the target instances.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_LB_5XX_Count</code> </b> - The number of HTTP 5XX server error codes that originated from the
     * load balancer. This does not include any response codes generated by the target instance. This metric is reported
     * if there are no healthy instances attached to the load balancer, or if the request rate exceeds the capacity of
     * the instances (spillover) or the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>InstanceResponseTime</code> </b> - The time elapsed, in seconds, after the request leaves the load
     * balancer until a response from the target instance is received.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Average</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Seconds</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>RejectedConnectionCount</code> </b> - The number of connections that were rejected because the load
     * balancer had reached its maximum number of connections.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>RequestCount</code> </b> - The number of requests processed over IPv4. This count includes only the
     * requests with a response generated by a target instance of the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>UnhealthyHostCount</code> </b> - The number of target instances that are considered unhealthy.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
     * <code>Maximum</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @param metricName
     *        The metric for which you want to return information.</p>
     *        <p>
     *        Valid load balancer metric names are listed below, along with the most useful <code>statistics</code> to
     *        include in your request, and the published <code>unit</code> value.
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <b> <code>ClientTLSNegotiationErrorCount</code> </b> - The number of TLS connections initiated by the
     *        client that did not establish a session with the load balancer due to a TLS error generated by the load
     *        balancer. Possible causes include a mismatch of ciphers or protocols.
     *        </p>
     *        <p>
     *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
     *        </p>
     *        <p>
     *        <code>Unit</code>: The published unit is <code>Count</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>HealthyHostCount</code> </b> - The number of target instances that are considered healthy.
     *        </p>
     *        <p>
     *        <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
     *        <code>Maximum</code>.
     *        </p>
     *        <p>
     *        <code>Unit</code>: The published unit is <code>Count</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>HTTPCode_Instance_2XX_Count</code> </b> - The number of HTTP 2XX response codes generated by the
     *        target instances. This does not include any response codes generated by the load balancer.
     *        </p>
     *        <p>
     *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *        <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *        </p>
     *        <p>
     *        <code>Unit</code>: The published unit is <code>Count</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>HTTPCode_Instance_3XX_Count</code> </b> - The number of HTTP 3XX response codes generated by the
     *        target instances. This does not include any response codes generated by the load balancer.
     *        </p>
     *        <p>
     *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *        <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *        </p>
     *        <p>
     *        <code>Unit</code>: The published unit is <code>Count</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>HTTPCode_Instance_4XX_Count</code> </b> - The number of HTTP 4XX response codes generated by the
     *        target instances. This does not include any response codes generated by the load balancer.
     *        </p>
     *        <p>
     *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *        <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *        </p>
     *        <p>
     *        <code>Unit</code>: The published unit is <code>Count</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>HTTPCode_Instance_5XX_Count</code> </b> - The number of HTTP 5XX response codes generated by the
     *        target instances. This does not include any response codes generated by the load balancer.
     *        </p>
     *        <p>
     *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *        <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *        </p>
     *        <p>
     *        <code>Unit</code>: The published unit is <code>Count</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>HTTPCode_LB_4XX_Count</code> </b> - The number of HTTP 4XX client error codes that originated
     *        from the load balancer. Client errors are generated when requests are malformed or incomplete. These
     *        requests were not received by the target instance. This count does not include response codes generated by
     *        the target instances.
     *        </p>
     *        <p>
     *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *        <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *        </p>
     *        <p>
     *        <code>Unit</code>: The published unit is <code>Count</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>HTTPCode_LB_5XX_Count</code> </b> - The number of HTTP 5XX server error codes that originated
     *        from the load balancer. This does not include any response codes generated by the target instance. This
     *        metric is reported if there are no healthy instances attached to the load balancer, or if the request rate
     *        exceeds the capacity of the instances (spillover) or the load balancer.
     *        </p>
     *        <p>
     *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *        <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *        </p>
     *        <p>
     *        <code>Unit</code>: The published unit is <code>Count</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>InstanceResponseTime</code> </b> - The time elapsed, in seconds, after the request leaves the
     *        load balancer until a response from the target instance is received.
     *        </p>
     *        <p>
     *        <code>Statistics</code>: The most useful statistic is <code>Average</code>.
     *        </p>
     *        <p>
     *        <code>Unit</code>: The published unit is <code>Seconds</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>RejectedConnectionCount</code> </b> - The number of connections that were rejected because the
     *        load balancer had reached its maximum number of connections.
     *        </p>
     *        <p>
     *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
     *        </p>
     *        <p>
     *        <code>Unit</code>: The published unit is <code>Count</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>RequestCount</code> </b> - The number of requests processed over IPv4. This count includes only
     *        the requests with a response generated by a target instance of the load balancer.
     *        </p>
     *        <p>
     *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *        <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *        </p>
     *        <p>
     *        <code>Unit</code>: The published unit is <code>Count</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>UnhealthyHostCount</code> </b> - The number of target instances that are considered unhealthy.
     *        </p>
     *        <p>
     *        <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
     *        <code>Maximum</code>.
     *        </p>
     *        <p>
     *        <code>Unit</code>: The published unit is <code>Count</code>.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see LoadBalancerMetricName
     */

    public GetLoadBalancerMetricDataRequest withMetricName(String metricName) {
        setMetricName(metricName);
        return this;
    }

    /**
     * <p>
     * The metric for which you want to return information.
     * </p>
     * <p>
     * Valid load balancer metric names are listed below, along with the most useful <code>statistics</code> to include
     * in your request, and the published <code>unit</code> value.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>ClientTLSNegotiationErrorCount</code> </b> - The number of TLS connections initiated by the client that
     * did not establish a session with the load balancer due to a TLS error generated by the load balancer. Possible
     * causes include a mismatch of ciphers or protocols.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HealthyHostCount</code> </b> - The number of target instances that are considered healthy.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
     * <code>Maximum</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_Instance_2XX_Count</code> </b> - The number of HTTP 2XX response codes generated by the target
     * instances. This does not include any response codes generated by the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_Instance_3XX_Count</code> </b> - The number of HTTP 3XX response codes generated by the target
     * instances. This does not include any response codes generated by the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_Instance_4XX_Count</code> </b> - The number of HTTP 4XX response codes generated by the target
     * instances. This does not include any response codes generated by the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_Instance_5XX_Count</code> </b> - The number of HTTP 5XX response codes generated by the target
     * instances. This does not include any response codes generated by the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_LB_4XX_Count</code> </b> - The number of HTTP 4XX client error codes that originated from the
     * load balancer. Client errors are generated when requests are malformed or incomplete. These requests were not
     * received by the target instance. This count does not include response codes generated by the target instances.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_LB_5XX_Count</code> </b> - The number of HTTP 5XX server error codes that originated from the
     * load balancer. This does not include any response codes generated by the target instance. This metric is reported
     * if there are no healthy instances attached to the load balancer, or if the request rate exceeds the capacity of
     * the instances (spillover) or the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>InstanceResponseTime</code> </b> - The time elapsed, in seconds, after the request leaves the load
     * balancer until a response from the target instance is received.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Average</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Seconds</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>RejectedConnectionCount</code> </b> - The number of connections that were rejected because the load
     * balancer had reached its maximum number of connections.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>RequestCount</code> </b> - The number of requests processed over IPv4. This count includes only the
     * requests with a response generated by a target instance of the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>UnhealthyHostCount</code> </b> - The number of target instances that are considered unhealthy.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
     * <code>Maximum</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @param metricName
     *        The metric for which you want to return information.</p>
     *        <p>
     *        Valid load balancer metric names are listed below, along with the most useful <code>statistics</code> to
     *        include in your request, and the published <code>unit</code> value.
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <b> <code>ClientTLSNegotiationErrorCount</code> </b> - The number of TLS connections initiated by the
     *        client that did not establish a session with the load balancer due to a TLS error generated by the load
     *        balancer. Possible causes include a mismatch of ciphers or protocols.
     *        </p>
     *        <p>
     *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
     *        </p>
     *        <p>
     *        <code>Unit</code>: The published unit is <code>Count</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>HealthyHostCount</code> </b> - The number of target instances that are considered healthy.
     *        </p>
     *        <p>
     *        <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
     *        <code>Maximum</code>.
     *        </p>
     *        <p>
     *        <code>Unit</code>: The published unit is <code>Count</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>HTTPCode_Instance_2XX_Count</code> </b> - The number of HTTP 2XX response codes generated by the
     *        target instances. This does not include any response codes generated by the load balancer.
     *        </p>
     *        <p>
     *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *        <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *        </p>
     *        <p>
     *        <code>Unit</code>: The published unit is <code>Count</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>HTTPCode_Instance_3XX_Count</code> </b> - The number of HTTP 3XX response codes generated by the
     *        target instances. This does not include any response codes generated by the load balancer.
     *        </p>
     *        <p>
     *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *        <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *        </p>
     *        <p>
     *        <code>Unit</code>: The published unit is <code>Count</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>HTTPCode_Instance_4XX_Count</code> </b> - The number of HTTP 4XX response codes generated by the
     *        target instances. This does not include any response codes generated by the load balancer.
     *        </p>
     *        <p>
     *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *        <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *        </p>
     *        <p>
     *        <code>Unit</code>: The published unit is <code>Count</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>HTTPCode_Instance_5XX_Count</code> </b> - The number of HTTP 5XX response codes generated by the
     *        target instances. This does not include any response codes generated by the load balancer.
     *        </p>
     *        <p>
     *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *        <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *        </p>
     *        <p>
     *        <code>Unit</code>: The published unit is <code>Count</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>HTTPCode_LB_4XX_Count</code> </b> - The number of HTTP 4XX client error codes that originated
     *        from the load balancer. Client errors are generated when requests are malformed or incomplete. These
     *        requests were not received by the target instance. This count does not include response codes generated by
     *        the target instances.
     *        </p>
     *        <p>
     *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *        <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *        </p>
     *        <p>
     *        <code>Unit</code>: The published unit is <code>Count</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>HTTPCode_LB_5XX_Count</code> </b> - The number of HTTP 5XX server error codes that originated
     *        from the load balancer. This does not include any response codes generated by the target instance. This
     *        metric is reported if there are no healthy instances attached to the load balancer, or if the request rate
     *        exceeds the capacity of the instances (spillover) or the load balancer.
     *        </p>
     *        <p>
     *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *        <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *        </p>
     *        <p>
     *        <code>Unit</code>: The published unit is <code>Count</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>InstanceResponseTime</code> </b> - The time elapsed, in seconds, after the request leaves the
     *        load balancer until a response from the target instance is received.
     *        </p>
     *        <p>
     *        <code>Statistics</code>: The most useful statistic is <code>Average</code>.
     *        </p>
     *        <p>
     *        <code>Unit</code>: The published unit is <code>Seconds</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>RejectedConnectionCount</code> </b> - The number of connections that were rejected because the
     *        load balancer had reached its maximum number of connections.
     *        </p>
     *        <p>
     *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
     *        </p>
     *        <p>
     *        <code>Unit</code>: The published unit is <code>Count</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>RequestCount</code> </b> - The number of requests processed over IPv4. This count includes only
     *        the requests with a response generated by a target instance of the load balancer.
     *        </p>
     *        <p>
     *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *        <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *        </p>
     *        <p>
     *        <code>Unit</code>: The published unit is <code>Count</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>UnhealthyHostCount</code> </b> - The number of target instances that are considered unhealthy.
     *        </p>
     *        <p>
     *        <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
     *        <code>Maximum</code>.
     *        </p>
     *        <p>
     *        <code>Unit</code>: The published unit is <code>Count</code>.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see LoadBalancerMetricName
     */

    public GetLoadBalancerMetricDataRequest withMetricName(LoadBalancerMetricName metricName) {
        this.metricName = metricName.toString();
        return this;
    }

    /**
     * <p>
     * The granularity, in seconds, of the returned data points.
     * </p>
     * 
     * @param period
     *        The granularity, in seconds, of the returned data points.
     */

    public void setPeriod(Integer period) {
        this.period = period;
    }

    /**
     * <p>
     * The granularity, in seconds, of the returned data points.
     * </p>
     * 
     * @return The granularity, in seconds, of the returned data points.
     */

    public Integer getPeriod() {
        return this.period;
    }

    /**
     * <p>
     * The granularity, in seconds, of the returned data points.
     * </p>
     * 
     * @param period
     *        The granularity, in seconds, of the returned data points.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetLoadBalancerMetricDataRequest withPeriod(Integer period) {
        setPeriod(period);
        return this;
    }

    /**
     * <p>
     * The start time of the period.
     * </p>
     * 
     * @param startTime
     *        The start time of the period.
     */

    public void setStartTime(java.util.Date startTime) {
        this.startTime = startTime;
    }

    /**
     * <p>
     * The start time of the period.
     * </p>
     * 
     * @return The start time of the period.
     */

    public java.util.Date getStartTime() {
        return this.startTime;
    }

    /**
     * <p>
     * The start time of the period.
     * </p>
     * 
     * @param startTime
     *        The start time of the period.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetLoadBalancerMetricDataRequest withStartTime(java.util.Date startTime) {
        setStartTime(startTime);
        return this;
    }

    /**
     * <p>
     * The end time of the period.
     * </p>
     * 
     * @param endTime
     *        The end time of the period.
     */

    public void setEndTime(java.util.Date endTime) {
        this.endTime = endTime;
    }

    /**
     * <p>
     * The end time of the period.
     * </p>
     * 
     * @return The end time of the period.
     */

    public java.util.Date getEndTime() {
        return this.endTime;
    }

    /**
     * <p>
     * The end time of the period.
     * </p>
     * 
     * @param endTime
     *        The end time of the period.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetLoadBalancerMetricDataRequest withEndTime(java.util.Date endTime) {
        setEndTime(endTime);
        return this;
    }

    /**
     * <p>
     * The unit for the metric data request. Valid units depend on the metric data being requested. For the valid units
     * with each available metric, see the <code>metricName</code> parameter.
     * </p>
     * 
     * @param unit
     *        The unit for the metric data request. Valid units depend on the metric data being requested. For the valid
     *        units with each available metric, see the <code>metricName</code> parameter.
     * @see MetricUnit
     */

    public void setUnit(String unit) {
        this.unit = unit;
    }

    /**
     * <p>
     * The unit for the metric data request. Valid units depend on the metric data being requested. For the valid units
     * with each available metric, see the <code>metricName</code> parameter.
     * </p>
     * 
     * @return The unit for the metric data request. Valid units depend on the metric data being requested. For the
     *         valid units with each available metric, see the <code>metricName</code> parameter.
     * @see MetricUnit
     */

    public String getUnit() {
        return this.unit;
    }

    /**
     * <p>
     * The unit for the metric data request. Valid units depend on the metric data being requested. For the valid units
     * with each available metric, see the <code>metricName</code> parameter.
     * </p>
     * 
     * @param unit
     *        The unit for the metric data request. Valid units depend on the metric data being requested. For the valid
     *        units with each available metric, see the <code>metricName</code> parameter.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see MetricUnit
     */

    public GetLoadBalancerMetricDataRequest withUnit(String unit) {
        setUnit(unit);
        return this;
    }

    /**
     * <p>
     * The unit for the metric data request. Valid units depend on the metric data being requested. For the valid units
     * with each available metric, see the <code>metricName</code> parameter.
     * </p>
     * 
     * @param unit
     *        The unit for the metric data request. Valid units depend on the metric data being requested. For the valid
     *        units with each available metric, see the <code>metricName</code> parameter.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see MetricUnit
     */

    public GetLoadBalancerMetricDataRequest withUnit(MetricUnit unit) {
        this.unit = unit.toString();
        return this;
    }

    /**
     * <p>
     * The statistic for the metric.
     * </p>
     * <p>
     * The following statistics are available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Minimum</code> - The lowest value observed during the specified period. Use this value to determine low
     * volumes of activity for your application.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Maximum</code> - The highest value observed during the specified period. Use this value to determine high
     * volumes of activity for your application.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Sum</code> - All values submitted for the matching metric added together. You can use this statistic to
     * determine the total volume of a metric.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Average</code> - The value of Sum / SampleCount during the specified period. By comparing this statistic
     * with the Minimum and Maximum values, you can determine the full scope of a metric and how close the average use
     * is to the Minimum and Maximum values. This comparison helps you to know when to increase or decrease your
     * resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SampleCount</code> - The count, or number, of data points used for the statistical calculation.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The statistic for the metric.</p>
     *         <p>
     *         The following statistics are available:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Minimum</code> - The lowest value observed during the specified period. Use this value to determine
     *         low volumes of activity for your application.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Maximum</code> - The highest value observed during the specified period. Use this value to
     *         determine high volumes of activity for your application.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Sum</code> - All values submitted for the matching metric added together. You can use this
     *         statistic to determine the total volume of a metric.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Average</code> - The value of Sum / SampleCount during the specified period. By comparing this
     *         statistic with the Minimum and Maximum values, you can determine the full scope of a metric and how close
     *         the average use is to the Minimum and Maximum values. This comparison helps you to know when to increase
     *         or decrease your resources.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SampleCount</code> - The count, or number, of data points used for the statistical calculation.
     *         </p>
     *         </li>
     * @see MetricStatistic
     */

    public java.util.List<String> getStatistics() {
        return statistics;
    }

    /**
     * <p>
     * The statistic for the metric.
     * </p>
     * <p>
     * The following statistics are available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Minimum</code> - The lowest value observed during the specified period. Use this value to determine low
     * volumes of activity for your application.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Maximum</code> - The highest value observed during the specified period. Use this value to determine high
     * volumes of activity for your application.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Sum</code> - All values submitted for the matching metric added together. You can use this statistic to
     * determine the total volume of a metric.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Average</code> - The value of Sum / SampleCount during the specified period. By comparing this statistic
     * with the Minimum and Maximum values, you can determine the full scope of a metric and how close the average use
     * is to the Minimum and Maximum values. This comparison helps you to know when to increase or decrease your
     * resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SampleCount</code> - The count, or number, of data points used for the statistical calculation.
     * </p>
     * </li>
     * </ul>
     * 
     * @param statistics
     *        The statistic for the metric.</p>
     *        <p>
     *        The following statistics are available:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>Minimum</code> - The lowest value observed during the specified period. Use this value to determine
     *        low volumes of activity for your application.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>Maximum</code> - The highest value observed during the specified period. Use this value to determine
     *        high volumes of activity for your application.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>Sum</code> - All values submitted for the matching metric added together. You can use this statistic
     *        to determine the total volume of a metric.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>Average</code> - The value of Sum / SampleCount during the specified period. By comparing this
     *        statistic with the Minimum and Maximum values, you can determine the full scope of a metric and how close
     *        the average use is to the Minimum and Maximum values. This comparison helps you to know when to increase
     *        or decrease your resources.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>SampleCount</code> - The count, or number, of data points used for the statistical calculation.
     *        </p>
     *        </li>
     * @see MetricStatistic
     */

    public void setStatistics(java.util.Collection<String> statistics) {
        if (statistics == null) {
            this.statistics = null;
            return;
        }

        this.statistics = new java.util.ArrayList<String>(statistics);
    }

    /**
     * <p>
     * The statistic for the metric.
     * </p>
     * <p>
     * The following statistics are available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Minimum</code> - The lowest value observed during the specified period. Use this value to determine low
     * volumes of activity for your application.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Maximum</code> - The highest value observed during the specified period. Use this value to determine high
     * volumes of activity for your application.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Sum</code> - All values submitted for the matching metric added together. You can use this statistic to
     * determine the total volume of a metric.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Average</code> - The value of Sum / SampleCount during the specified period. By comparing this statistic
     * with the Minimum and Maximum values, you can determine the full scope of a metric and how close the average use
     * is to the Minimum and Maximum values. This comparison helps you to know when to increase or decrease your
     * resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SampleCount</code> - The count, or number, of data points used for the statistical calculation.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setStatistics(java.util.Collection)} or {@link #withStatistics(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param statistics
     *        The statistic for the metric.</p>
     *        <p>
     *        The following statistics are available:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>Minimum</code> - The lowest value observed during the specified period. Use this value to determine
     *        low volumes of activity for your application.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>Maximum</code> - The highest value observed during the specified period. Use this value to determine
     *        high volumes of activity for your application.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>Sum</code> - All values submitted for the matching metric added together. You can use this statistic
     *        to determine the total volume of a metric.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>Average</code> - The value of Sum / SampleCount during the specified period. By comparing this
     *        statistic with the Minimum and Maximum values, you can determine the full scope of a metric and how close
     *        the average use is to the Minimum and Maximum values. This comparison helps you to know when to increase
     *        or decrease your resources.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>SampleCount</code> - The count, or number, of data points used for the statistical calculation.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see MetricStatistic
     */

    public GetLoadBalancerMetricDataRequest withStatistics(String... statistics) {
        if (this.statistics == null) {
            setStatistics(new java.util.ArrayList<String>(statistics.length));
        }
        for (String ele : statistics) {
            this.statistics.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The statistic for the metric.
     * </p>
     * <p>
     * The following statistics are available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Minimum</code> - The lowest value observed during the specified period. Use this value to determine low
     * volumes of activity for your application.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Maximum</code> - The highest value observed during the specified period. Use this value to determine high
     * volumes of activity for your application.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Sum</code> - All values submitted for the matching metric added together. You can use this statistic to
     * determine the total volume of a metric.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Average</code> - The value of Sum / SampleCount during the specified period. By comparing this statistic
     * with the Minimum and Maximum values, you can determine the full scope of a metric and how close the average use
     * is to the Minimum and Maximum values. This comparison helps you to know when to increase or decrease your
     * resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SampleCount</code> - The count, or number, of data points used for the statistical calculation.
     * </p>
     * </li>
     * </ul>
     * 
     * @param statistics
     *        The statistic for the metric.</p>
     *        <p>
     *        The following statistics are available:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>Minimum</code> - The lowest value observed during the specified period. Use this value to determine
     *        low volumes of activity for your application.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>Maximum</code> - The highest value observed during the specified period. Use this value to determine
     *        high volumes of activity for your application.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>Sum</code> - All values submitted for the matching metric added together. You can use this statistic
     *        to determine the total volume of a metric.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>Average</code> - The value of Sum / SampleCount during the specified period. By comparing this
     *        statistic with the Minimum and Maximum values, you can determine the full scope of a metric and how close
     *        the average use is to the Minimum and Maximum values. This comparison helps you to know when to increase
     *        or decrease your resources.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>SampleCount</code> - The count, or number, of data points used for the statistical calculation.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see MetricStatistic
     */

    public GetLoadBalancerMetricDataRequest withStatistics(java.util.Collection<String> statistics) {
        setStatistics(statistics);
        return this;
    }

    /**
     * <p>
     * The statistic for the metric.
     * </p>
     * <p>
     * The following statistics are available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Minimum</code> - The lowest value observed during the specified period. Use this value to determine low
     * volumes of activity for your application.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Maximum</code> - The highest value observed during the specified period. Use this value to determine high
     * volumes of activity for your application.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Sum</code> - All values submitted for the matching metric added together. You can use this statistic to
     * determine the total volume of a metric.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Average</code> - The value of Sum / SampleCount during the specified period. By comparing this statistic
     * with the Minimum and Maximum values, you can determine the full scope of a metric and how close the average use
     * is to the Minimum and Maximum values. This comparison helps you to know when to increase or decrease your
     * resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SampleCount</code> - The count, or number, of data points used for the statistical calculation.
     * </p>
     * </li>
     * </ul>
     * 
     * @param statistics
     *        The statistic for the metric.</p>
     *        <p>
     *        The following statistics are available:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>Minimum</code> - The lowest value observed during the specified period. Use this value to determine
     *        low volumes of activity for your application.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>Maximum</code> - The highest value observed during the specified period. Use this value to determine
     *        high volumes of activity for your application.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>Sum</code> - All values submitted for the matching metric added together. You can use this statistic
     *        to determine the total volume of a metric.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>Average</code> - The value of Sum / SampleCount during the specified period. By comparing this
     *        statistic with the Minimum and Maximum values, you can determine the full scope of a metric and how close
     *        the average use is to the Minimum and Maximum values. This comparison helps you to know when to increase
     *        or decrease your resources.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>SampleCount</code> - The count, or number, of data points used for the statistical calculation.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see MetricStatistic
     */

    public GetLoadBalancerMetricDataRequest withStatistics(MetricStatistic... statistics) {
        java.util.ArrayList<String> statisticsCopy = new java.util.ArrayList<String>(statistics.length);
        for (MetricStatistic value : statistics) {
            statisticsCopy.add(value.toString());
        }
        if (getStatistics() == null) {
            setStatistics(statisticsCopy);
        } else {
            getStatistics().addAll(statisticsCopy);
        }
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getLoadBalancerName() != null)
            sb.append("LoadBalancerName: ").append(getLoadBalancerName()).append(",");
        if (getMetricName() != null)
            sb.append("MetricName: ").append(getMetricName()).append(",");
        if (getPeriod() != null)
            sb.append("Period: ").append(getPeriod()).append(",");
        if (getStartTime() != null)
            sb.append("StartTime: ").append(getStartTime()).append(",");
        if (getEndTime() != null)
            sb.append("EndTime: ").append(getEndTime()).append(",");
        if (getUnit() != null)
            sb.append("Unit: ").append(getUnit()).append(",");
        if (getStatistics() != null)
            sb.append("Statistics: ").append(getStatistics());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GetLoadBalancerMetricDataRequest == false)
            return false;
        GetLoadBalancerMetricDataRequest other = (GetLoadBalancerMetricDataRequest) obj;
        if (other.getLoadBalancerName() == null ^ this.getLoadBalancerName() == null)
            return false;
        if (other.getLoadBalancerName() != null && other.getLoadBalancerName().equals(this.getLoadBalancerName()) == false)
            return false;
        if (other.getMetricName() == null ^ this.getMetricName() == null)
            return false;
        if (other.getMetricName() != null && other.getMetricName().equals(this.getMetricName()) == false)
            return false;
        if (other.getPeriod() == null ^ this.getPeriod() == null)
            return false;
        if (other.getPeriod() != null && other.getPeriod().equals(this.getPeriod()) == false)
            return false;
        if (other.getStartTime() == null ^ this.getStartTime() == null)
            return false;
        if (other.getStartTime() != null && other.getStartTime().equals(this.getStartTime()) == false)
            return false;
        if (other.getEndTime() == null ^ this.getEndTime() == null)
            return false;
        if (other.getEndTime() != null && other.getEndTime().equals(this.getEndTime()) == false)
            return false;
        if (other.getUnit() == null ^ this.getUnit() == null)
            return false;
        if (other.getUnit() != null && other.getUnit().equals(this.getUnit()) == false)
            return false;
        if (other.getStatistics() == null ^ this.getStatistics() == null)
            return false;
        if (other.getStatistics() != null && other.getStatistics().equals(this.getStatistics()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getLoadBalancerName() == null) ? 0 : getLoadBalancerName().hashCode());
        hashCode = prime * hashCode + ((getMetricName() == null) ? 0 : getMetricName().hashCode());
        hashCode = prime * hashCode + ((getPeriod() == null) ? 0 : getPeriod().hashCode());
        hashCode = prime * hashCode + ((getStartTime() == null) ? 0 : getStartTime().hashCode());
        hashCode = prime * hashCode + ((getEndTime() == null) ? 0 : getEndTime().hashCode());
        hashCode = prime * hashCode + ((getUnit() == null) ? 0 : getUnit().hashCode());
        hashCode = prime * hashCode + ((getStatistics() == null) ? 0 : getStatistics().hashCode());
        return hashCode;
    }

    @Override
    public GetLoadBalancerMetricDataRequest clone() {
        return (GetLoadBalancerMetricDataRequest) super.clone();
    }

}
