/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * Amazon Lightsail is the easiest way to get started with Amazon Web Services (AWS) for developers who need to build
 * websites or web applications. It includes everything you need to launch your project quickly - instances (virtual
 * private servers), container services, storage buckets, managed databases, SSD-based block storage, static IP
 * addresses, load balancers, content delivery network (CDN) distributions, DNS management of registered domains, and
 * resource snapshots (backups) - for a low, predictable monthly price.
 * </p>
 * <p>
 * You can manage your Lightsail resources using the Lightsail console, Lightsail API, AWS Command Line Interface (AWS
 * CLI), or SDKs. For more information about Lightsail concepts and tasks, see the <a href=
 * "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/lightsail-how-to-set-up-access-keys-to-use-sdk-api-cli"
 * >Amazon Lightsail Developer Guide</a>.
 * </p>
 * <p>
 * This API Reference provides detailed information about the actions, data types, parameters, and errors of the
 * Lightsail service. For more information about the supported AWS Regions, endpoints, and service quotas of the
 * Lightsail service, see <a href="https://docs.aws.amazon.com/general/latest/gr/lightsail.html">Amazon Lightsail
 * Endpoints and Quotas</a> in the <i>AWS General Reference</i>.
 * </p>
 */
package com.amazonaws.services.lightsail;

