/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.lightsail.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBuckets" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetBucketsResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * An array of objects that describe buckets.
     * </p>
     */
    private java.util.List<Bucket> buckets;
    /**
     * <p>
     * The token to advance to the next page of results from your request.
     * </p>
     * <p>
     * A next page token is not returned if there are no more results to display.
     * </p>
     * <p>
     * To get the next page of results, perform another <code>GetBuckets</code> request and specify the next page token
     * using the <code>pageToken</code> parameter.
     * </p>
     */
    private String nextPageToken;
    /**
     * <p>
     * An object that describes the synchronization status of the Amazon S3 account-level block public access feature
     * for your Lightsail buckets.
     * </p>
     * <p>
     * For more information about this feature and how it affects Lightsail buckets, see <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-block-public-access-for-buckets"
     * >Block public access for buckets in Amazon Lightsail</a>.
     * </p>
     */
    private AccountLevelBpaSync accountLevelBpaSync;

    /**
     * <p>
     * An array of objects that describe buckets.
     * </p>
     * 
     * @return An array of objects that describe buckets.
     */

    public java.util.List<Bucket> getBuckets() {
        return buckets;
    }

    /**
     * <p>
     * An array of objects that describe buckets.
     * </p>
     * 
     * @param buckets
     *        An array of objects that describe buckets.
     */

    public void setBuckets(java.util.Collection<Bucket> buckets) {
        if (buckets == null) {
            this.buckets = null;
            return;
        }

        this.buckets = new java.util.ArrayList<Bucket>(buckets);
    }

    /**
     * <p>
     * An array of objects that describe buckets.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setBuckets(java.util.Collection)} or {@link #withBuckets(java.util.Collection)} if you want to override
     * the existing values.
     * </p>
     * 
     * @param buckets
     *        An array of objects that describe buckets.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetBucketsResult withBuckets(Bucket... buckets) {
        if (this.buckets == null) {
            setBuckets(new java.util.ArrayList<Bucket>(buckets.length));
        }
        for (Bucket ele : buckets) {
            this.buckets.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * An array of objects that describe buckets.
     * </p>
     * 
     * @param buckets
     *        An array of objects that describe buckets.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetBucketsResult withBuckets(java.util.Collection<Bucket> buckets) {
        setBuckets(buckets);
        return this;
    }

    /**
     * <p>
     * The token to advance to the next page of results from your request.
     * </p>
     * <p>
     * A next page token is not returned if there are no more results to display.
     * </p>
     * <p>
     * To get the next page of results, perform another <code>GetBuckets</code> request and specify the next page token
     * using the <code>pageToken</code> parameter.
     * </p>
     * 
     * @param nextPageToken
     *        The token to advance to the next page of results from your request.</p>
     *        <p>
     *        A next page token is not returned if there are no more results to display.
     *        </p>
     *        <p>
     *        To get the next page of results, perform another <code>GetBuckets</code> request and specify the next page
     *        token using the <code>pageToken</code> parameter.
     */

    public void setNextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
    }

    /**
     * <p>
     * The token to advance to the next page of results from your request.
     * </p>
     * <p>
     * A next page token is not returned if there are no more results to display.
     * </p>
     * <p>
     * To get the next page of results, perform another <code>GetBuckets</code> request and specify the next page token
     * using the <code>pageToken</code> parameter.
     * </p>
     * 
     * @return The token to advance to the next page of results from your request.</p>
     *         <p>
     *         A next page token is not returned if there are no more results to display.
     *         </p>
     *         <p>
     *         To get the next page of results, perform another <code>GetBuckets</code> request and specify the next
     *         page token using the <code>pageToken</code> parameter.
     */

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    /**
     * <p>
     * The token to advance to the next page of results from your request.
     * </p>
     * <p>
     * A next page token is not returned if there are no more results to display.
     * </p>
     * <p>
     * To get the next page of results, perform another <code>GetBuckets</code> request and specify the next page token
     * using the <code>pageToken</code> parameter.
     * </p>
     * 
     * @param nextPageToken
     *        The token to advance to the next page of results from your request.</p>
     *        <p>
     *        A next page token is not returned if there are no more results to display.
     *        </p>
     *        <p>
     *        To get the next page of results, perform another <code>GetBuckets</code> request and specify the next page
     *        token using the <code>pageToken</code> parameter.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetBucketsResult withNextPageToken(String nextPageToken) {
        setNextPageToken(nextPageToken);
        return this;
    }

    /**
     * <p>
     * An object that describes the synchronization status of the Amazon S3 account-level block public access feature
     * for your Lightsail buckets.
     * </p>
     * <p>
     * For more information about this feature and how it affects Lightsail buckets, see <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-block-public-access-for-buckets"
     * >Block public access for buckets in Amazon Lightsail</a>.
     * </p>
     * 
     * @param accountLevelBpaSync
     *        An object that describes the synchronization status of the Amazon S3 account-level block public access
     *        feature for your Lightsail buckets.</p>
     *        <p>
     *        For more information about this feature and how it affects Lightsail buckets, see <a href=
     *        "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-block-public-access-for-buckets"
     *        >Block public access for buckets in Amazon Lightsail</a>.
     */

    public void setAccountLevelBpaSync(AccountLevelBpaSync accountLevelBpaSync) {
        this.accountLevelBpaSync = accountLevelBpaSync;
    }

    /**
     * <p>
     * An object that describes the synchronization status of the Amazon S3 account-level block public access feature
     * for your Lightsail buckets.
     * </p>
     * <p>
     * For more information about this feature and how it affects Lightsail buckets, see <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-block-public-access-for-buckets"
     * >Block public access for buckets in Amazon Lightsail</a>.
     * </p>
     * 
     * @return An object that describes the synchronization status of the Amazon S3 account-level block public access
     *         feature for your Lightsail buckets.</p>
     *         <p>
     *         For more information about this feature and how it affects Lightsail buckets, see <a href=
     *         "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-block-public-access-for-buckets"
     *         >Block public access for buckets in Amazon Lightsail</a>.
     */

    public AccountLevelBpaSync getAccountLevelBpaSync() {
        return this.accountLevelBpaSync;
    }

    /**
     * <p>
     * An object that describes the synchronization status of the Amazon S3 account-level block public access feature
     * for your Lightsail buckets.
     * </p>
     * <p>
     * For more information about this feature and how it affects Lightsail buckets, see <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-block-public-access-for-buckets"
     * >Block public access for buckets in Amazon Lightsail</a>.
     * </p>
     * 
     * @param accountLevelBpaSync
     *        An object that describes the synchronization status of the Amazon S3 account-level block public access
     *        feature for your Lightsail buckets.</p>
     *        <p>
     *        For more information about this feature and how it affects Lightsail buckets, see <a href=
     *        "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-block-public-access-for-buckets"
     *        >Block public access for buckets in Amazon Lightsail</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetBucketsResult withAccountLevelBpaSync(AccountLevelBpaSync accountLevelBpaSync) {
        setAccountLevelBpaSync(accountLevelBpaSync);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getBuckets() != null)
            sb.append("Buckets: ").append(getBuckets()).append(",");
        if (getNextPageToken() != null)
            sb.append("NextPageToken: ").append(getNextPageToken()).append(",");
        if (getAccountLevelBpaSync() != null)
            sb.append("AccountLevelBpaSync: ").append(getAccountLevelBpaSync());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GetBucketsResult == false)
            return false;
        GetBucketsResult other = (GetBucketsResult) obj;
        if (other.getBuckets() == null ^ this.getBuckets() == null)
            return false;
        if (other.getBuckets() != null && other.getBuckets().equals(this.getBuckets()) == false)
            return false;
        if (other.getNextPageToken() == null ^ this.getNextPageToken() == null)
            return false;
        if (other.getNextPageToken() != null && other.getNextPageToken().equals(this.getNextPageToken()) == false)
            return false;
        if (other.getAccountLevelBpaSync() == null ^ this.getAccountLevelBpaSync() == null)
            return false;
        if (other.getAccountLevelBpaSync() != null && other.getAccountLevelBpaSync().equals(this.getAccountLevelBpaSync()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getBuckets() == null) ? 0 : getBuckets().hashCode());
        hashCode = prime * hashCode + ((getNextPageToken() == null) ? 0 : getNextPageToken().hashCode());
        hashCode = prime * hashCode + ((getAccountLevelBpaSync() == null) ? 0 : getAccountLevelBpaSync().hashCode());
        return hashCode;
    }

    @Override
    public GetBucketsResult clone() {
        try {
            return (GetBucketsResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
