/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lightsail.model.Disk;
import com.amazonaws.services.lightsail.model.transform.InstanceHardwareMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class InstanceHardware
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer cpuCount;
    private List<Disk> disks;
    private Float ramSizeInGb;

    public void setCpuCount(Integer cpuCount) {
        this.cpuCount = cpuCount;
    }

    public Integer getCpuCount() {
        return this.cpuCount;
    }

    public InstanceHardware withCpuCount(Integer cpuCount) {
        this.setCpuCount(cpuCount);
        return this;
    }

    public List<Disk> getDisks() {
        return this.disks;
    }

    public void setDisks(Collection<Disk> disks) {
        if (disks == null) {
            this.disks = null;
            return;
        }
        this.disks = new ArrayList<Disk>(disks);
    }

    public InstanceHardware withDisks(Disk ... disks) {
        if (this.disks == null) {
            this.setDisks(new ArrayList<Disk>(disks.length));
        }
        for (Disk ele : disks) {
            this.disks.add(ele);
        }
        return this;
    }

    public InstanceHardware withDisks(Collection<Disk> disks) {
        this.setDisks(disks);
        return this;
    }

    public void setRamSizeInGb(Float ramSizeInGb) {
        this.ramSizeInGb = ramSizeInGb;
    }

    public Float getRamSizeInGb() {
        return this.ramSizeInGb;
    }

    public InstanceHardware withRamSizeInGb(Float ramSizeInGb) {
        this.setRamSizeInGb(ramSizeInGb);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCpuCount() != null) {
            sb.append("CpuCount: ").append(this.getCpuCount()).append(",");
        }
        if (this.getDisks() != null) {
            sb.append("Disks: ").append(this.getDisks()).append(",");
        }
        if (this.getRamSizeInGb() != null) {
            sb.append("RamSizeInGb: ").append(this.getRamSizeInGb());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceHardware)) {
            return false;
        }
        InstanceHardware other = (InstanceHardware)obj;
        if (other.getCpuCount() == null ^ this.getCpuCount() == null) {
            return false;
        }
        if (other.getCpuCount() != null && !other.getCpuCount().equals(this.getCpuCount())) {
            return false;
        }
        if (other.getDisks() == null ^ this.getDisks() == null) {
            return false;
        }
        if (other.getDisks() != null && !other.getDisks().equals(this.getDisks())) {
            return false;
        }
        if (other.getRamSizeInGb() == null ^ this.getRamSizeInGb() == null) {
            return false;
        }
        return other.getRamSizeInGb() == null || other.getRamSizeInGb().equals(this.getRamSizeInGb());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCpuCount() == null ? 0 : this.getCpuCount().hashCode());
        hashCode = 31 * hashCode + (this.getDisks() == null ? 0 : this.getDisks().hashCode());
        hashCode = 31 * hashCode + (this.getRamSizeInGb() == null ? 0 : this.getRamSizeInGb().hashCode());
        return hashCode;
    }

    public InstanceHardware clone() {
        try {
            return (InstanceHardware)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceHardwareMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

