/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.lightsail.model.CacheBehavior;
import com.amazonaws.services.lightsail.model.CacheBehaviorPerPath;
import com.amazonaws.services.lightsail.model.CacheSettings;
import com.amazonaws.services.lightsail.model.InputOrigin;
import com.amazonaws.services.lightsail.model.IpAddressType;
import com.amazonaws.services.lightsail.model.Tag;
import com.amazonaws.services.lightsail.model.ViewerMinimumTlsProtocolVersionEnum;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateDistributionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String distributionName;
    private InputOrigin origin;
    private CacheBehavior defaultCacheBehavior;
    private CacheSettings cacheBehaviorSettings;
    private List<CacheBehaviorPerPath> cacheBehaviors;
    private String bundleId;
    private String ipAddressType;
    private List<Tag> tags;
    private String certificateName;
    private String viewerMinimumTlsProtocolVersion;

    public void setDistributionName(String distributionName) {
        this.distributionName = distributionName;
    }

    public String getDistributionName() {
        return this.distributionName;
    }

    public CreateDistributionRequest withDistributionName(String distributionName) {
        this.setDistributionName(distributionName);
        return this;
    }

    public void setOrigin(InputOrigin origin) {
        this.origin = origin;
    }

    public InputOrigin getOrigin() {
        return this.origin;
    }

    public CreateDistributionRequest withOrigin(InputOrigin origin) {
        this.setOrigin(origin);
        return this;
    }

    public void setDefaultCacheBehavior(CacheBehavior defaultCacheBehavior) {
        this.defaultCacheBehavior = defaultCacheBehavior;
    }

    public CacheBehavior getDefaultCacheBehavior() {
        return this.defaultCacheBehavior;
    }

    public CreateDistributionRequest withDefaultCacheBehavior(CacheBehavior defaultCacheBehavior) {
        this.setDefaultCacheBehavior(defaultCacheBehavior);
        return this;
    }

    public void setCacheBehaviorSettings(CacheSettings cacheBehaviorSettings) {
        this.cacheBehaviorSettings = cacheBehaviorSettings;
    }

    public CacheSettings getCacheBehaviorSettings() {
        return this.cacheBehaviorSettings;
    }

    public CreateDistributionRequest withCacheBehaviorSettings(CacheSettings cacheBehaviorSettings) {
        this.setCacheBehaviorSettings(cacheBehaviorSettings);
        return this;
    }

    public List<CacheBehaviorPerPath> getCacheBehaviors() {
        return this.cacheBehaviors;
    }

    public void setCacheBehaviors(Collection<CacheBehaviorPerPath> cacheBehaviors) {
        if (cacheBehaviors == null) {
            this.cacheBehaviors = null;
            return;
        }
        this.cacheBehaviors = new ArrayList<CacheBehaviorPerPath>(cacheBehaviors);
    }

    public CreateDistributionRequest withCacheBehaviors(CacheBehaviorPerPath ... cacheBehaviors) {
        if (this.cacheBehaviors == null) {
            this.setCacheBehaviors(new ArrayList<CacheBehaviorPerPath>(cacheBehaviors.length));
        }
        for (CacheBehaviorPerPath ele : cacheBehaviors) {
            this.cacheBehaviors.add(ele);
        }
        return this;
    }

    public CreateDistributionRequest withCacheBehaviors(Collection<CacheBehaviorPerPath> cacheBehaviors) {
        this.setCacheBehaviors(cacheBehaviors);
        return this;
    }

    public void setBundleId(String bundleId) {
        this.bundleId = bundleId;
    }

    public String getBundleId() {
        return this.bundleId;
    }

    public CreateDistributionRequest withBundleId(String bundleId) {
        this.setBundleId(bundleId);
        return this;
    }

    public void setIpAddressType(String ipAddressType) {
        this.ipAddressType = ipAddressType;
    }

    public String getIpAddressType() {
        return this.ipAddressType;
    }

    public CreateDistributionRequest withIpAddressType(String ipAddressType) {
        this.setIpAddressType(ipAddressType);
        return this;
    }

    public CreateDistributionRequest withIpAddressType(IpAddressType ipAddressType) {
        this.ipAddressType = ipAddressType.toString();
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateDistributionRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateDistributionRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setCertificateName(String certificateName) {
        this.certificateName = certificateName;
    }

    public String getCertificateName() {
        return this.certificateName;
    }

    public CreateDistributionRequest withCertificateName(String certificateName) {
        this.setCertificateName(certificateName);
        return this;
    }

    public void setViewerMinimumTlsProtocolVersion(String viewerMinimumTlsProtocolVersion) {
        this.viewerMinimumTlsProtocolVersion = viewerMinimumTlsProtocolVersion;
    }

    public String getViewerMinimumTlsProtocolVersion() {
        return this.viewerMinimumTlsProtocolVersion;
    }

    public CreateDistributionRequest withViewerMinimumTlsProtocolVersion(String viewerMinimumTlsProtocolVersion) {
        this.setViewerMinimumTlsProtocolVersion(viewerMinimumTlsProtocolVersion);
        return this;
    }

    public CreateDistributionRequest withViewerMinimumTlsProtocolVersion(ViewerMinimumTlsProtocolVersionEnum viewerMinimumTlsProtocolVersion) {
        this.viewerMinimumTlsProtocolVersion = viewerMinimumTlsProtocolVersion.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDistributionName() != null) {
            sb.append("DistributionName: ").append(this.getDistributionName()).append(",");
        }
        if (this.getOrigin() != null) {
            sb.append("Origin: ").append(this.getOrigin()).append(",");
        }
        if (this.getDefaultCacheBehavior() != null) {
            sb.append("DefaultCacheBehavior: ").append(this.getDefaultCacheBehavior()).append(",");
        }
        if (this.getCacheBehaviorSettings() != null) {
            sb.append("CacheBehaviorSettings: ").append(this.getCacheBehaviorSettings()).append(",");
        }
        if (this.getCacheBehaviors() != null) {
            sb.append("CacheBehaviors: ").append(this.getCacheBehaviors()).append(",");
        }
        if (this.getBundleId() != null) {
            sb.append("BundleId: ").append(this.getBundleId()).append(",");
        }
        if (this.getIpAddressType() != null) {
            sb.append("IpAddressType: ").append(this.getIpAddressType()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getCertificateName() != null) {
            sb.append("CertificateName: ").append(this.getCertificateName()).append(",");
        }
        if (this.getViewerMinimumTlsProtocolVersion() != null) {
            sb.append("ViewerMinimumTlsProtocolVersion: ").append(this.getViewerMinimumTlsProtocolVersion());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDistributionRequest)) {
            return false;
        }
        CreateDistributionRequest other = (CreateDistributionRequest)obj;
        if (other.getDistributionName() == null ^ this.getDistributionName() == null) {
            return false;
        }
        if (other.getDistributionName() != null && !other.getDistributionName().equals(this.getDistributionName())) {
            return false;
        }
        if (other.getOrigin() == null ^ this.getOrigin() == null) {
            return false;
        }
        if (other.getOrigin() != null && !other.getOrigin().equals(this.getOrigin())) {
            return false;
        }
        if (other.getDefaultCacheBehavior() == null ^ this.getDefaultCacheBehavior() == null) {
            return false;
        }
        if (other.getDefaultCacheBehavior() != null && !other.getDefaultCacheBehavior().equals(this.getDefaultCacheBehavior())) {
            return false;
        }
        if (other.getCacheBehaviorSettings() == null ^ this.getCacheBehaviorSettings() == null) {
            return false;
        }
        if (other.getCacheBehaviorSettings() != null && !other.getCacheBehaviorSettings().equals(this.getCacheBehaviorSettings())) {
            return false;
        }
        if (other.getCacheBehaviors() == null ^ this.getCacheBehaviors() == null) {
            return false;
        }
        if (other.getCacheBehaviors() != null && !other.getCacheBehaviors().equals(this.getCacheBehaviors())) {
            return false;
        }
        if (other.getBundleId() == null ^ this.getBundleId() == null) {
            return false;
        }
        if (other.getBundleId() != null && !other.getBundleId().equals(this.getBundleId())) {
            return false;
        }
        if (other.getIpAddressType() == null ^ this.getIpAddressType() == null) {
            return false;
        }
        if (other.getIpAddressType() != null && !other.getIpAddressType().equals(this.getIpAddressType())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getCertificateName() == null ^ this.getCertificateName() == null) {
            return false;
        }
        if (other.getCertificateName() != null && !other.getCertificateName().equals(this.getCertificateName())) {
            return false;
        }
        if (other.getViewerMinimumTlsProtocolVersion() == null ^ this.getViewerMinimumTlsProtocolVersion() == null) {
            return false;
        }
        return other.getViewerMinimumTlsProtocolVersion() == null || other.getViewerMinimumTlsProtocolVersion().equals(this.getViewerMinimumTlsProtocolVersion());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDistributionName() == null ? 0 : this.getDistributionName().hashCode());
        hashCode = 31 * hashCode + (this.getOrigin() == null ? 0 : this.getOrigin().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultCacheBehavior() == null ? 0 : this.getDefaultCacheBehavior().hashCode());
        hashCode = 31 * hashCode + (this.getCacheBehaviorSettings() == null ? 0 : this.getCacheBehaviorSettings().hashCode());
        hashCode = 31 * hashCode + (this.getCacheBehaviors() == null ? 0 : this.getCacheBehaviors().hashCode());
        hashCode = 31 * hashCode + (this.getBundleId() == null ? 0 : this.getBundleId().hashCode());
        hashCode = 31 * hashCode + (this.getIpAddressType() == null ? 0 : this.getIpAddressType().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getCertificateName() == null ? 0 : this.getCertificateName().hashCode());
        hashCode = 31 * hashCode + (this.getViewerMinimumTlsProtocolVersion() == null ? 0 : this.getViewerMinimumTlsProtocolVersion().hashCode());
        return hashCode;
    }

    public CreateDistributionRequest clone() {
        return (CreateDistributionRequest)super.clone();
    }
}

