/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.lightsail.model.ResourceBudgetEstimate;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class ResourceBudgetEstimateMarshaller {
    private static final MarshallingInfo<String> RESOURCENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceName").build();
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceType").build();
    private static final MarshallingInfo<List> COSTESTIMATES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("costEstimates").build();
    private static final MarshallingInfo<Date> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endTime").timestampFormat("unixTimestamp").build();
    private static final ResourceBudgetEstimateMarshaller instance = new ResourceBudgetEstimateMarshaller();

    public static ResourceBudgetEstimateMarshaller getInstance() {
        return instance;
    }

    public void marshall(ResourceBudgetEstimate resourceBudgetEstimate, ProtocolMarshaller protocolMarshaller) {
        if (resourceBudgetEstimate == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)resourceBudgetEstimate.getResourceName(), RESOURCENAME_BINDING);
            protocolMarshaller.marshall((Object)resourceBudgetEstimate.getResourceType(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall(resourceBudgetEstimate.getCostEstimates(), COSTESTIMATES_BINDING);
            protocolMarshaller.marshall((Object)resourceBudgetEstimate.getStartTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)resourceBudgetEstimate.getEndTime(), ENDTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

