/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.location.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.location.model.GeofenceGeometry;
import java.util.List;

@SdkInternalApi
public class GeofenceGeometryMarshaller {
    private static final MarshallingInfo<List> POLYGON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Polygon").build();
    private static final GeofenceGeometryMarshaller instance = new GeofenceGeometryMarshaller();

    public static GeofenceGeometryMarshaller getInstance() {
        return instance;
    }

    public void marshall(GeofenceGeometry geofenceGeometry, ProtocolMarshaller protocolMarshaller) {
        if (geofenceGeometry == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(geofenceGeometry.getPolygon(), POLYGON_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

