/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.location.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.location.model.PositionalAccuracy;
import com.amazonaws.services.location.model.transform.DevicePositionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DevicePosition
implements Serializable,
Cloneable,
StructuredPojo {
    private String deviceId;
    private Date sampleTime;
    private Date receivedTime;
    private List<Double> position;
    private PositionalAccuracy accuracy;
    private Map<String, String> positionProperties;

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public DevicePosition withDeviceId(String deviceId) {
        this.setDeviceId(deviceId);
        return this;
    }

    public void setSampleTime(Date sampleTime) {
        this.sampleTime = sampleTime;
    }

    public Date getSampleTime() {
        return this.sampleTime;
    }

    public DevicePosition withSampleTime(Date sampleTime) {
        this.setSampleTime(sampleTime);
        return this;
    }

    public void setReceivedTime(Date receivedTime) {
        this.receivedTime = receivedTime;
    }

    public Date getReceivedTime() {
        return this.receivedTime;
    }

    public DevicePosition withReceivedTime(Date receivedTime) {
        this.setReceivedTime(receivedTime);
        return this;
    }

    public List<Double> getPosition() {
        return this.position;
    }

    public void setPosition(Collection<Double> position) {
        if (position == null) {
            this.position = null;
            return;
        }
        this.position = new ArrayList<Double>(position);
    }

    public DevicePosition withPosition(Double ... position) {
        if (this.position == null) {
            this.setPosition(new ArrayList<Double>(position.length));
        }
        for (Double ele : position) {
            this.position.add(ele);
        }
        return this;
    }

    public DevicePosition withPosition(Collection<Double> position) {
        this.setPosition(position);
        return this;
    }

    public void setAccuracy(PositionalAccuracy accuracy) {
        this.accuracy = accuracy;
    }

    public PositionalAccuracy getAccuracy() {
        return this.accuracy;
    }

    public DevicePosition withAccuracy(PositionalAccuracy accuracy) {
        this.setAccuracy(accuracy);
        return this;
    }

    public Map<String, String> getPositionProperties() {
        return this.positionProperties;
    }

    public void setPositionProperties(Map<String, String> positionProperties) {
        this.positionProperties = positionProperties;
    }

    public DevicePosition withPositionProperties(Map<String, String> positionProperties) {
        this.setPositionProperties(positionProperties);
        return this;
    }

    public DevicePosition addPositionPropertiesEntry(String key, String value) {
        if (null == this.positionProperties) {
            this.positionProperties = new HashMap<String, String>();
        }
        if (this.positionProperties.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.positionProperties.put(key, value);
        return this;
    }

    public DevicePosition clearPositionPropertiesEntries() {
        this.positionProperties = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDeviceId() != null) {
            sb.append("DeviceId: ").append(this.getDeviceId()).append(",");
        }
        if (this.getSampleTime() != null) {
            sb.append("SampleTime: ").append(this.getSampleTime()).append(",");
        }
        if (this.getReceivedTime() != null) {
            sb.append("ReceivedTime: ").append(this.getReceivedTime()).append(",");
        }
        if (this.getPosition() != null) {
            sb.append("Position: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getAccuracy() != null) {
            sb.append("Accuracy: ").append(this.getAccuracy()).append(",");
        }
        if (this.getPositionProperties() != null) {
            sb.append("PositionProperties: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DevicePosition)) {
            return false;
        }
        DevicePosition other = (DevicePosition)obj;
        if (other.getDeviceId() == null ^ this.getDeviceId() == null) {
            return false;
        }
        if (other.getDeviceId() != null && !other.getDeviceId().equals(this.getDeviceId())) {
            return false;
        }
        if (other.getSampleTime() == null ^ this.getSampleTime() == null) {
            return false;
        }
        if (other.getSampleTime() != null && !other.getSampleTime().equals(this.getSampleTime())) {
            return false;
        }
        if (other.getReceivedTime() == null ^ this.getReceivedTime() == null) {
            return false;
        }
        if (other.getReceivedTime() != null && !other.getReceivedTime().equals(this.getReceivedTime())) {
            return false;
        }
        if (other.getPosition() == null ^ this.getPosition() == null) {
            return false;
        }
        if (other.getPosition() != null && !other.getPosition().equals(this.getPosition())) {
            return false;
        }
        if (other.getAccuracy() == null ^ this.getAccuracy() == null) {
            return false;
        }
        if (other.getAccuracy() != null && !other.getAccuracy().equals(this.getAccuracy())) {
            return false;
        }
        if (other.getPositionProperties() == null ^ this.getPositionProperties() == null) {
            return false;
        }
        return other.getPositionProperties() == null || other.getPositionProperties().equals(this.getPositionProperties());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDeviceId() == null ? 0 : this.getDeviceId().hashCode());
        hashCode = 31 * hashCode + (this.getSampleTime() == null ? 0 : this.getSampleTime().hashCode());
        hashCode = 31 * hashCode + (this.getReceivedTime() == null ? 0 : this.getReceivedTime().hashCode());
        hashCode = 31 * hashCode + (this.getPosition() == null ? 0 : this.getPosition().hashCode());
        hashCode = 31 * hashCode + (this.getAccuracy() == null ? 0 : this.getAccuracy().hashCode());
        hashCode = 31 * hashCode + (this.getPositionProperties() == null ? 0 : this.getPositionProperties().hashCode());
        return hashCode;
    }

    public DevicePosition clone() {
        try {
            return (DevicePosition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DevicePositionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

