/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.location.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.location.model.Circle;
import com.amazonaws.services.location.model.transform.GeofenceGeometryMarshaller;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GeofenceGeometry
implements Serializable,
Cloneable,
StructuredPojo {
    private List<List<List<Double>>> polygon;
    private Circle circle;
    private ByteBuffer geobuf;

    public List<List<List<Double>>> getPolygon() {
        return this.polygon;
    }

    public void setPolygon(Collection<List<List<Double>>> polygon) {
        if (polygon == null) {
            this.polygon = null;
            return;
        }
        this.polygon = new ArrayList<List<List<Double>>>(polygon);
    }

    public GeofenceGeometry withPolygon(List<List<Double>> ... polygon) {
        if (this.polygon == null) {
            this.setPolygon(new ArrayList<List<List<Double>>>(polygon.length));
        }
        for (List<List<Double>> ele : polygon) {
            this.polygon.add(ele);
        }
        return this;
    }

    public GeofenceGeometry withPolygon(Collection<List<List<Double>>> polygon) {
        this.setPolygon(polygon);
        return this;
    }

    public void setCircle(Circle circle) {
        this.circle = circle;
    }

    public Circle getCircle() {
        return this.circle;
    }

    public GeofenceGeometry withCircle(Circle circle) {
        this.setCircle(circle);
        return this;
    }

    public void setGeobuf(ByteBuffer geobuf) {
        this.geobuf = geobuf;
    }

    public ByteBuffer getGeobuf() {
        return this.geobuf;
    }

    public GeofenceGeometry withGeobuf(ByteBuffer geobuf) {
        this.setGeobuf(geobuf);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPolygon() != null) {
            sb.append("Polygon: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getCircle() != null) {
            sb.append("Circle: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getGeobuf() != null) {
            sb.append("Geobuf: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeofenceGeometry)) {
            return false;
        }
        GeofenceGeometry other = (GeofenceGeometry)obj;
        if (other.getPolygon() == null ^ this.getPolygon() == null) {
            return false;
        }
        if (other.getPolygon() != null && !other.getPolygon().equals(this.getPolygon())) {
            return false;
        }
        if (other.getCircle() == null ^ this.getCircle() == null) {
            return false;
        }
        if (other.getCircle() != null && !other.getCircle().equals(this.getCircle())) {
            return false;
        }
        if (other.getGeobuf() == null ^ this.getGeobuf() == null) {
            return false;
        }
        return other.getGeobuf() == null || other.getGeobuf().equals(this.getGeobuf());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPolygon() == null ? 0 : this.getPolygon().hashCode());
        hashCode = 31 * hashCode + (this.getCircle() == null ? 0 : this.getCircle().hashCode());
        hashCode = 31 * hashCode + (this.getGeobuf() == null ? 0 : this.getGeobuf().hashCode());
        return hashCode;
    }

    public GeofenceGeometry clone() {
        try {
            return (GeofenceGeometry)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GeofenceGeometryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

