/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FilterLogEventsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String logGroupName;
    private ListWithAutoConstructFlag<String> logStreamNames;
    private Long startTime;
    private Long endTime;
    private String filterPattern;
    private String nextToken;
    private Integer limit;
    private Boolean interleaved;

    public String getLogGroupName() {
        return this.logGroupName;
    }

    public void setLogGroupName(String logGroupName) {
        this.logGroupName = logGroupName;
    }

    public FilterLogEventsRequest withLogGroupName(String logGroupName) {
        this.logGroupName = logGroupName;
        return this;
    }

    public List<String> getLogStreamNames() {
        if (this.logStreamNames == null) {
            this.logStreamNames = new ListWithAutoConstructFlag();
            this.logStreamNames.setAutoConstruct(true);
        }
        return this.logStreamNames;
    }

    public void setLogStreamNames(Collection<String> logStreamNames) {
        if (logStreamNames == null) {
            this.logStreamNames = null;
            return;
        }
        ListWithAutoConstructFlag logStreamNamesCopy = new ListWithAutoConstructFlag(logStreamNames.size());
        logStreamNamesCopy.addAll(logStreamNames);
        this.logStreamNames = logStreamNamesCopy;
    }

    public FilterLogEventsRequest withLogStreamNames(String ... logStreamNames) {
        if (this.getLogStreamNames() == null) {
            this.setLogStreamNames(new ArrayList<String>(logStreamNames.length));
        }
        for (String value : logStreamNames) {
            this.getLogStreamNames().add(value);
        }
        return this;
    }

    public FilterLogEventsRequest withLogStreamNames(Collection<String> logStreamNames) {
        if (logStreamNames == null) {
            this.logStreamNames = null;
        } else {
            ListWithAutoConstructFlag logStreamNamesCopy = new ListWithAutoConstructFlag(logStreamNames.size());
            logStreamNamesCopy.addAll(logStreamNames);
            this.logStreamNames = logStreamNamesCopy;
        }
        return this;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public FilterLogEventsRequest withStartTime(Long startTime) {
        this.startTime = startTime;
        return this;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public FilterLogEventsRequest withEndTime(Long endTime) {
        this.endTime = endTime;
        return this;
    }

    public String getFilterPattern() {
        return this.filterPattern;
    }

    public void setFilterPattern(String filterPattern) {
        this.filterPattern = filterPattern;
    }

    public FilterLogEventsRequest withFilterPattern(String filterPattern) {
        this.filterPattern = filterPattern;
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public FilterLogEventsRequest withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public FilterLogEventsRequest withLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public Boolean isInterleaved() {
        return this.interleaved;
    }

    public void setInterleaved(Boolean interleaved) {
        this.interleaved = interleaved;
    }

    public FilterLogEventsRequest withInterleaved(Boolean interleaved) {
        this.interleaved = interleaved;
        return this;
    }

    public Boolean getInterleaved() {
        return this.interleaved;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLogGroupName() != null) {
            sb.append("LogGroupName: " + this.getLogGroupName() + ",");
        }
        if (this.getLogStreamNames() != null) {
            sb.append("LogStreamNames: " + this.getLogStreamNames() + ",");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: " + this.getStartTime() + ",");
        }
        if (this.getEndTime() != null) {
            sb.append("EndTime: " + this.getEndTime() + ",");
        }
        if (this.getFilterPattern() != null) {
            sb.append("FilterPattern: " + this.getFilterPattern() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken() + ",");
        }
        if (this.getLimit() != null) {
            sb.append("Limit: " + this.getLimit() + ",");
        }
        if (this.isInterleaved() != null) {
            sb.append("Interleaved: " + this.isInterleaved());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLogGroupName() == null ? 0 : this.getLogGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getLogStreamNames() == null ? 0 : this.getLogStreamNames().hashCode());
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getFilterPattern() == null ? 0 : this.getFilterPattern().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getLimit() == null ? 0 : this.getLimit().hashCode());
        hashCode = 31 * hashCode + (this.isInterleaved() == null ? 0 : this.isInterleaved().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterLogEventsRequest)) {
            return false;
        }
        FilterLogEventsRequest other = (FilterLogEventsRequest)obj;
        if (other.getLogGroupName() == null ^ this.getLogGroupName() == null) {
            return false;
        }
        if (other.getLogGroupName() != null && !other.getLogGroupName().equals(this.getLogGroupName())) {
            return false;
        }
        if (other.getLogStreamNames() == null ^ this.getLogStreamNames() == null) {
            return false;
        }
        if (other.getLogStreamNames() != null && !other.getLogStreamNames().equals(this.getLogStreamNames())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        if (other.getEndTime() != null && !other.getEndTime().equals(this.getEndTime())) {
            return false;
        }
        if (other.getFilterPattern() == null ^ this.getFilterPattern() == null) {
            return false;
        }
        if (other.getFilterPattern() != null && !other.getFilterPattern().equals(this.getFilterPattern())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getLimit() == null ^ this.getLimit() == null) {
            return false;
        }
        if (other.getLimit() != null && !other.getLimit().equals(this.getLimit())) {
            return false;
        }
        if (other.isInterleaved() == null ^ this.isInterleaved() == null) {
            return false;
        }
        return other.isInterleaved() == null || other.isInterleaved().equals(this.isInterleaved());
    }

    public FilterLogEventsRequest clone() {
        return (FilterLogEventsRequest)super.clone();
    }
}

