/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.logs.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteAccountPolicy" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DeleteAccountPolicyRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The name of the policy to delete.
     * </p>
     */
    private String policyName;
    /**
     * <p>
     * The type of policy to delete. Currently, the only valid value is <code>DATA_PROTECTION_POLICY</code>.
     * </p>
     */
    private String policyType;

    /**
     * <p>
     * The name of the policy to delete.
     * </p>
     * 
     * @param policyName
     *        The name of the policy to delete.
     */

    public void setPolicyName(String policyName) {
        this.policyName = policyName;
    }

    /**
     * <p>
     * The name of the policy to delete.
     * </p>
     * 
     * @return The name of the policy to delete.
     */

    public String getPolicyName() {
        return this.policyName;
    }

    /**
     * <p>
     * The name of the policy to delete.
     * </p>
     * 
     * @param policyName
     *        The name of the policy to delete.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DeleteAccountPolicyRequest withPolicyName(String policyName) {
        setPolicyName(policyName);
        return this;
    }

    /**
     * <p>
     * The type of policy to delete. Currently, the only valid value is <code>DATA_PROTECTION_POLICY</code>.
     * </p>
     * 
     * @param policyType
     *        The type of policy to delete. Currently, the only valid value is <code>DATA_PROTECTION_POLICY</code>.
     * @see PolicyType
     */

    public void setPolicyType(String policyType) {
        this.policyType = policyType;
    }

    /**
     * <p>
     * The type of policy to delete. Currently, the only valid value is <code>DATA_PROTECTION_POLICY</code>.
     * </p>
     * 
     * @return The type of policy to delete. Currently, the only valid value is <code>DATA_PROTECTION_POLICY</code>.
     * @see PolicyType
     */

    public String getPolicyType() {
        return this.policyType;
    }

    /**
     * <p>
     * The type of policy to delete. Currently, the only valid value is <code>DATA_PROTECTION_POLICY</code>.
     * </p>
     * 
     * @param policyType
     *        The type of policy to delete. Currently, the only valid value is <code>DATA_PROTECTION_POLICY</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see PolicyType
     */

    public DeleteAccountPolicyRequest withPolicyType(String policyType) {
        setPolicyType(policyType);
        return this;
    }

    /**
     * <p>
     * The type of policy to delete. Currently, the only valid value is <code>DATA_PROTECTION_POLICY</code>.
     * </p>
     * 
     * @param policyType
     *        The type of policy to delete. Currently, the only valid value is <code>DATA_PROTECTION_POLICY</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see PolicyType
     */

    public DeleteAccountPolicyRequest withPolicyType(PolicyType policyType) {
        this.policyType = policyType.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getPolicyName() != null)
            sb.append("PolicyName: ").append(getPolicyName()).append(",");
        if (getPolicyType() != null)
            sb.append("PolicyType: ").append(getPolicyType());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DeleteAccountPolicyRequest == false)
            return false;
        DeleteAccountPolicyRequest other = (DeleteAccountPolicyRequest) obj;
        if (other.getPolicyName() == null ^ this.getPolicyName() == null)
            return false;
        if (other.getPolicyName() != null && other.getPolicyName().equals(this.getPolicyName()) == false)
            return false;
        if (other.getPolicyType() == null ^ this.getPolicyType() == null)
            return false;
        if (other.getPolicyType() != null && other.getPolicyType().equals(this.getPolicyType()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getPolicyName() == null) ? 0 : getPolicyName().hashCode());
        hashCode = prime * hashCode + ((getPolicyType() == null) ? 0 : getPolicyType().hashCode());
        return hashCode;
    }

    @Override
    public DeleteAccountPolicyRequest clone() {
        return (DeleteAccountPolicyRequest) super.clone();
    }

}
