/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.logs.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/ListAnomalies" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListAnomaliesRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * Use this to optionally limit the results to only the anomalies found by a certain anomaly detector.
     * </p>
     */
    private String anomalyDetectorArn;
    /**
     * <p>
     * You can specify this parameter if you want to the operation to return only anomalies that are currently either
     * suppressed or unsuppressed.
     * </p>
     */
    private String suppressionState;
    /**
     * <p>
     * The maximum number of items to return. If you don't specify a value, the default maximum value of 50 items is
     * used.
     * </p>
     */
    private Integer limit;

    private String nextToken;

    /**
     * <p>
     * Use this to optionally limit the results to only the anomalies found by a certain anomaly detector.
     * </p>
     * 
     * @param anomalyDetectorArn
     *        Use this to optionally limit the results to only the anomalies found by a certain anomaly detector.
     */

    public void setAnomalyDetectorArn(String anomalyDetectorArn) {
        this.anomalyDetectorArn = anomalyDetectorArn;
    }

    /**
     * <p>
     * Use this to optionally limit the results to only the anomalies found by a certain anomaly detector.
     * </p>
     * 
     * @return Use this to optionally limit the results to only the anomalies found by a certain anomaly detector.
     */

    public String getAnomalyDetectorArn() {
        return this.anomalyDetectorArn;
    }

    /**
     * <p>
     * Use this to optionally limit the results to only the anomalies found by a certain anomaly detector.
     * </p>
     * 
     * @param anomalyDetectorArn
     *        Use this to optionally limit the results to only the anomalies found by a certain anomaly detector.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListAnomaliesRequest withAnomalyDetectorArn(String anomalyDetectorArn) {
        setAnomalyDetectorArn(anomalyDetectorArn);
        return this;
    }

    /**
     * <p>
     * You can specify this parameter if you want to the operation to return only anomalies that are currently either
     * suppressed or unsuppressed.
     * </p>
     * 
     * @param suppressionState
     *        You can specify this parameter if you want to the operation to return only anomalies that are currently
     *        either suppressed or unsuppressed.
     * @see SuppressionState
     */

    public void setSuppressionState(String suppressionState) {
        this.suppressionState = suppressionState;
    }

    /**
     * <p>
     * You can specify this parameter if you want to the operation to return only anomalies that are currently either
     * suppressed or unsuppressed.
     * </p>
     * 
     * @return You can specify this parameter if you want to the operation to return only anomalies that are currently
     *         either suppressed or unsuppressed.
     * @see SuppressionState
     */

    public String getSuppressionState() {
        return this.suppressionState;
    }

    /**
     * <p>
     * You can specify this parameter if you want to the operation to return only anomalies that are currently either
     * suppressed or unsuppressed.
     * </p>
     * 
     * @param suppressionState
     *        You can specify this parameter if you want to the operation to return only anomalies that are currently
     *        either suppressed or unsuppressed.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see SuppressionState
     */

    public ListAnomaliesRequest withSuppressionState(String suppressionState) {
        setSuppressionState(suppressionState);
        return this;
    }

    /**
     * <p>
     * You can specify this parameter if you want to the operation to return only anomalies that are currently either
     * suppressed or unsuppressed.
     * </p>
     * 
     * @param suppressionState
     *        You can specify this parameter if you want to the operation to return only anomalies that are currently
     *        either suppressed or unsuppressed.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see SuppressionState
     */

    public ListAnomaliesRequest withSuppressionState(SuppressionState suppressionState) {
        this.suppressionState = suppressionState.toString();
        return this;
    }

    /**
     * <p>
     * The maximum number of items to return. If you don't specify a value, the default maximum value of 50 items is
     * used.
     * </p>
     * 
     * @param limit
     *        The maximum number of items to return. If you don't specify a value, the default maximum value of 50 items
     *        is used.
     */

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    /**
     * <p>
     * The maximum number of items to return. If you don't specify a value, the default maximum value of 50 items is
     * used.
     * </p>
     * 
     * @return The maximum number of items to return. If you don't specify a value, the default maximum value of 50
     *         items is used.
     */

    public Integer getLimit() {
        return this.limit;
    }

    /**
     * <p>
     * The maximum number of items to return. If you don't specify a value, the default maximum value of 50 items is
     * used.
     * </p>
     * 
     * @param limit
     *        The maximum number of items to return. If you don't specify a value, the default maximum value of 50 items
     *        is used.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListAnomaliesRequest withLimit(Integer limit) {
        setLimit(limit);
        return this;
    }

    /**
     * @param nextToken
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * @return
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * @param nextToken
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListAnomaliesRequest withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAnomalyDetectorArn() != null)
            sb.append("AnomalyDetectorArn: ").append(getAnomalyDetectorArn()).append(",");
        if (getSuppressionState() != null)
            sb.append("SuppressionState: ").append(getSuppressionState()).append(",");
        if (getLimit() != null)
            sb.append("Limit: ").append(getLimit()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListAnomaliesRequest == false)
            return false;
        ListAnomaliesRequest other = (ListAnomaliesRequest) obj;
        if (other.getAnomalyDetectorArn() == null ^ this.getAnomalyDetectorArn() == null)
            return false;
        if (other.getAnomalyDetectorArn() != null && other.getAnomalyDetectorArn().equals(this.getAnomalyDetectorArn()) == false)
            return false;
        if (other.getSuppressionState() == null ^ this.getSuppressionState() == null)
            return false;
        if (other.getSuppressionState() != null && other.getSuppressionState().equals(this.getSuppressionState()) == false)
            return false;
        if (other.getLimit() == null ^ this.getLimit() == null)
            return false;
        if (other.getLimit() != null && other.getLimit().equals(this.getLimit()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAnomalyDetectorArn() == null) ? 0 : getAnomalyDetectorArn().hashCode());
        hashCode = prime * hashCode + ((getSuppressionState() == null) ? 0 : getSuppressionState().hashCode());
        hashCode = prime * hashCode + ((getLimit() == null) ? 0 : getLimit().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public ListAnomaliesRequest clone() {
        return (ListAnomaliesRequest) super.clone();
    }

}
