/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lookoutequipment.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lookoutequipment.model.ModelSummary;
import java.util.Date;

@SdkInternalApi
public class ModelSummaryMarshaller {
    private static final MarshallingInfo<String> MODELNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModelName").build();
    private static final MarshallingInfo<String> MODELARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModelArn").build();
    private static final MarshallingInfo<String> DATASETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatasetName").build();
    private static final MarshallingInfo<String> DATASETARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatasetArn").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<Date> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Long> ACTIVEMODELVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ActiveModelVersion").build();
    private static final MarshallingInfo<String> ACTIVEMODELVERSIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ActiveModelVersionArn").build();
    private static final MarshallingInfo<String> LATESTSCHEDULEDRETRAININGSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LatestScheduledRetrainingStatus").build();
    private static final MarshallingInfo<Long> LATESTSCHEDULEDRETRAININGMODELVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LatestScheduledRetrainingModelVersion").build();
    private static final MarshallingInfo<Date> LATESTSCHEDULEDRETRAININGSTARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LatestScheduledRetrainingStartTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> NEXTSCHEDULEDRETRAININGSTARTDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextScheduledRetrainingStartDate").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> RETRAININGSCHEDULERSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RetrainingSchedulerStatus").build();
    private static final MarshallingInfo<StructuredPojo> MODELDIAGNOSTICSOUTPUTCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModelDiagnosticsOutputConfiguration").build();
    private static final MarshallingInfo<String> MODELQUALITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModelQuality").build();
    private static final ModelSummaryMarshaller instance = new ModelSummaryMarshaller();

    public static ModelSummaryMarshaller getInstance() {
        return instance;
    }

    public void marshall(ModelSummary modelSummary, ProtocolMarshaller protocolMarshaller) {
        if (modelSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)modelSummary.getModelName(), MODELNAME_BINDING);
            protocolMarshaller.marshall((Object)modelSummary.getModelArn(), MODELARN_BINDING);
            protocolMarshaller.marshall((Object)modelSummary.getDatasetName(), DATASETNAME_BINDING);
            protocolMarshaller.marshall((Object)modelSummary.getDatasetArn(), DATASETARN_BINDING);
            protocolMarshaller.marshall((Object)modelSummary.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)modelSummary.getCreatedAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)modelSummary.getActiveModelVersion(), ACTIVEMODELVERSION_BINDING);
            protocolMarshaller.marshall((Object)modelSummary.getActiveModelVersionArn(), ACTIVEMODELVERSIONARN_BINDING);
            protocolMarshaller.marshall((Object)modelSummary.getLatestScheduledRetrainingStatus(), LATESTSCHEDULEDRETRAININGSTATUS_BINDING);
            protocolMarshaller.marshall((Object)modelSummary.getLatestScheduledRetrainingModelVersion(), LATESTSCHEDULEDRETRAININGMODELVERSION_BINDING);
            protocolMarshaller.marshall((Object)modelSummary.getLatestScheduledRetrainingStartTime(), LATESTSCHEDULEDRETRAININGSTARTTIME_BINDING);
            protocolMarshaller.marshall((Object)modelSummary.getNextScheduledRetrainingStartDate(), NEXTSCHEDULEDRETRAININGSTARTDATE_BINDING);
            protocolMarshaller.marshall((Object)modelSummary.getRetrainingSchedulerStatus(), RETRAININGSCHEDULERSTATUS_BINDING);
            protocolMarshaller.marshall((Object)modelSummary.getModelDiagnosticsOutputConfiguration(), MODELDIAGNOSTICSOUTPUTCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)modelSummary.getModelQuality(), MODELQUALITY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

