/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.macie2;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.macie2.AmazonMacie2Async;
import com.amazonaws.services.macie2.AmazonMacie2AsyncClientBuilder;
import com.amazonaws.services.macie2.AmazonMacie2Client;
import com.amazonaws.services.macie2.model.AcceptInvitationRequest;
import com.amazonaws.services.macie2.model.AcceptInvitationResult;
import com.amazonaws.services.macie2.model.BatchGetCustomDataIdentifiersRequest;
import com.amazonaws.services.macie2.model.BatchGetCustomDataIdentifiersResult;
import com.amazonaws.services.macie2.model.CreateClassificationJobRequest;
import com.amazonaws.services.macie2.model.CreateClassificationJobResult;
import com.amazonaws.services.macie2.model.CreateCustomDataIdentifierRequest;
import com.amazonaws.services.macie2.model.CreateCustomDataIdentifierResult;
import com.amazonaws.services.macie2.model.CreateFindingsFilterRequest;
import com.amazonaws.services.macie2.model.CreateFindingsFilterResult;
import com.amazonaws.services.macie2.model.CreateInvitationsRequest;
import com.amazonaws.services.macie2.model.CreateInvitationsResult;
import com.amazonaws.services.macie2.model.CreateMemberRequest;
import com.amazonaws.services.macie2.model.CreateMemberResult;
import com.amazonaws.services.macie2.model.CreateSampleFindingsRequest;
import com.amazonaws.services.macie2.model.CreateSampleFindingsResult;
import com.amazonaws.services.macie2.model.DeclineInvitationsRequest;
import com.amazonaws.services.macie2.model.DeclineInvitationsResult;
import com.amazonaws.services.macie2.model.DeleteCustomDataIdentifierRequest;
import com.amazonaws.services.macie2.model.DeleteCustomDataIdentifierResult;
import com.amazonaws.services.macie2.model.DeleteFindingsFilterRequest;
import com.amazonaws.services.macie2.model.DeleteFindingsFilterResult;
import com.amazonaws.services.macie2.model.DeleteInvitationsRequest;
import com.amazonaws.services.macie2.model.DeleteInvitationsResult;
import com.amazonaws.services.macie2.model.DeleteMemberRequest;
import com.amazonaws.services.macie2.model.DeleteMemberResult;
import com.amazonaws.services.macie2.model.DescribeBucketsRequest;
import com.amazonaws.services.macie2.model.DescribeBucketsResult;
import com.amazonaws.services.macie2.model.DescribeClassificationJobRequest;
import com.amazonaws.services.macie2.model.DescribeClassificationJobResult;
import com.amazonaws.services.macie2.model.DescribeOrganizationConfigurationRequest;
import com.amazonaws.services.macie2.model.DescribeOrganizationConfigurationResult;
import com.amazonaws.services.macie2.model.DisableMacieRequest;
import com.amazonaws.services.macie2.model.DisableMacieResult;
import com.amazonaws.services.macie2.model.DisableOrganizationAdminAccountRequest;
import com.amazonaws.services.macie2.model.DisableOrganizationAdminAccountResult;
import com.amazonaws.services.macie2.model.DisassociateFromAdministratorAccountRequest;
import com.amazonaws.services.macie2.model.DisassociateFromAdministratorAccountResult;
import com.amazonaws.services.macie2.model.DisassociateFromMasterAccountRequest;
import com.amazonaws.services.macie2.model.DisassociateFromMasterAccountResult;
import com.amazonaws.services.macie2.model.DisassociateMemberRequest;
import com.amazonaws.services.macie2.model.DisassociateMemberResult;
import com.amazonaws.services.macie2.model.EnableMacieRequest;
import com.amazonaws.services.macie2.model.EnableMacieResult;
import com.amazonaws.services.macie2.model.EnableOrganizationAdminAccountRequest;
import com.amazonaws.services.macie2.model.EnableOrganizationAdminAccountResult;
import com.amazonaws.services.macie2.model.GetAdministratorAccountRequest;
import com.amazonaws.services.macie2.model.GetAdministratorAccountResult;
import com.amazonaws.services.macie2.model.GetBucketStatisticsRequest;
import com.amazonaws.services.macie2.model.GetBucketStatisticsResult;
import com.amazonaws.services.macie2.model.GetClassificationExportConfigurationRequest;
import com.amazonaws.services.macie2.model.GetClassificationExportConfigurationResult;
import com.amazonaws.services.macie2.model.GetCustomDataIdentifierRequest;
import com.amazonaws.services.macie2.model.GetCustomDataIdentifierResult;
import com.amazonaws.services.macie2.model.GetFindingStatisticsRequest;
import com.amazonaws.services.macie2.model.GetFindingStatisticsResult;
import com.amazonaws.services.macie2.model.GetFindingsFilterRequest;
import com.amazonaws.services.macie2.model.GetFindingsFilterResult;
import com.amazonaws.services.macie2.model.GetFindingsRequest;
import com.amazonaws.services.macie2.model.GetFindingsResult;
import com.amazonaws.services.macie2.model.GetInvitationsCountRequest;
import com.amazonaws.services.macie2.model.GetInvitationsCountResult;
import com.amazonaws.services.macie2.model.GetMacieSessionRequest;
import com.amazonaws.services.macie2.model.GetMacieSessionResult;
import com.amazonaws.services.macie2.model.GetMasterAccountRequest;
import com.amazonaws.services.macie2.model.GetMasterAccountResult;
import com.amazonaws.services.macie2.model.GetMemberRequest;
import com.amazonaws.services.macie2.model.GetMemberResult;
import com.amazonaws.services.macie2.model.GetUsageStatisticsRequest;
import com.amazonaws.services.macie2.model.GetUsageStatisticsResult;
import com.amazonaws.services.macie2.model.GetUsageTotalsRequest;
import com.amazonaws.services.macie2.model.GetUsageTotalsResult;
import com.amazonaws.services.macie2.model.ListClassificationJobsRequest;
import com.amazonaws.services.macie2.model.ListClassificationJobsResult;
import com.amazonaws.services.macie2.model.ListCustomDataIdentifiersRequest;
import com.amazonaws.services.macie2.model.ListCustomDataIdentifiersResult;
import com.amazonaws.services.macie2.model.ListFindingsFiltersRequest;
import com.amazonaws.services.macie2.model.ListFindingsFiltersResult;
import com.amazonaws.services.macie2.model.ListFindingsRequest;
import com.amazonaws.services.macie2.model.ListFindingsResult;
import com.amazonaws.services.macie2.model.ListInvitationsRequest;
import com.amazonaws.services.macie2.model.ListInvitationsResult;
import com.amazonaws.services.macie2.model.ListMembersRequest;
import com.amazonaws.services.macie2.model.ListMembersResult;
import com.amazonaws.services.macie2.model.ListOrganizationAdminAccountsRequest;
import com.amazonaws.services.macie2.model.ListOrganizationAdminAccountsResult;
import com.amazonaws.services.macie2.model.ListTagsForResourceRequest;
import com.amazonaws.services.macie2.model.ListTagsForResourceResult;
import com.amazonaws.services.macie2.model.PutClassificationExportConfigurationRequest;
import com.amazonaws.services.macie2.model.PutClassificationExportConfigurationResult;
import com.amazonaws.services.macie2.model.TagResourceRequest;
import com.amazonaws.services.macie2.model.TagResourceResult;
import com.amazonaws.services.macie2.model.TestCustomDataIdentifierRequest;
import com.amazonaws.services.macie2.model.TestCustomDataIdentifierResult;
import com.amazonaws.services.macie2.model.UntagResourceRequest;
import com.amazonaws.services.macie2.model.UntagResourceResult;
import com.amazonaws.services.macie2.model.UpdateClassificationJobRequest;
import com.amazonaws.services.macie2.model.UpdateClassificationJobResult;
import com.amazonaws.services.macie2.model.UpdateFindingsFilterRequest;
import com.amazonaws.services.macie2.model.UpdateFindingsFilterResult;
import com.amazonaws.services.macie2.model.UpdateMacieSessionRequest;
import com.amazonaws.services.macie2.model.UpdateMacieSessionResult;
import com.amazonaws.services.macie2.model.UpdateMemberSessionRequest;
import com.amazonaws.services.macie2.model.UpdateMemberSessionResult;
import com.amazonaws.services.macie2.model.UpdateOrganizationConfigurationRequest;
import com.amazonaws.services.macie2.model.UpdateOrganizationConfigurationResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonMacie2AsyncClient
extends AmazonMacie2Client
implements AmazonMacie2Async {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonMacie2AsyncClientBuilder asyncBuilder() {
        return AmazonMacie2AsyncClientBuilder.standard();
    }

    AmazonMacie2AsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonMacie2AsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AcceptInvitationResult> acceptInvitationAsync(AcceptInvitationRequest request) {
        return this.acceptInvitationAsync(request, null);
    }

    @Override
    public Future<AcceptInvitationResult> acceptInvitationAsync(AcceptInvitationRequest request, final AsyncHandler<AcceptInvitationRequest, AcceptInvitationResult> asyncHandler) {
        final AcceptInvitationRequest finalRequest = (AcceptInvitationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AcceptInvitationResult>(){

            @Override
            public AcceptInvitationResult call() throws Exception {
                AcceptInvitationResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeAcceptInvitation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchGetCustomDataIdentifiersResult> batchGetCustomDataIdentifiersAsync(BatchGetCustomDataIdentifiersRequest request) {
        return this.batchGetCustomDataIdentifiersAsync(request, null);
    }

    @Override
    public Future<BatchGetCustomDataIdentifiersResult> batchGetCustomDataIdentifiersAsync(BatchGetCustomDataIdentifiersRequest request, final AsyncHandler<BatchGetCustomDataIdentifiersRequest, BatchGetCustomDataIdentifiersResult> asyncHandler) {
        final BatchGetCustomDataIdentifiersRequest finalRequest = (BatchGetCustomDataIdentifiersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchGetCustomDataIdentifiersResult>(){

            @Override
            public BatchGetCustomDataIdentifiersResult call() throws Exception {
                BatchGetCustomDataIdentifiersResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeBatchGetCustomDataIdentifiers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateClassificationJobResult> createClassificationJobAsync(CreateClassificationJobRequest request) {
        return this.createClassificationJobAsync(request, null);
    }

    @Override
    public Future<CreateClassificationJobResult> createClassificationJobAsync(CreateClassificationJobRequest request, final AsyncHandler<CreateClassificationJobRequest, CreateClassificationJobResult> asyncHandler) {
        final CreateClassificationJobRequest finalRequest = (CreateClassificationJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateClassificationJobResult>(){

            @Override
            public CreateClassificationJobResult call() throws Exception {
                CreateClassificationJobResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeCreateClassificationJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateCustomDataIdentifierResult> createCustomDataIdentifierAsync(CreateCustomDataIdentifierRequest request) {
        return this.createCustomDataIdentifierAsync(request, null);
    }

    @Override
    public Future<CreateCustomDataIdentifierResult> createCustomDataIdentifierAsync(CreateCustomDataIdentifierRequest request, final AsyncHandler<CreateCustomDataIdentifierRequest, CreateCustomDataIdentifierResult> asyncHandler) {
        final CreateCustomDataIdentifierRequest finalRequest = (CreateCustomDataIdentifierRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateCustomDataIdentifierResult>(){

            @Override
            public CreateCustomDataIdentifierResult call() throws Exception {
                CreateCustomDataIdentifierResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeCreateCustomDataIdentifier(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateFindingsFilterResult> createFindingsFilterAsync(CreateFindingsFilterRequest request) {
        return this.createFindingsFilterAsync(request, null);
    }

    @Override
    public Future<CreateFindingsFilterResult> createFindingsFilterAsync(CreateFindingsFilterRequest request, final AsyncHandler<CreateFindingsFilterRequest, CreateFindingsFilterResult> asyncHandler) {
        final CreateFindingsFilterRequest finalRequest = (CreateFindingsFilterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateFindingsFilterResult>(){

            @Override
            public CreateFindingsFilterResult call() throws Exception {
                CreateFindingsFilterResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeCreateFindingsFilter(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateInvitationsResult> createInvitationsAsync(CreateInvitationsRequest request) {
        return this.createInvitationsAsync(request, null);
    }

    @Override
    public Future<CreateInvitationsResult> createInvitationsAsync(CreateInvitationsRequest request, final AsyncHandler<CreateInvitationsRequest, CreateInvitationsResult> asyncHandler) {
        final CreateInvitationsRequest finalRequest = (CreateInvitationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateInvitationsResult>(){

            @Override
            public CreateInvitationsResult call() throws Exception {
                CreateInvitationsResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeCreateInvitations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateMemberResult> createMemberAsync(CreateMemberRequest request) {
        return this.createMemberAsync(request, null);
    }

    @Override
    public Future<CreateMemberResult> createMemberAsync(CreateMemberRequest request, final AsyncHandler<CreateMemberRequest, CreateMemberResult> asyncHandler) {
        final CreateMemberRequest finalRequest = (CreateMemberRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateMemberResult>(){

            @Override
            public CreateMemberResult call() throws Exception {
                CreateMemberResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeCreateMember(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateSampleFindingsResult> createSampleFindingsAsync(CreateSampleFindingsRequest request) {
        return this.createSampleFindingsAsync(request, null);
    }

    @Override
    public Future<CreateSampleFindingsResult> createSampleFindingsAsync(CreateSampleFindingsRequest request, final AsyncHandler<CreateSampleFindingsRequest, CreateSampleFindingsResult> asyncHandler) {
        final CreateSampleFindingsRequest finalRequest = (CreateSampleFindingsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateSampleFindingsResult>(){

            @Override
            public CreateSampleFindingsResult call() throws Exception {
                CreateSampleFindingsResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeCreateSampleFindings(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeclineInvitationsResult> declineInvitationsAsync(DeclineInvitationsRequest request) {
        return this.declineInvitationsAsync(request, null);
    }

    @Override
    public Future<DeclineInvitationsResult> declineInvitationsAsync(DeclineInvitationsRequest request, final AsyncHandler<DeclineInvitationsRequest, DeclineInvitationsResult> asyncHandler) {
        final DeclineInvitationsRequest finalRequest = (DeclineInvitationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeclineInvitationsResult>(){

            @Override
            public DeclineInvitationsResult call() throws Exception {
                DeclineInvitationsResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeDeclineInvitations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteCustomDataIdentifierResult> deleteCustomDataIdentifierAsync(DeleteCustomDataIdentifierRequest request) {
        return this.deleteCustomDataIdentifierAsync(request, null);
    }

    @Override
    public Future<DeleteCustomDataIdentifierResult> deleteCustomDataIdentifierAsync(DeleteCustomDataIdentifierRequest request, final AsyncHandler<DeleteCustomDataIdentifierRequest, DeleteCustomDataIdentifierResult> asyncHandler) {
        final DeleteCustomDataIdentifierRequest finalRequest = (DeleteCustomDataIdentifierRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteCustomDataIdentifierResult>(){

            @Override
            public DeleteCustomDataIdentifierResult call() throws Exception {
                DeleteCustomDataIdentifierResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeDeleteCustomDataIdentifier(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteFindingsFilterResult> deleteFindingsFilterAsync(DeleteFindingsFilterRequest request) {
        return this.deleteFindingsFilterAsync(request, null);
    }

    @Override
    public Future<DeleteFindingsFilterResult> deleteFindingsFilterAsync(DeleteFindingsFilterRequest request, final AsyncHandler<DeleteFindingsFilterRequest, DeleteFindingsFilterResult> asyncHandler) {
        final DeleteFindingsFilterRequest finalRequest = (DeleteFindingsFilterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteFindingsFilterResult>(){

            @Override
            public DeleteFindingsFilterResult call() throws Exception {
                DeleteFindingsFilterResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeDeleteFindingsFilter(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteInvitationsResult> deleteInvitationsAsync(DeleteInvitationsRequest request) {
        return this.deleteInvitationsAsync(request, null);
    }

    @Override
    public Future<DeleteInvitationsResult> deleteInvitationsAsync(DeleteInvitationsRequest request, final AsyncHandler<DeleteInvitationsRequest, DeleteInvitationsResult> asyncHandler) {
        final DeleteInvitationsRequest finalRequest = (DeleteInvitationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteInvitationsResult>(){

            @Override
            public DeleteInvitationsResult call() throws Exception {
                DeleteInvitationsResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeDeleteInvitations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteMemberResult> deleteMemberAsync(DeleteMemberRequest request) {
        return this.deleteMemberAsync(request, null);
    }

    @Override
    public Future<DeleteMemberResult> deleteMemberAsync(DeleteMemberRequest request, final AsyncHandler<DeleteMemberRequest, DeleteMemberResult> asyncHandler) {
        final DeleteMemberRequest finalRequest = (DeleteMemberRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteMemberResult>(){

            @Override
            public DeleteMemberResult call() throws Exception {
                DeleteMemberResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeDeleteMember(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeBucketsResult> describeBucketsAsync(DescribeBucketsRequest request) {
        return this.describeBucketsAsync(request, null);
    }

    @Override
    public Future<DescribeBucketsResult> describeBucketsAsync(DescribeBucketsRequest request, final AsyncHandler<DescribeBucketsRequest, DescribeBucketsResult> asyncHandler) {
        final DescribeBucketsRequest finalRequest = (DescribeBucketsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeBucketsResult>(){

            @Override
            public DescribeBucketsResult call() throws Exception {
                DescribeBucketsResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeDescribeBuckets(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeClassificationJobResult> describeClassificationJobAsync(DescribeClassificationJobRequest request) {
        return this.describeClassificationJobAsync(request, null);
    }

    @Override
    public Future<DescribeClassificationJobResult> describeClassificationJobAsync(DescribeClassificationJobRequest request, final AsyncHandler<DescribeClassificationJobRequest, DescribeClassificationJobResult> asyncHandler) {
        final DescribeClassificationJobRequest finalRequest = (DescribeClassificationJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeClassificationJobResult>(){

            @Override
            public DescribeClassificationJobResult call() throws Exception {
                DescribeClassificationJobResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeDescribeClassificationJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeOrganizationConfigurationResult> describeOrganizationConfigurationAsync(DescribeOrganizationConfigurationRequest request) {
        return this.describeOrganizationConfigurationAsync(request, null);
    }

    @Override
    public Future<DescribeOrganizationConfigurationResult> describeOrganizationConfigurationAsync(DescribeOrganizationConfigurationRequest request, final AsyncHandler<DescribeOrganizationConfigurationRequest, DescribeOrganizationConfigurationResult> asyncHandler) {
        final DescribeOrganizationConfigurationRequest finalRequest = (DescribeOrganizationConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeOrganizationConfigurationResult>(){

            @Override
            public DescribeOrganizationConfigurationResult call() throws Exception {
                DescribeOrganizationConfigurationResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeDescribeOrganizationConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisableMacieResult> disableMacieAsync(DisableMacieRequest request) {
        return this.disableMacieAsync(request, null);
    }

    @Override
    public Future<DisableMacieResult> disableMacieAsync(DisableMacieRequest request, final AsyncHandler<DisableMacieRequest, DisableMacieResult> asyncHandler) {
        final DisableMacieRequest finalRequest = (DisableMacieRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisableMacieResult>(){

            @Override
            public DisableMacieResult call() throws Exception {
                DisableMacieResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeDisableMacie(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisableOrganizationAdminAccountResult> disableOrganizationAdminAccountAsync(DisableOrganizationAdminAccountRequest request) {
        return this.disableOrganizationAdminAccountAsync(request, null);
    }

    @Override
    public Future<DisableOrganizationAdminAccountResult> disableOrganizationAdminAccountAsync(DisableOrganizationAdminAccountRequest request, final AsyncHandler<DisableOrganizationAdminAccountRequest, DisableOrganizationAdminAccountResult> asyncHandler) {
        final DisableOrganizationAdminAccountRequest finalRequest = (DisableOrganizationAdminAccountRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisableOrganizationAdminAccountResult>(){

            @Override
            public DisableOrganizationAdminAccountResult call() throws Exception {
                DisableOrganizationAdminAccountResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeDisableOrganizationAdminAccount(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateFromAdministratorAccountResult> disassociateFromAdministratorAccountAsync(DisassociateFromAdministratorAccountRequest request) {
        return this.disassociateFromAdministratorAccountAsync(request, null);
    }

    @Override
    public Future<DisassociateFromAdministratorAccountResult> disassociateFromAdministratorAccountAsync(DisassociateFromAdministratorAccountRequest request, final AsyncHandler<DisassociateFromAdministratorAccountRequest, DisassociateFromAdministratorAccountResult> asyncHandler) {
        final DisassociateFromAdministratorAccountRequest finalRequest = (DisassociateFromAdministratorAccountRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisassociateFromAdministratorAccountResult>(){

            @Override
            public DisassociateFromAdministratorAccountResult call() throws Exception {
                DisassociateFromAdministratorAccountResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeDisassociateFromAdministratorAccount(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateFromMasterAccountResult> disassociateFromMasterAccountAsync(DisassociateFromMasterAccountRequest request) {
        return this.disassociateFromMasterAccountAsync(request, null);
    }

    @Override
    public Future<DisassociateFromMasterAccountResult> disassociateFromMasterAccountAsync(DisassociateFromMasterAccountRequest request, final AsyncHandler<DisassociateFromMasterAccountRequest, DisassociateFromMasterAccountResult> asyncHandler) {
        final DisassociateFromMasterAccountRequest finalRequest = (DisassociateFromMasterAccountRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisassociateFromMasterAccountResult>(){

            @Override
            public DisassociateFromMasterAccountResult call() throws Exception {
                DisassociateFromMasterAccountResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeDisassociateFromMasterAccount(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateMemberResult> disassociateMemberAsync(DisassociateMemberRequest request) {
        return this.disassociateMemberAsync(request, null);
    }

    @Override
    public Future<DisassociateMemberResult> disassociateMemberAsync(DisassociateMemberRequest request, final AsyncHandler<DisassociateMemberRequest, DisassociateMemberResult> asyncHandler) {
        final DisassociateMemberRequest finalRequest = (DisassociateMemberRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisassociateMemberResult>(){

            @Override
            public DisassociateMemberResult call() throws Exception {
                DisassociateMemberResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeDisassociateMember(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EnableMacieResult> enableMacieAsync(EnableMacieRequest request) {
        return this.enableMacieAsync(request, null);
    }

    @Override
    public Future<EnableMacieResult> enableMacieAsync(EnableMacieRequest request, final AsyncHandler<EnableMacieRequest, EnableMacieResult> asyncHandler) {
        final EnableMacieRequest finalRequest = (EnableMacieRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<EnableMacieResult>(){

            @Override
            public EnableMacieResult call() throws Exception {
                EnableMacieResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeEnableMacie(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EnableOrganizationAdminAccountResult> enableOrganizationAdminAccountAsync(EnableOrganizationAdminAccountRequest request) {
        return this.enableOrganizationAdminAccountAsync(request, null);
    }

    @Override
    public Future<EnableOrganizationAdminAccountResult> enableOrganizationAdminAccountAsync(EnableOrganizationAdminAccountRequest request, final AsyncHandler<EnableOrganizationAdminAccountRequest, EnableOrganizationAdminAccountResult> asyncHandler) {
        final EnableOrganizationAdminAccountRequest finalRequest = (EnableOrganizationAdminAccountRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<EnableOrganizationAdminAccountResult>(){

            @Override
            public EnableOrganizationAdminAccountResult call() throws Exception {
                EnableOrganizationAdminAccountResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeEnableOrganizationAdminAccount(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAdministratorAccountResult> getAdministratorAccountAsync(GetAdministratorAccountRequest request) {
        return this.getAdministratorAccountAsync(request, null);
    }

    @Override
    public Future<GetAdministratorAccountResult> getAdministratorAccountAsync(GetAdministratorAccountRequest request, final AsyncHandler<GetAdministratorAccountRequest, GetAdministratorAccountResult> asyncHandler) {
        final GetAdministratorAccountRequest finalRequest = (GetAdministratorAccountRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetAdministratorAccountResult>(){

            @Override
            public GetAdministratorAccountResult call() throws Exception {
                GetAdministratorAccountResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeGetAdministratorAccount(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetBucketStatisticsResult> getBucketStatisticsAsync(GetBucketStatisticsRequest request) {
        return this.getBucketStatisticsAsync(request, null);
    }

    @Override
    public Future<GetBucketStatisticsResult> getBucketStatisticsAsync(GetBucketStatisticsRequest request, final AsyncHandler<GetBucketStatisticsRequest, GetBucketStatisticsResult> asyncHandler) {
        final GetBucketStatisticsRequest finalRequest = (GetBucketStatisticsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetBucketStatisticsResult>(){

            @Override
            public GetBucketStatisticsResult call() throws Exception {
                GetBucketStatisticsResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeGetBucketStatistics(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetClassificationExportConfigurationResult> getClassificationExportConfigurationAsync(GetClassificationExportConfigurationRequest request) {
        return this.getClassificationExportConfigurationAsync(request, null);
    }

    @Override
    public Future<GetClassificationExportConfigurationResult> getClassificationExportConfigurationAsync(GetClassificationExportConfigurationRequest request, final AsyncHandler<GetClassificationExportConfigurationRequest, GetClassificationExportConfigurationResult> asyncHandler) {
        final GetClassificationExportConfigurationRequest finalRequest = (GetClassificationExportConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetClassificationExportConfigurationResult>(){

            @Override
            public GetClassificationExportConfigurationResult call() throws Exception {
                GetClassificationExportConfigurationResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeGetClassificationExportConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCustomDataIdentifierResult> getCustomDataIdentifierAsync(GetCustomDataIdentifierRequest request) {
        return this.getCustomDataIdentifierAsync(request, null);
    }

    @Override
    public Future<GetCustomDataIdentifierResult> getCustomDataIdentifierAsync(GetCustomDataIdentifierRequest request, final AsyncHandler<GetCustomDataIdentifierRequest, GetCustomDataIdentifierResult> asyncHandler) {
        final GetCustomDataIdentifierRequest finalRequest = (GetCustomDataIdentifierRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetCustomDataIdentifierResult>(){

            @Override
            public GetCustomDataIdentifierResult call() throws Exception {
                GetCustomDataIdentifierResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeGetCustomDataIdentifier(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetFindingStatisticsResult> getFindingStatisticsAsync(GetFindingStatisticsRequest request) {
        return this.getFindingStatisticsAsync(request, null);
    }

    @Override
    public Future<GetFindingStatisticsResult> getFindingStatisticsAsync(GetFindingStatisticsRequest request, final AsyncHandler<GetFindingStatisticsRequest, GetFindingStatisticsResult> asyncHandler) {
        final GetFindingStatisticsRequest finalRequest = (GetFindingStatisticsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetFindingStatisticsResult>(){

            @Override
            public GetFindingStatisticsResult call() throws Exception {
                GetFindingStatisticsResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeGetFindingStatistics(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetFindingsResult> getFindingsAsync(GetFindingsRequest request) {
        return this.getFindingsAsync(request, null);
    }

    @Override
    public Future<GetFindingsResult> getFindingsAsync(GetFindingsRequest request, final AsyncHandler<GetFindingsRequest, GetFindingsResult> asyncHandler) {
        final GetFindingsRequest finalRequest = (GetFindingsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetFindingsResult>(){

            @Override
            public GetFindingsResult call() throws Exception {
                GetFindingsResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeGetFindings(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetFindingsFilterResult> getFindingsFilterAsync(GetFindingsFilterRequest request) {
        return this.getFindingsFilterAsync(request, null);
    }

    @Override
    public Future<GetFindingsFilterResult> getFindingsFilterAsync(GetFindingsFilterRequest request, final AsyncHandler<GetFindingsFilterRequest, GetFindingsFilterResult> asyncHandler) {
        final GetFindingsFilterRequest finalRequest = (GetFindingsFilterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetFindingsFilterResult>(){

            @Override
            public GetFindingsFilterResult call() throws Exception {
                GetFindingsFilterResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeGetFindingsFilter(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetInvitationsCountResult> getInvitationsCountAsync(GetInvitationsCountRequest request) {
        return this.getInvitationsCountAsync(request, null);
    }

    @Override
    public Future<GetInvitationsCountResult> getInvitationsCountAsync(GetInvitationsCountRequest request, final AsyncHandler<GetInvitationsCountRequest, GetInvitationsCountResult> asyncHandler) {
        final GetInvitationsCountRequest finalRequest = (GetInvitationsCountRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetInvitationsCountResult>(){

            @Override
            public GetInvitationsCountResult call() throws Exception {
                GetInvitationsCountResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeGetInvitationsCount(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetMacieSessionResult> getMacieSessionAsync(GetMacieSessionRequest request) {
        return this.getMacieSessionAsync(request, null);
    }

    @Override
    public Future<GetMacieSessionResult> getMacieSessionAsync(GetMacieSessionRequest request, final AsyncHandler<GetMacieSessionRequest, GetMacieSessionResult> asyncHandler) {
        final GetMacieSessionRequest finalRequest = (GetMacieSessionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetMacieSessionResult>(){

            @Override
            public GetMacieSessionResult call() throws Exception {
                GetMacieSessionResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeGetMacieSession(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetMasterAccountResult> getMasterAccountAsync(GetMasterAccountRequest request) {
        return this.getMasterAccountAsync(request, null);
    }

    @Override
    public Future<GetMasterAccountResult> getMasterAccountAsync(GetMasterAccountRequest request, final AsyncHandler<GetMasterAccountRequest, GetMasterAccountResult> asyncHandler) {
        final GetMasterAccountRequest finalRequest = (GetMasterAccountRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetMasterAccountResult>(){

            @Override
            public GetMasterAccountResult call() throws Exception {
                GetMasterAccountResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeGetMasterAccount(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetMemberResult> getMemberAsync(GetMemberRequest request) {
        return this.getMemberAsync(request, null);
    }

    @Override
    public Future<GetMemberResult> getMemberAsync(GetMemberRequest request, final AsyncHandler<GetMemberRequest, GetMemberResult> asyncHandler) {
        final GetMemberRequest finalRequest = (GetMemberRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetMemberResult>(){

            @Override
            public GetMemberResult call() throws Exception {
                GetMemberResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeGetMember(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetUsageStatisticsResult> getUsageStatisticsAsync(GetUsageStatisticsRequest request) {
        return this.getUsageStatisticsAsync(request, null);
    }

    @Override
    public Future<GetUsageStatisticsResult> getUsageStatisticsAsync(GetUsageStatisticsRequest request, final AsyncHandler<GetUsageStatisticsRequest, GetUsageStatisticsResult> asyncHandler) {
        final GetUsageStatisticsRequest finalRequest = (GetUsageStatisticsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetUsageStatisticsResult>(){

            @Override
            public GetUsageStatisticsResult call() throws Exception {
                GetUsageStatisticsResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeGetUsageStatistics(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetUsageTotalsResult> getUsageTotalsAsync(GetUsageTotalsRequest request) {
        return this.getUsageTotalsAsync(request, null);
    }

    @Override
    public Future<GetUsageTotalsResult> getUsageTotalsAsync(GetUsageTotalsRequest request, final AsyncHandler<GetUsageTotalsRequest, GetUsageTotalsResult> asyncHandler) {
        final GetUsageTotalsRequest finalRequest = (GetUsageTotalsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetUsageTotalsResult>(){

            @Override
            public GetUsageTotalsResult call() throws Exception {
                GetUsageTotalsResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeGetUsageTotals(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListClassificationJobsResult> listClassificationJobsAsync(ListClassificationJobsRequest request) {
        return this.listClassificationJobsAsync(request, null);
    }

    @Override
    public Future<ListClassificationJobsResult> listClassificationJobsAsync(ListClassificationJobsRequest request, final AsyncHandler<ListClassificationJobsRequest, ListClassificationJobsResult> asyncHandler) {
        final ListClassificationJobsRequest finalRequest = (ListClassificationJobsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListClassificationJobsResult>(){

            @Override
            public ListClassificationJobsResult call() throws Exception {
                ListClassificationJobsResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeListClassificationJobs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListCustomDataIdentifiersResult> listCustomDataIdentifiersAsync(ListCustomDataIdentifiersRequest request) {
        return this.listCustomDataIdentifiersAsync(request, null);
    }

    @Override
    public Future<ListCustomDataIdentifiersResult> listCustomDataIdentifiersAsync(ListCustomDataIdentifiersRequest request, final AsyncHandler<ListCustomDataIdentifiersRequest, ListCustomDataIdentifiersResult> asyncHandler) {
        final ListCustomDataIdentifiersRequest finalRequest = (ListCustomDataIdentifiersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListCustomDataIdentifiersResult>(){

            @Override
            public ListCustomDataIdentifiersResult call() throws Exception {
                ListCustomDataIdentifiersResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeListCustomDataIdentifiers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListFindingsResult> listFindingsAsync(ListFindingsRequest request) {
        return this.listFindingsAsync(request, null);
    }

    @Override
    public Future<ListFindingsResult> listFindingsAsync(ListFindingsRequest request, final AsyncHandler<ListFindingsRequest, ListFindingsResult> asyncHandler) {
        final ListFindingsRequest finalRequest = (ListFindingsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListFindingsResult>(){

            @Override
            public ListFindingsResult call() throws Exception {
                ListFindingsResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeListFindings(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListFindingsFiltersResult> listFindingsFiltersAsync(ListFindingsFiltersRequest request) {
        return this.listFindingsFiltersAsync(request, null);
    }

    @Override
    public Future<ListFindingsFiltersResult> listFindingsFiltersAsync(ListFindingsFiltersRequest request, final AsyncHandler<ListFindingsFiltersRequest, ListFindingsFiltersResult> asyncHandler) {
        final ListFindingsFiltersRequest finalRequest = (ListFindingsFiltersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListFindingsFiltersResult>(){

            @Override
            public ListFindingsFiltersResult call() throws Exception {
                ListFindingsFiltersResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeListFindingsFilters(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListInvitationsResult> listInvitationsAsync(ListInvitationsRequest request) {
        return this.listInvitationsAsync(request, null);
    }

    @Override
    public Future<ListInvitationsResult> listInvitationsAsync(ListInvitationsRequest request, final AsyncHandler<ListInvitationsRequest, ListInvitationsResult> asyncHandler) {
        final ListInvitationsRequest finalRequest = (ListInvitationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListInvitationsResult>(){

            @Override
            public ListInvitationsResult call() throws Exception {
                ListInvitationsResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeListInvitations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListMembersResult> listMembersAsync(ListMembersRequest request) {
        return this.listMembersAsync(request, null);
    }

    @Override
    public Future<ListMembersResult> listMembersAsync(ListMembersRequest request, final AsyncHandler<ListMembersRequest, ListMembersResult> asyncHandler) {
        final ListMembersRequest finalRequest = (ListMembersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListMembersResult>(){

            @Override
            public ListMembersResult call() throws Exception {
                ListMembersResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeListMembers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListOrganizationAdminAccountsResult> listOrganizationAdminAccountsAsync(ListOrganizationAdminAccountsRequest request) {
        return this.listOrganizationAdminAccountsAsync(request, null);
    }

    @Override
    public Future<ListOrganizationAdminAccountsResult> listOrganizationAdminAccountsAsync(ListOrganizationAdminAccountsRequest request, final AsyncHandler<ListOrganizationAdminAccountsRequest, ListOrganizationAdminAccountsResult> asyncHandler) {
        final ListOrganizationAdminAccountsRequest finalRequest = (ListOrganizationAdminAccountsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListOrganizationAdminAccountsResult>(){

            @Override
            public ListOrganizationAdminAccountsResult call() throws Exception {
                ListOrganizationAdminAccountsResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeListOrganizationAdminAccounts(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutClassificationExportConfigurationResult> putClassificationExportConfigurationAsync(PutClassificationExportConfigurationRequest request) {
        return this.putClassificationExportConfigurationAsync(request, null);
    }

    @Override
    public Future<PutClassificationExportConfigurationResult> putClassificationExportConfigurationAsync(PutClassificationExportConfigurationRequest request, final AsyncHandler<PutClassificationExportConfigurationRequest, PutClassificationExportConfigurationResult> asyncHandler) {
        final PutClassificationExportConfigurationRequest finalRequest = (PutClassificationExportConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutClassificationExportConfigurationResult>(){

            @Override
            public PutClassificationExportConfigurationResult call() throws Exception {
                PutClassificationExportConfigurationResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executePutClassificationExportConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TestCustomDataIdentifierResult> testCustomDataIdentifierAsync(TestCustomDataIdentifierRequest request) {
        return this.testCustomDataIdentifierAsync(request, null);
    }

    @Override
    public Future<TestCustomDataIdentifierResult> testCustomDataIdentifierAsync(TestCustomDataIdentifierRequest request, final AsyncHandler<TestCustomDataIdentifierRequest, TestCustomDataIdentifierResult> asyncHandler) {
        final TestCustomDataIdentifierRequest finalRequest = (TestCustomDataIdentifierRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TestCustomDataIdentifierResult>(){

            @Override
            public TestCustomDataIdentifierResult call() throws Exception {
                TestCustomDataIdentifierResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeTestCustomDataIdentifier(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateClassificationJobResult> updateClassificationJobAsync(UpdateClassificationJobRequest request) {
        return this.updateClassificationJobAsync(request, null);
    }

    @Override
    public Future<UpdateClassificationJobResult> updateClassificationJobAsync(UpdateClassificationJobRequest request, final AsyncHandler<UpdateClassificationJobRequest, UpdateClassificationJobResult> asyncHandler) {
        final UpdateClassificationJobRequest finalRequest = (UpdateClassificationJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateClassificationJobResult>(){

            @Override
            public UpdateClassificationJobResult call() throws Exception {
                UpdateClassificationJobResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeUpdateClassificationJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateFindingsFilterResult> updateFindingsFilterAsync(UpdateFindingsFilterRequest request) {
        return this.updateFindingsFilterAsync(request, null);
    }

    @Override
    public Future<UpdateFindingsFilterResult> updateFindingsFilterAsync(UpdateFindingsFilterRequest request, final AsyncHandler<UpdateFindingsFilterRequest, UpdateFindingsFilterResult> asyncHandler) {
        final UpdateFindingsFilterRequest finalRequest = (UpdateFindingsFilterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateFindingsFilterResult>(){

            @Override
            public UpdateFindingsFilterResult call() throws Exception {
                UpdateFindingsFilterResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeUpdateFindingsFilter(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateMacieSessionResult> updateMacieSessionAsync(UpdateMacieSessionRequest request) {
        return this.updateMacieSessionAsync(request, null);
    }

    @Override
    public Future<UpdateMacieSessionResult> updateMacieSessionAsync(UpdateMacieSessionRequest request, final AsyncHandler<UpdateMacieSessionRequest, UpdateMacieSessionResult> asyncHandler) {
        final UpdateMacieSessionRequest finalRequest = (UpdateMacieSessionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateMacieSessionResult>(){

            @Override
            public UpdateMacieSessionResult call() throws Exception {
                UpdateMacieSessionResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeUpdateMacieSession(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateMemberSessionResult> updateMemberSessionAsync(UpdateMemberSessionRequest request) {
        return this.updateMemberSessionAsync(request, null);
    }

    @Override
    public Future<UpdateMemberSessionResult> updateMemberSessionAsync(UpdateMemberSessionRequest request, final AsyncHandler<UpdateMemberSessionRequest, UpdateMemberSessionResult> asyncHandler) {
        final UpdateMemberSessionRequest finalRequest = (UpdateMemberSessionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateMemberSessionResult>(){

            @Override
            public UpdateMemberSessionResult call() throws Exception {
                UpdateMemberSessionResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeUpdateMemberSession(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateOrganizationConfigurationResult> updateOrganizationConfigurationAsync(UpdateOrganizationConfigurationRequest request) {
        return this.updateOrganizationConfigurationAsync(request, null);
    }

    @Override
    public Future<UpdateOrganizationConfigurationResult> updateOrganizationConfigurationAsync(UpdateOrganizationConfigurationRequest request, final AsyncHandler<UpdateOrganizationConfigurationRequest, UpdateOrganizationConfigurationResult> asyncHandler) {
        final UpdateOrganizationConfigurationRequest finalRequest = (UpdateOrganizationConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateOrganizationConfigurationResult>(){

            @Override
            public UpdateOrganizationConfigurationResult call() throws Exception {
                UpdateOrganizationConfigurationResult result = null;
                try {
                    result = AmazonMacie2AsyncClient.this.executeUpdateOrganizationConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

