/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.mailmanager.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The structure for an IP based condition matching on the incoming mail.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/IngressIpToEvaluate" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class IngressIpToEvaluate implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * An enum type representing the allowed attribute types for an IP condition.
     * </p>
     */
    private String attribute;

    /**
     * <p>
     * An enum type representing the allowed attribute types for an IP condition.
     * </p>
     * 
     * @param attribute
     *        An enum type representing the allowed attribute types for an IP condition.
     * @see IngressIpv4Attribute
     */

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    /**
     * <p>
     * An enum type representing the allowed attribute types for an IP condition.
     * </p>
     * 
     * @return An enum type representing the allowed attribute types for an IP condition.
     * @see IngressIpv4Attribute
     */

    public String getAttribute() {
        return this.attribute;
    }

    /**
     * <p>
     * An enum type representing the allowed attribute types for an IP condition.
     * </p>
     * 
     * @param attribute
     *        An enum type representing the allowed attribute types for an IP condition.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see IngressIpv4Attribute
     */

    public IngressIpToEvaluate withAttribute(String attribute) {
        setAttribute(attribute);
        return this;
    }

    /**
     * <p>
     * An enum type representing the allowed attribute types for an IP condition.
     * </p>
     * 
     * @param attribute
     *        An enum type representing the allowed attribute types for an IP condition.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see IngressIpv4Attribute
     */

    public IngressIpToEvaluate withAttribute(IngressIpv4Attribute attribute) {
        this.attribute = attribute.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAttribute() != null)
            sb.append("Attribute: ").append(getAttribute());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof IngressIpToEvaluate == false)
            return false;
        IngressIpToEvaluate other = (IngressIpToEvaluate) obj;
        if (other.getAttribute() == null ^ this.getAttribute() == null)
            return false;
        if (other.getAttribute() != null && other.getAttribute().equals(this.getAttribute()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAttribute() == null) ? 0 : getAttribute().hashCode());
        return hashCode;
    }

    @Override
    public IngressIpToEvaluate clone() {
        try {
            return (IngressIpToEvaluate) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.mailmanager.model.transform.IngressIpToEvaluateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
