/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mainframemodernization.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mainframemodernization.model.DataSetImportItem;
import com.amazonaws.services.mainframemodernization.model.transform.DataSetImportConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DataSetImportConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private List<DataSetImportItem> dataSets;
    private String s3Location;

    public List<DataSetImportItem> getDataSets() {
        return this.dataSets;
    }

    public void setDataSets(Collection<DataSetImportItem> dataSets) {
        if (dataSets == null) {
            this.dataSets = null;
            return;
        }
        this.dataSets = new ArrayList<DataSetImportItem>(dataSets);
    }

    public DataSetImportConfig withDataSets(DataSetImportItem ... dataSets) {
        if (this.dataSets == null) {
            this.setDataSets(new ArrayList<DataSetImportItem>(dataSets.length));
        }
        for (DataSetImportItem ele : dataSets) {
            this.dataSets.add(ele);
        }
        return this;
    }

    public DataSetImportConfig withDataSets(Collection<DataSetImportItem> dataSets) {
        this.setDataSets(dataSets);
        return this;
    }

    public void setS3Location(String s3Location) {
        this.s3Location = s3Location;
    }

    public String getS3Location() {
        return this.s3Location;
    }

    public DataSetImportConfig withS3Location(String s3Location) {
        this.setS3Location(s3Location);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDataSets() != null) {
            sb.append("DataSets: ").append(this.getDataSets()).append(",");
        }
        if (this.getS3Location() != null) {
            sb.append("S3Location: ").append(this.getS3Location());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSetImportConfig)) {
            return false;
        }
        DataSetImportConfig other = (DataSetImportConfig)obj;
        if (other.getDataSets() == null ^ this.getDataSets() == null) {
            return false;
        }
        if (other.getDataSets() != null && !other.getDataSets().equals(this.getDataSets())) {
            return false;
        }
        if (other.getS3Location() == null ^ this.getS3Location() == null) {
            return false;
        }
        return other.getS3Location() == null || other.getS3Location().equals(this.getS3Location());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDataSets() == null ? 0 : this.getDataSets().hashCode());
        hashCode = 31 * hashCode + (this.getS3Location() == null ? 0 : this.getS3Location().hashCode());
        return hashCode;
    }

    public DataSetImportConfig clone() {
        try {
            return (DataSetImportConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DataSetImportConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

