/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.managedblockchainquery.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.managedblockchainquery.model.Transaction;
import java.util.Date;

@SdkInternalApi
public class TransactionMarshaller {
    private static final MarshallingInfo<String> NETWORK_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("network").build();
    private static final MarshallingInfo<String> BLOCKHASH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("blockHash").build();
    private static final MarshallingInfo<String> TRANSACTIONHASH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("transactionHash").build();
    private static final MarshallingInfo<String> BLOCKNUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("blockNumber").build();
    private static final MarshallingInfo<Date> TRANSACTIONTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("transactionTimestamp").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Long> TRANSACTIONINDEX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("transactionIndex").build();
    private static final MarshallingInfo<Long> NUMBEROFTRANSACTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("numberOfTransactions").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<String> TO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("to").build();
    private static final MarshallingInfo<String> FROM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("from").build();
    private static final MarshallingInfo<String> CONTRACTADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("contractAddress").build();
    private static final MarshallingInfo<String> GASUSED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gasUsed").build();
    private static final MarshallingInfo<String> CUMULATIVEGASUSED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cumulativeGasUsed").build();
    private static final MarshallingInfo<String> EFFECTIVEGASPRICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("effectiveGasPrice").build();
    private static final MarshallingInfo<Integer> SIGNATUREV_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("signatureV").build();
    private static final MarshallingInfo<String> SIGNATURER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("signatureR").build();
    private static final MarshallingInfo<String> SIGNATURES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("signatureS").build();
    private static final MarshallingInfo<String> TRANSACTIONFEE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("transactionFee").build();
    private static final MarshallingInfo<String> TRANSACTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("transactionId").build();
    private static final MarshallingInfo<String> CONFIRMATIONSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("confirmationStatus").build();
    private static final MarshallingInfo<String> EXECUTIONSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("executionStatus").build();
    private static final TransactionMarshaller instance = new TransactionMarshaller();

    public static TransactionMarshaller getInstance() {
        return instance;
    }

    public void marshall(Transaction transaction, ProtocolMarshaller protocolMarshaller) {
        if (transaction == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)transaction.getNetwork(), NETWORK_BINDING);
            protocolMarshaller.marshall((Object)transaction.getBlockHash(), BLOCKHASH_BINDING);
            protocolMarshaller.marshall((Object)transaction.getTransactionHash(), TRANSACTIONHASH_BINDING);
            protocolMarshaller.marshall((Object)transaction.getBlockNumber(), BLOCKNUMBER_BINDING);
            protocolMarshaller.marshall((Object)transaction.getTransactionTimestamp(), TRANSACTIONTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)transaction.getTransactionIndex(), TRANSACTIONINDEX_BINDING);
            protocolMarshaller.marshall((Object)transaction.getNumberOfTransactions(), NUMBEROFTRANSACTIONS_BINDING);
            protocolMarshaller.marshall((Object)transaction.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)transaction.getTo(), TO_BINDING);
            protocolMarshaller.marshall((Object)transaction.getFrom(), FROM_BINDING);
            protocolMarshaller.marshall((Object)transaction.getContractAddress(), CONTRACTADDRESS_BINDING);
            protocolMarshaller.marshall((Object)transaction.getGasUsed(), GASUSED_BINDING);
            protocolMarshaller.marshall((Object)transaction.getCumulativeGasUsed(), CUMULATIVEGASUSED_BINDING);
            protocolMarshaller.marshall((Object)transaction.getEffectiveGasPrice(), EFFECTIVEGASPRICE_BINDING);
            protocolMarshaller.marshall((Object)transaction.getSignatureV(), SIGNATUREV_BINDING);
            protocolMarshaller.marshall((Object)transaction.getSignatureR(), SIGNATURER_BINDING);
            protocolMarshaller.marshall((Object)transaction.getSignatureS(), SIGNATURES_BINDING);
            protocolMarshaller.marshall((Object)transaction.getTransactionFee(), TRANSACTIONFEE_BINDING);
            protocolMarshaller.marshall((Object)transaction.getTransactionId(), TRANSACTIONID_BINDING);
            protocolMarshaller.marshall((Object)transaction.getConfirmationStatus(), CONFIRMATIONSTATUS_BINDING);
            protocolMarshaller.marshall((Object)transaction.getExecutionStatus(), EXECUTIONSTATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

